/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityStructuralArm;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockAssembler;
import blusunrize.immersiveengineering.common.util.Utils;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class TileEntityAssembler
extends TileEntityMultiblockPart
implements ISidedInventory,
IEnergyReceiver,
IFluidHandler {
    public int facing = 2;
    public EnergyStorage energyStorage = new EnergyStorage(16000);
    public ItemStack[] inventory = new ItemStack[18];
    public CrafterPatternInventory[] patterns = new CrafterPatternInventory[]{new CrafterPatternInventory(this), new CrafterPatternInventory(this), new CrafterPatternInventory(this)};
    public FluidTank[] tanks = new FluidTank[]{new FluidTank(8000), new FluidTank(8000), new FluidTank(8000)};

    @Override
    public TileEntityAssembler master() {
        if (this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0) {
            return null;
        }
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c - this.offset[0], this.field_145848_d - this.offset[1], this.field_145849_e - this.offset[2]);
        return te instanceof TileEntityAssembler ? (TileEntityAssembler)te : null;
    }

    @Override
    public ItemStack getOriginalBlock() {
        if (this.pos < 0) {
            return null;
        }
        ItemStack s = MultiblockAssembler.instance.getStructureManual()[this.pos / 9][this.pos % 9 / 3][this.pos % 3];
        return s != null ? s.func_77946_l() : null;
    }

    public void func_145845_h() {
        if (!this.formed || this.pos != 13) {
            return;
        }
        if (this.field_145850_b.field_72995_K || this.field_145850_b.func_82737_E() % 16L != (long)((this.field_145851_c ^ this.field_145849_e) & 0xF)) {
            return;
        }
        boolean update = false;
        ItemStack[][] outputBuffer = new ItemStack[this.patterns.length][0];
        for (int p = 0; p < this.patterns.length; ++p) {
            CrafterPatternInventory pattern = this.patterns[p];
            if (pattern.inv[9] == null) continue;
            ItemStack output = pattern.inv[9].func_77946_l();
            ArrayList<ItemStack> queryList = new ArrayList<ItemStack>();
            ItemStack[][] arr$ = outputBuffer;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                ItemStack[] itemStackArray;
                for (ItemStack stack : itemStackArray = arr$[i$]) {
                    if (stack == null) continue;
                    queryList.add(stack.func_77946_l());
                }
            }
            for (ItemStack[] itemStackArray : this.inventory) {
                if (itemStackArray == null) continue;
                queryList.add(itemStackArray.func_77946_l());
            }
            int consumed = Config.getInt("assembler_consumption");
            if (!this.hasIngredients(pattern, queryList) || this.energyStorage.extractEnergy(consumed, true) != consumed) continue;
            this.energyStorage.extractEnergy(consumed, false);
            ArrayList<ItemStack> outputList = new ArrayList<ItemStack>();
            outputList.add(output);
            Object[] oreInputs = null;
            ArrayList arrayList = new ArrayList();
            if (pattern.recipe instanceof ShapedOreRecipe || pattern.recipe instanceof ShapelessOreRecipe) {
                oreInputs = pattern.recipe instanceof ShapedOreRecipe ? ((ShapedOreRecipe)pattern.recipe).getInput() : ((ShapelessOreRecipe)pattern.recipe).getInput().toArray();
            }
            for (int i = 0; i < 9; ++i) {
                if (pattern.inv[i] == null) continue;
                Object query = pattern.inv[i].func_77946_l();
                int querySize = pattern.inv[i].field_77994_a;
                if (FluidContainerRegistry.getFluidForFilledItem((ItemStack)pattern.inv[i]) != null) {
                    FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)pattern.inv[i]);
                    fs.amount *= querySize;
                    boolean hasFluid = false;
                    for (FluidTank tank : this.tanks) {
                        if (tank.getFluid() == null || !tank.getFluid().containsFluid(fs)) continue;
                        hasFluid = true;
                        break;
                    }
                    if (hasFluid) {
                        query = fs;
                    }
                }
                if (query instanceof ItemStack && oreInputs != null) {
                    for (int iOre = 0; iOre < oreInputs.length; ++iOre) {
                        if (arrayList.contains(iOre) || !Utils.stackMatchesObject(query, oreInputs[iOre])) continue;
                        query = oreInputs[iOre];
                        querySize = 1;
                        break;
                    }
                }
                boolean taken = false;
                for (int j = 0; j < outputBuffer.length && !(taken = this.consumeItem(query, querySize, outputBuffer[j], outputList)); ++j) {
                }
                if (taken) continue;
                this.consumeItem(query, querySize, this.inventory, outputList);
            }
            outputBuffer[p] = outputList.toArray(new ItemStack[outputList.size()]);
            update = true;
        }
        TileEntity inventory = this.field_145850_b.func_147438_o(this.field_145851_c + (this.facing == 4 ? 2 : (this.facing == 5 ? -2 : 0)), this.field_145848_d, this.field_145849_e + (this.facing == 2 ? 2 : (this.facing == 3 ? -2 : 0)));
        for (int buffer = 0; buffer < outputBuffer.length; ++buffer) {
            if (outputBuffer[buffer] == null || outputBuffer[buffer].length <= 0) continue;
            for (ItemStack output : outputBuffer[buffer]) {
                int n;
                if (output == null || output.field_77994_a <= 0) continue;
                boolean isRecipeIngredient = false;
                if (buffer - 1 < outputBuffer.length) {
                    block10: for (n = buffer + 1; n < this.patterns.length; ++n) {
                        CrafterPatternInventory pattern = this.patterns[n];
                        for (int i = 0; i < 9; ++i) {
                            if (pattern.inv[i] == null || !OreDictionary.itemMatches((ItemStack)pattern.inv[i], (ItemStack)output, (boolean)false)) continue;
                            isRecipeIngredient = true;
                            continue block10;
                        }
                    }
                }
                if (!isRecipeIngredient && (inventory instanceof ISidedInventory && ((ISidedInventory)inventory).func_94128_d(this.facing).length > 0 || inventory instanceof IInventory && ((IInventory)inventory).func_70302_i_() > 0) && ((output = Utils.insertStackIntoInventory((IInventory)inventory, output, this.facing)) == null || output.field_77994_a <= 0)) continue;
                n = -1;
                for (int i = 0; i < this.inventory.length; ++i) {
                    if (this.inventory[i] == null && n < 0) {
                        n = i;
                        continue;
                    }
                    if (this.inventory[i] == null || !OreDictionary.itemMatches((ItemStack)output, (ItemStack)this.inventory[i], (boolean)true) || this.inventory[i].field_77994_a + output.field_77994_a > this.inventory[i].func_77976_d()) continue;
                    this.inventory[i].field_77994_a += output.field_77994_a;
                    n = -1;
                    break;
                }
                if (n < 0) continue;
                this.inventory[n] = output.func_77946_l();
            }
        }
        if (update) {
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public boolean consumeItem(Object query, int querySize, ItemStack[] inventory, ArrayList<ItemStack> containerItems) {
        if (query instanceof FluidStack) {
            for (FluidTank tank : this.tanks) {
                if (tank.getFluid() == null || !tank.getFluid().containsFluid((FluidStack)query)) continue;
                tank.drain(((FluidStack)query).amount, true);
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return true;
            }
        }
        for (int i = 0; i < inventory.length; ++i) {
            if (inventory[i] == null || !Utils.stackMatchesObject(inventory[i], query)) continue;
            int taken = Math.min(querySize, inventory[i].field_77994_a);
            boolean doTake = true;
            if (inventory[i].func_77973_b().hasContainerItem(inventory[i])) {
                ItemStack container = inventory[i].func_77973_b().getContainerItem(inventory[i]);
                if (container != null && inventory[i].func_77973_b().func_77630_h(inventory[i])) {
                    containerItems.add(container.func_77946_l());
                    if (inventory[i].field_77994_a - taken <= 0) {
                        inventory[i] = null;
                        doTake = false;
                    }
                } else if (inventory[i].field_77994_a - taken <= 0) {
                    inventory[i] = container;
                    doTake = false;
                }
            }
            if (doTake) {
                inventory[i].field_77994_a -= taken;
                if (inventory[i].field_77994_a <= 0) {
                    inventory[i] = null;
                }
            }
            if ((querySize -= taken) <= 0) break;
        }
        return query == null || querySize <= 0;
    }

    public boolean hasIngredients(CrafterPatternInventory pattern, ArrayList<ItemStack> queryList) {
        Object[] oreInputs = null;
        ArrayList usedOreSlots = new ArrayList();
        if (pattern.recipe instanceof ShapedOreRecipe || pattern.recipe instanceof ShapelessOreRecipe) {
            oreInputs = pattern.recipe instanceof ShapedOreRecipe ? ((ShapedOreRecipe)pattern.recipe).getInput() : ((ShapelessOreRecipe)pattern.recipe).getInput().toArray();
        }
        boolean match = true;
        for (int i = 0; i < 9; ++i) {
            if (pattern.inv[i] == null) continue;
            if (FluidContainerRegistry.getFluidForFilledItem((ItemStack)pattern.inv[i]) != null) {
                FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)pattern.inv[i]);
                boolean hasFluid = false;
                for (FluidTank tank : this.tanks) {
                    if (tank.getFluid() == null || !tank.getFluid().containsFluid(fs)) continue;
                    hasFluid = true;
                    break;
                }
                if (hasFluid) continue;
            }
            Object query = pattern.inv[i].func_77946_l();
            int querySize = pattern.inv[i].field_77994_a;
            if (oreInputs != null) {
                for (int iOre = 0; iOre < oreInputs.length; ++iOre) {
                    if (usedOreSlots.contains(iOre) || !Utils.stackMatchesObject(query, oreInputs[iOre])) continue;
                    query = oreInputs[iOre];
                    querySize = 1;
                    break;
                }
            }
            Iterator<ItemStack> it = queryList.iterator();
            while (it.hasNext()) {
                ItemStack next = it.next();
                if (!Utils.stackMatchesObject(next, query)) continue;
                int taken = Math.min(querySize, next.field_77994_a);
                next.field_77994_a -= taken;
                if (next.field_77994_a <= 0) {
                    it.remove();
                }
                if ((querySize -= taken) > 0) continue;
                break;
            }
            if (querySize <= 0) continue;
            match = false;
            break;
        }
        return match;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = nbt.func_74762_e("facing");
        this.energyStorage.readFromNBT(nbt);
        this.tanks[0].readFromNBT(nbt.func_74775_l("tank0"));
        this.tanks[1].readFromNBT(nbt.func_74775_l("tank1"));
        this.tanks[2].readFromNBT(nbt.func_74775_l("tank2"));
        if (!descPacket) {
            NBTTagList invList = nbt.func_150295_c("inventory", 10);
            for (int i = 0; i < invList.func_74745_c(); ++i) {
                NBTTagCompound itemTag = invList.func_150305_b(i);
                int slot = itemTag.func_74771_c("Slot") & 0xFF;
                if (slot < 0 || slot >= this.inventory.length) continue;
                this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)itemTag);
            }
            for (int iPattern = 0; iPattern < this.patterns.length; ++iPattern) {
                NBTTagList patternList = nbt.func_150295_c("pattern" + iPattern, 10);
                this.patterns[iPattern] = new CrafterPatternInventory(this);
                this.patterns[iPattern].readFromNBT(patternList);
            }
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("facing", this.facing);
        this.energyStorage.writeToNBT(nbt);
        NBTTagCompound tankTag0 = this.tanks[0].writeToNBT(new NBTTagCompound());
        nbt.func_74782_a("tank0", (NBTBase)tankTag0);
        NBTTagCompound tankTag1 = this.tanks[1].writeToNBT(new NBTTagCompound());
        nbt.func_74782_a("tank1", (NBTBase)tankTag1);
        NBTTagCompound tankTag2 = this.tanks[2].writeToNBT(new NBTTagCompound());
        nbt.func_74782_a("tank2", (NBTBase)tankTag2);
        if (!descPacket) {
            NBTTagList invList = new NBTTagList();
            for (int i = 0; i < this.inventory.length; ++i) {
                if (this.inventory[i] == null) continue;
                NBTTagCompound itemTag = new NBTTagCompound();
                itemTag.func_74774_a("Slot", (byte)i);
                this.inventory[i].func_77955_b(itemTag);
                invList.func_74742_a((NBTBase)itemTag);
            }
            nbt.func_74782_a("inventory", (NBTBase)invList);
            for (int iPattern = 0; iPattern < this.patterns.length; ++iPattern) {
                NBTTagList patternList = new NBTTagList();
                this.patterns[iPattern].writeToNBT(patternList);
                nbt.func_74782_a("pattern" + iPattern, (NBTBase)patternList);
            }
        }
    }

    public boolean func_145842_c(int id, int arg) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.pos == 4) {
            return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 2));
        }
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return super.func_145833_n() * Config.getDouble("increasedTileRenderdistance");
    }

    @Override
    public float[] getBlockBounds() {
        if (this.pos < 9 || this.pos == 10 || this.pos == 13 || this.pos == 16 || this.pos == 22) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
        }
        float xMin = 0.0f;
        float yMin = 0.0f;
        float zMin = 0.0f;
        float xMax = 1.0f;
        float yMax = 1.0f;
        float zMax = 1.0f;
        if (this.pos % 9 < 3 && this.facing == 2 || this.pos % 9 >= 6 && this.facing == 3) {
            zMin = 0.25f;
        } else if (this.pos % 9 < 3 && this.facing == 3 || this.pos % 9 >= 6 && this.facing == 2) {
            zMax = 0.75f;
        } else if (this.pos % 9 < 3 && this.facing == 4 || this.pos % 9 >= 6 && this.facing == 5) {
            xMin = 0.25f;
        } else if (this.pos % 9 < 3 && this.facing == 5 || this.pos % 9 >= 6 && this.facing == 4) {
            xMax = 0.75f;
        }
        if (this.pos % 3 == 0 && this.facing == 4 || this.pos % 3 == 2 && this.facing == 5) {
            zMin = 0.1875f;
        } else if (this.pos % 3 == 0 && this.facing == 5 || this.pos % 3 == 2 && this.facing == 4) {
            zMax = 0.8125f;
        } else if (this.pos % 3 == 0 && this.facing == 3 || this.pos % 3 == 2 && this.facing == 2) {
            xMin = 0.1875f;
        } else if (this.pos % 3 == 0 && this.facing == 2 || this.pos % 3 == 2 && this.facing == 3) {
            xMax = 0.8125f;
        }
        return new float[]{xMin, yMin, zMin, xMax, yMax, zMax};
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.formed && !this.field_145850_b.field_72995_K) {
            TileEntityAssembler master = this.master();
            if (master == null) {
                master = this;
            }
            int startX = master.field_145851_c;
            int startY = master.field_145848_d;
            int startZ = master.field_145849_e;
            for (int yy = -1; yy <= 1; ++yy) {
                for (int zz = -1; zz <= 1; ++zz) {
                    for (int xx = -1; xx <= 1; ++xx) {
                        ItemStack s = null;
                        TileEntity te = this.field_145850_b.func_147438_o(startX + xx, startY + yy, startZ + zz);
                        if (te instanceof TileEntityAssembler) {
                            s = ((TileEntityAssembler)te).getOriginalBlock();
                            ((TileEntityAssembler)te).formed = false;
                        }
                        if (startX + xx == this.field_145851_c && startY + yy == this.field_145848_d && startZ + zz == this.field_145849_e) {
                            s = this.getOriginalBlock();
                        }
                        if (s == null || Block.func_149634_a((Item)s.func_77973_b()) == null) continue;
                        if (startX + xx == this.field_145851_c && startY + yy == this.field_145848_d && startZ + zz == this.field_145849_e) {
                            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, s));
                        } else {
                            if (Block.func_149634_a((Item)s.func_77973_b()) == IEContent.blockMetalMultiblocks) {
                                this.field_145850_b.func_147468_f(startX + xx, startY + yy, startZ + zz);
                            }
                            this.field_145850_b.func_147465_d(startX + xx, startY + yy, startZ + zz, Block.func_149634_a((Item)s.func_77973_b()), s.func_77960_j(), 3);
                        }
                        TileEntity tile = this.field_145850_b.func_147438_o(startX + xx, startY + yy, startZ + zz);
                        if (!(tile instanceof TileEntityStructuralArm)) continue;
                        ((TileEntityStructuralArm)tile).facing = this.facing < 4 ? (xx == -1 ? 4 : 5) : (zz == -1 ? 2 : 3);
                    }
                }
            }
        }
    }

    public int func_70302_i_() {
        if (!this.formed) {
            return 0;
        }
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        if (!this.formed) {
            return null;
        }
        if (this.master() != null) {
            return this.master().func_70301_a(slot);
        }
        if (slot < this.inventory.length) {
            return this.inventory[slot];
        }
        return null;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (!this.formed) {
            return null;
        }
        if (this.master() != null) {
            return this.master().func_70298_a(slot, amount);
        }
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amount);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        this.func_70296_d();
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        if (!this.formed) {
            return null;
        }
        if (this.master() != null) {
            return this.master().func_70304_b(slot);
        }
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
        }
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (!this.formed) {
            return;
        }
        if (this.master() != null) {
            this.master().func_70299_a(slot, stack);
            return;
        }
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return "IEAssembler";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : this.formed && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (!this.formed || stack == null) {
            return false;
        }
        if (this.master() != null) {
            return this.master().func_94041_b(slot, stack);
        }
        return true;
    }

    public int[] func_94128_d(int side) {
        if (!this.formed) {
            return new int[0];
        }
        if (this.pos == 10 || this.pos == 16) {
            return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17};
        }
        return new int[0];
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        if (!this.formed) {
            return true;
        }
        if (this.master() == null) {
            return this.func_94041_b(slot, stack);
        }
        if (this.pos == 10) {
            return this.master().func_102007_a(slot, stack, side);
        }
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        if (!this.formed) {
            return true;
        }
        if (this.master() == null) {
            return true;
        }
        if (this.pos == 16) {
            return this.master().func_102008_b(slot, stack, side);
        }
        return false;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.formed && this.pos == 22 && from == ForgeDirection.UP;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.formed && this.pos == 22 && from == ForgeDirection.UP && this.master() != null) {
            TileEntityAssembler master = this.master();
            int rec = master.energyStorage.receiveEnergy(maxReceive, simulate);
            master.func_70296_d();
            if (rec > 0) {
                this.field_145850_b.func_147471_g(this.master().field_145851_c, this.master().field_145848_d, this.master().field_145849_e);
            }
            return rec;
        }
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        if (this.master() != null) {
            return this.master().energyStorage.getEnergyStored();
        }
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.master() != null) {
            return this.master().energyStorage.getMaxEnergyStored();
        }
        return this.energyStorage.getMaxEnergyStored();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (this.master() != null) {
            return this.master().fill(from, resource, doFill);
        }
        int fill = -1;
        for (FluidTank tank : this.tanks) {
            if (tank.getFluid() == null || !tank.getFluid().isFluidEqual(resource)) continue;
            fill = tank.fill(resource, doFill);
            break;
        }
        if (fill == -1) {
            FluidTank tank;
            FluidTank[] arr$ = this.tanks;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (fill = (tank = arr$[i$]).fill(resource, doFill)) <= 0; ++i$) {
            }
        }
        if (fill > 0) {
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return fill < 0 ? 0 : fill;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.formed && this.pos == 1 && from == ForgeDirection.getOrientation((int)this.facing);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (this.master() != null) {
            return this.master().getTankInfo(from);
        }
        return new FluidTankInfo[]{this.tanks[0].getInfo(), this.tanks[1].getInfo(), this.tanks[2].getInfo()};
    }

    public static class CrafterPatternInventory
    implements IInventory {
        public ItemStack[] inv = new ItemStack[10];
        public IRecipe recipe;
        final TileEntityAssembler tile;

        public CrafterPatternInventory(TileEntityAssembler tile) {
            this.tile = tile;
        }

        public int func_70302_i_() {
            return 10;
        }

        public ItemStack func_70301_a(int slot) {
            return this.inv[slot];
        }

        public ItemStack func_70298_a(int slot, int amount) {
            ItemStack stack = this.func_70301_a(slot);
            if (slot < 9 && stack != null) {
                if (stack.field_77994_a <= amount) {
                    this.func_70299_a(slot, null);
                } else {
                    stack = stack.func_77979_a(amount);
                    if (stack.field_77994_a == 0) {
                        this.func_70299_a(slot, null);
                    }
                }
            }
            return stack;
        }

        public ItemStack func_70304_b(int slot) {
            ItemStack stack = this.func_70301_a(slot);
            if (stack != null) {
                this.func_70299_a(slot, null);
            }
            return stack;
        }

        public void func_70299_a(int slot, ItemStack stack) {
            if (slot < 9) {
                this.inv[slot] = stack;
                if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
                    stack.field_77994_a = this.func_70297_j_();
                }
            }
            this.recalculateOutput();
        }

        public void recalculateOutput() {
            Utils.InventoryCraftingFalse invC = new Utils.InventoryCraftingFalse(3, 3);
            for (int j = 0; j < 9; ++j) {
                invC.func_70299_a(j, this.inv[j]);
            }
            this.recipe = Utils.findRecipe(invC, this.tile.func_145831_w());
            this.inv[9] = this.recipe != null ? this.recipe.func_77572_b((InventoryCrafting)invC) : null;
        }

        public String func_145825_b() {
            return "IECrafterPattern";
        }

        public boolean func_145818_k_() {
            return false;
        }

        public int func_70297_j_() {
            return 1;
        }

        public boolean func_70300_a(EntityPlayer player) {
            return true;
        }

        public void func_70295_k_() {
        }

        public void func_70305_f() {
        }

        public boolean func_94041_b(int slot, ItemStack stack) {
            return true;
        }

        public void func_70296_d() {
            this.tile.func_70296_d();
        }

        public void writeToNBT(NBTTagList list) {
            for (int i = 0; i < this.inv.length; ++i) {
                if (this.inv[i] == null) continue;
                NBTTagCompound itemTag = new NBTTagCompound();
                itemTag.func_74774_a("Slot", (byte)i);
                this.inv[i].func_77955_b(itemTag);
                list.func_74742_a((NBTBase)itemTag);
            }
        }

        public void readFromNBT(NBTTagList list) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound itemTag = list.func_150305_b(i);
                int slot = itemTag.func_74771_c("Slot") & 0xFF;
                if (slot < 0 || slot >= this.func_70302_i_()) continue;
                this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)itemTag);
            }
            this.recalculateOutput();
        }
    }
}

