/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.ItemBlockIEBase;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockIEBase
extends BlockContainer {
    public String name;
    public String[] subNames;
    public final IIcon[][] icons;
    protected final int iconDimensions;
    public boolean hasFlavour = false;
    public boolean isFlammable = false;
    public int[] lightOpacities;

    protected BlockIEBase(String name, Material mat, int iconDimensions, Class<? extends ItemBlockIEBase> itemBlock, String ... subNames) {
        super(mat);
        this.adjustSound();
        this.subNames = subNames;
        this.name = name;
        this.iconDimensions = iconDimensions;
        this.icons = new IIcon[subNames.length][iconDimensions];
        this.lightOpacities = new int[subNames.length];
        this.func_149663_c("ImmersiveEngineering." + name);
        GameRegistry.registerBlock((Block)this, itemBlock, (String)name);
        this.func_149647_a(ImmersiveEngineering.creativeTab);
    }

    public BlockIEBase setFlammable(boolean b) {
        this.isFlammable = b;
        return this;
    }

    public BlockIEBase setHasFlavour(boolean hasFlavour) {
        this.hasFlavour = hasFlavour;
        return this;
    }

    public BlockIEBase setMetaLightOpacity(int meta, int opacity) {
        if (meta >= 0 && meta < this.lightOpacities.length) {
            this.lightOpacities[meta] = opacity;
        }
        return this;
    }

    void adjustSound() {
        if (this.field_149764_J == Material.field_151574_g) {
            this.field_149762_H = Block.field_149788_p;
        } else if (this.field_149764_J == Material.field_151593_r || this.field_149764_J == Material.field_151580_n) {
            this.field_149762_H = Block.field_149775_l;
        } else if (this.field_149764_J == Material.field_151592_s || this.field_149764_J == Material.field_151588_w) {
            this.field_149762_H = Block.field_149778_k;
        } else if (this.field_149764_J == Material.field_151577_b || this.field_149764_J == Material.field_151590_u || this.field_149764_J == Material.field_151585_k || this.field_149764_J == Material.field_151582_l) {
            this.field_149762_H = Block.field_149779_h;
        } else if (this.field_149764_J == Material.field_151578_c) {
            this.field_149762_H = Block.field_149767_g;
        } else if (this.field_149764_J == Material.field_151573_f) {
            this.field_149762_H = Block.field_149777_j;
        } else if (this.field_149764_J == Material.field_151595_p) {
            this.field_149762_H = Block.field_149776_m;
        } else if (this.field_149764_J == Material.field_151597_y) {
            this.field_149762_H = Block.field_149773_n;
        } else if (this.field_149764_J == Material.field_151576_e) {
            this.field_149762_H = Block.field_149769_e;
        } else if (this.field_149764_J == Material.field_151575_d || this.field_149764_J == Material.field_151570_A) {
            this.field_149762_H = Block.field_149766_f;
        }
    }

    public int getLightOpacity(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta >= 0 && meta < this.lightOpacities.length) {
            return this.lightOpacities[meta];
        }
        return this.func_149717_k();
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < this.subNames.length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.isFlammable;
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.isFlammable ? 20 : 0;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.isFlammable ? 5 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta < this.icons.length) {
            return this.icons[meta][this.getSideForTexture(side)];
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        if (meta < this.icons.length) {
            return this.icons[meta][this.getSideForTexture(side)];
        }
        return null;
    }

    protected int getSideForTexture(int side) {
        if (this.iconDimensions == 2) {
            return side == 0 || side == 1 ? 0 : 1;
        }
        if (this.iconDimensions == 4) {
            return side < 2 ? side : (side == 2 || side == 3 ? 2 : 3);
        }
        return Math.min(side, this.iconDimensions - 1);
    }

    public abstract boolean allowHammerHarvest(int var1);

    public boolean isToolEffective(String type, int metadata) {
        if ("IE_HAMMER".equals(type) && this.allowHammerHarvest(metadata)) {
            return true;
        }
        return super.isToolEffective(type, metadata);
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        if (this.func_149688_o().func_76229_l()) {
            return true;
        }
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (stack != null && stack.func_77973_b().getToolClasses(stack).contains("IE_HAMMER") && this.allowHammerHarvest(meta)) {
            return this.getHarvestLevel(meta) < stack.func_77973_b().getHarvestLevel(stack, "IE_HAMMER");
        }
        return super.canHarvestBlock(player, meta);
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 vec0, Vec3 vec1) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        Vec3 playerVec = vec0;
        vec0 = vec0.func_72441_c((double)(-x), (double)(-y), (double)(-z));
        vec1 = vec1.func_72441_c((double)(-x), (double)(-y), (double)(-z));
        if (this instanceof IEBlockInterfaces.ICustomBoundingboxes) {
            ArrayList<AxisAlignedBB> list = ((IEBlockInterfaces.ICustomBoundingboxes)((Object)this)).addCustomSelectionBoxesToList(world, x, y, z);
            if (list.isEmpty()) {
                return this.doRayTraceOnBox(world, x, y, z, vec0, vec1, AxisAlignedBB.func_72330_a((double)this.field_149759_B, (double)this.field_149760_C, (double)this.field_149754_D, (double)this.field_149755_E, (double)this.field_149756_F, (double)this.field_149757_G));
            }
            MovingObjectPosition hit = null;
            double dist = 0.0;
            for (AxisAlignedBB aabb : list) {
                MovingObjectPosition mop = this.doRayTraceOnBox(world, x, y, z, vec0, vec1, aabb);
                if (mop == null) continue;
                double newDist = playerVec.func_72438_d(mop.field_72307_f);
                if (hit != null && !(newDist < dist)) continue;
                hit = mop;
                dist = newDist;
            }
            return hit;
        }
        return this.doRayTraceOnBox(world, x, y, z, vec0, vec1, AxisAlignedBB.func_72330_a((double)this.field_149759_B, (double)this.field_149760_C, (double)this.field_149754_D, (double)this.field_149755_E, (double)this.field_149756_F, (double)this.field_149757_G));
    }

    protected MovingObjectPosition doRayTraceOnBox(World world, int x, int y, int z, Vec3 vec0, Vec3 vec1, AxisAlignedBB box) {
        Vec3 vecMinX = vec0.func_72429_b(vec1, box.field_72340_a);
        Vec3 vecMaxX = vec0.func_72429_b(vec1, box.field_72336_d);
        Vec3 vecMinY = vec0.func_72435_c(vec1, box.field_72338_b);
        Vec3 vecMaxY = vec0.func_72435_c(vec1, box.field_72337_e);
        Vec3 vecMinZ = vec0.func_72434_d(vec1, box.field_72339_c);
        Vec3 vecMaxZ = vec0.func_72434_d(vec1, box.field_72334_f);
        if (!this.isVecInsideYZBounds(world, x, y, z, vecMinX, box)) {
            vecMinX = null;
        }
        if (!this.isVecInsideYZBounds(world, x, y, z, vecMaxX, box)) {
            vecMaxX = null;
        }
        if (!this.isVecInsideXZBounds(world, x, y, z, vecMinY, box)) {
            vecMinY = null;
        }
        if (!this.isVecInsideXZBounds(world, x, y, z, vecMaxY, box)) {
            vecMaxY = null;
        }
        if (!this.isVecInsideXYBounds(world, x, y, z, vecMinZ, box)) {
            vecMinZ = null;
        }
        if (!this.isVecInsideXYBounds(world, x, y, z, vecMaxZ, box)) {
            vecMaxZ = null;
        }
        Vec3 vec38 = null;
        if (vecMinX != null && (vec38 == null || vec0.func_72436_e(vecMinX) < vec0.func_72436_e(vec38))) {
            vec38 = vecMinX;
        }
        if (vecMaxX != null && (vec38 == null || vec0.func_72436_e(vecMaxX) < vec0.func_72436_e(vec38))) {
            vec38 = vecMaxX;
        }
        if (vecMinY != null && (vec38 == null || vec0.func_72436_e(vecMinY) < vec0.func_72436_e(vec38))) {
            vec38 = vecMinY;
        }
        if (vecMaxY != null && (vec38 == null || vec0.func_72436_e(vecMaxY) < vec0.func_72436_e(vec38))) {
            vec38 = vecMaxY;
        }
        if (vecMinZ != null && (vec38 == null || vec0.func_72436_e(vecMinZ) < vec0.func_72436_e(vec38))) {
            vec38 = vecMinZ;
        }
        if (vecMaxZ != null && (vec38 == null || vec0.func_72436_e(vecMaxZ) < vec0.func_72436_e(vec38))) {
            vec38 = vecMaxZ;
        }
        if (vec38 == null) {
            return null;
        }
        int b0 = -1;
        if (vec38 == vecMinX) {
            b0 = 4;
        }
        if (vec38 == vecMaxX) {
            b0 = 5;
        }
        if (vec38 == vecMinY) {
            b0 = 0;
        }
        if (vec38 == vecMaxY) {
            b0 = 1;
        }
        if (vec38 == vecMinZ) {
            b0 = 2;
        }
        if (vec38 == vecMaxZ) {
            b0 = 3;
        }
        return new MovingObjectPosition(x, y, z, b0, vec38.func_72441_c((double)x, (double)y, (double)z));
    }

    protected boolean isVecInsideYZBounds(World world, int x, int y, int z, Vec3 vec, AxisAlignedBB box) {
        return vec == null ? false : vec.field_72448_b >= box.field_72338_b && vec.field_72448_b <= box.field_72337_e && vec.field_72449_c >= box.field_72339_c && vec.field_72449_c <= box.field_72334_f;
    }

    protected boolean isVecInsideXZBounds(World world, int x, int y, int z, Vec3 vec, AxisAlignedBB box) {
        return vec == null ? false : vec.field_72450_a >= box.field_72340_a && vec.field_72450_a <= box.field_72336_d && vec.field_72449_c >= box.field_72339_c && vec.field_72449_c <= box.field_72334_f;
    }

    protected boolean isVecInsideXYBounds(World world, int x, int y, int z, Vec3 vec, AxisAlignedBB box) {
        return vec == null ? false : vec.field_72450_a >= box.field_72340_a && vec.field_72450_a <= box.field_72336_d && vec.field_72448_b >= box.field_72338_b && vec.field_72448_b <= box.field_72337_e;
    }

    protected void addCollisionBox(World world, int x, int y, int z, AxisAlignedBB aabb, List list, Entity ent) {
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((double)y + this.field_149756_F), (double)((double)z + this.field_149757_G));
        if (box != null && aabb.func_72326_a(box)) {
            list.add(box);
        }
    }

    public static class BlockIESimple
    extends BlockIEBase {
        public BlockIESimple(String name, Material mat, Class<? extends ItemBlockIEBase> itemBlock, String ... subNames) {
            super(name, mat, 1, itemBlock, subNames);
        }

        public void func_149651_a(IIconRegister iconRegister) {
            for (int i = 0; i < this.subNames.length; ++i) {
                this.icons[i][0] = iconRegister.func_94245_a("immersiveengineering:" + this.name + "_" + this.subNames[i]);
            }
        }

        public boolean hasTileEntity(int metadata) {
            return false;
        }

        public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
            return null;
        }

        @Override
        public boolean allowHammerHarvest(int metadata) {
            return false;
        }
    }
}

