/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common;

import blusunrize.immersiveengineering.api.DimensionChunkCoords;
import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.util.IELogger;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;

public class IESaveData
extends WorldSavedData {
    private static IESaveData INSTANCE;
    public static final String dataName = "ImmersiveEngineering-SaveData";

    public IESaveData(String s) {
        super(s);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        int[] savedDimensions;
        boolean validateConnections = Config.getBoolean("validateConnections");
        int invalidConnectionsDropped = 0;
        for (int dim : savedDimensions = nbt.func_74759_k("savedDimensions")) {
            NBTTagList connectionList = nbt.func_150295_c("connectionList" + dim, 10);
            WorldServer world = MinecraftServer.func_71276_C().func_71218_a(dim);
            if (world == null) continue;
            ImmersiveNetHandler.INSTANCE.clearAllConnections((World)world);
            for (int i = 0; i < connectionList.func_74745_c(); ++i) {
                NBTTagCompound conTag = connectionList.func_150305_b(i);
                ImmersiveNetHandler.Connection con = ImmersiveNetHandler.Connection.readFromNBT(conTag);
                if (con == null) continue;
                if (validateConnections) {
                    if (world.func_147438_o(con.start.field_71574_a, con.start.field_71572_b, con.start.field_71573_c) instanceof IImmersiveConnectable && world.func_147438_o(con.end.field_71574_a, con.end.field_71572_b, con.end.field_71573_c) instanceof IImmersiveConnectable) {
                        ImmersiveNetHandler.INSTANCE.addConnection((World)world, con.start, con);
                        continue;
                    }
                    ++invalidConnectionsDropped;
                    continue;
                }
                ImmersiveNetHandler.INSTANCE.addConnection((World)world, con.start, con);
            }
        }
        if (validateConnections) {
            IELogger.info("removed " + invalidConnectionsDropped + " invalid connections from world");
        }
        NBTTagList mineralList = nbt.func_150295_c("mineralDepletion", 10);
        ExcavatorHandler.mineralCache.clear();
        for (int i = 0; i < mineralList.func_74745_c(); ++i) {
            NBTTagCompound tag = mineralList.func_150305_b(i);
            DimensionChunkCoords coords = DimensionChunkCoords.readFromNBT(tag);
            if (coords == null) continue;
            ExcavatorHandler.MineralWorldInfo info = ExcavatorHandler.MineralWorldInfo.readFromNBT(tag.func_74775_l("info"));
            ExcavatorHandler.mineralCache.put(coords, info);
        }
    }

    public void func_76187_b(NBTTagCompound nbt) {
        Integer[] relDim = ImmersiveNetHandler.INSTANCE.getRelevantDimensions().toArray(new Integer[0]);
        int[] savedDimensions = new int[relDim.length];
        for (int ii = 0; ii < relDim.length; ++ii) {
            savedDimensions[ii] = relDim[ii];
        }
        nbt.func_74783_a("savedDimensions", savedDimensions);
        for (int dim : savedDimensions) {
            WorldServer world = MinecraftServer.func_71276_C().func_71218_a(dim);
            if (world == null) continue;
            NBTTagList connectionList = new NBTTagList();
            for (ImmersiveNetHandler.Connection con : ImmersiveNetHandler.INSTANCE.getAllConnections((World)world)) {
                connectionList.func_74742_a((NBTBase)con.writeToNBT());
            }
            nbt.func_74782_a("connectionList" + dim, (NBTBase)connectionList);
        }
        NBTTagList mineralList = new NBTTagList();
        for (Map.Entry<DimensionChunkCoords, ExcavatorHandler.MineralWorldInfo> e : ExcavatorHandler.mineralCache.entrySet()) {
            if (e.getKey() == null || e.getValue() == null) continue;
            NBTTagCompound tag = e.getKey().writeToNBT();
            tag.func_74782_a("info", (NBTBase)e.getValue().writeToNBT());
            mineralList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("mineralDepletion", (NBTBase)mineralList);
    }

    public static void setDirty(int dimension) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && INSTANCE != null) {
            INSTANCE.func_76185_a();
        }
    }

    public static void setInstance(int dimension, IESaveData in) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            INSTANCE = in;
        }
    }
}

