/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common;

import WayofTime.alchemicalWizardry.api.event.TeleposeEvent;
import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.api.tool.IDrillHead;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.blocks.BlockIEBase;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityCrusher;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.items.ItemDrill;
import blusunrize.immersiveengineering.common.util.IEAchievements;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Lib;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.network.MessageMineralListSync;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.oredict.OreDictionary;

public class EventHandler {
    public static ArrayList<IEBlockInterfaces.ISpawnInterdiction> interdictionTiles = new ArrayList();
    public static HashMap<UUID, TileEntityCrusher> crusherMap = new HashMap();

    @SubscribeEvent
    public void onLoad(WorldEvent.Load event) {
        if (ImmersiveNetHandler.INSTANCE == null) {
            ImmersiveNetHandler.INSTANCE = new ImmersiveNetHandler();
        }
    }

    @SubscribeEvent
    public void onSave(WorldEvent.Save event) {
        IESaveData.setDirty(0);
    }

    @SubscribeEvent
    public void onUnload(WorldEvent.Unload event) {
        IESaveData.setDirty(0);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            for (Map.Entry<ImmersiveNetHandler.Connection, Integer> e : ImmersiveNetHandler.INSTANCE.getTransferedRates(event.world.field_73011_w.field_76574_g).entrySet()) {
                if (e.getValue() <= e.getKey().cableType.getTransferRate()) continue;
                if (event.world instanceof WorldServer) {
                    for (Vec3 vec : e.getKey().getSubVertices(event.world)) {
                        ((WorldServer)event.world).func_147487_a("flame", vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 0, 0.0, 0.02, 0.0, 1.0);
                    }
                }
                ImmersiveNetHandler.INSTANCE.removeConnection(event.world, e.getKey());
            }
            ImmersiveNetHandler.INSTANCE.getTransferedRates(event.world.field_73011_w.field_76574_g).clear();
        }
    }

    @SubscribeEvent
    public void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            HashMap<ExcavatorHandler.MineralMix, Integer> packetMap = new HashMap<ExcavatorHandler.MineralMix, Integer>();
            for (Map.Entry<ExcavatorHandler.MineralMix, Integer> e : ExcavatorHandler.mineralList.entrySet()) {
                if (e.getKey() == null || e.getValue() == null) continue;
                packetMap.put(e.getKey(), e.getValue());
            }
            ImmersiveEngineering.packetHandler.sendToAll((IMessage)new MessageMineralListSync(packetMap));
        }
    }

    @SubscribeEvent
    public void harvestCheck(PlayerEvent.HarvestCheck event) {
        MovingObjectPosition mop;
        if (event.block instanceof BlockIEBase && event.entityPlayer.func_71045_bC() != null && event.entityPlayer.func_71045_bC().func_77973_b().getToolClasses(event.entityPlayer.func_71045_bC()).contains("IE_HAMMER") && (mop = Utils.getMovingObjectPositionFromPlayer(event.entityPlayer.field_70170_p, (EntityLivingBase)event.entityPlayer, true)) != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && ((BlockIEBase)event.block).allowHammerHarvest(event.entityPlayer.field_70170_p.func_72805_g(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d))) {
            event.success = true;
        }
    }

    @SubscribeEvent
    public void bloodMagicTeleposer(TeleposeEvent event) {
        TileEntity tI = event.initialWorld.func_147438_o(event.initialX, event.initialY, event.initialZ);
        TileEntity tF = event.finalWorld.func_147438_o(event.finalX, event.finalY, event.finalZ);
        if (tI instanceof TileEntityImmersiveConnectable || tF instanceof TileEntityImmersiveConnectable) {
            event.setCanceled(true);
        }
        if (tI instanceof TileEntityMultiblockPart || tF instanceof TileEntityMultiblockPart) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDrops(LivingDropsEvent event) {
        TileEntityCrusher crusher;
        if (!event.isCanceled() && Lib.DMG_Crusher.equals(event.source.func_76355_l()) && (crusher = crusherMap.get(event.entityLiving.func_110124_au())) != null) {
            for (EntityItem item : event.drops) {
                if (item == null || item.func_92059_d() == null) continue;
                crusher.outputItem(item.func_92059_d());
            }
            crusherMap.remove(event.entityLiving.func_110124_au());
            event.setCanceled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onEnderTeleport(EnderTeleportEvent event) {
        if (event.entityLiving.isCreatureType(EnumCreatureType.monster, false)) {
            ArrayList<IEBlockInterfaces.ISpawnInterdiction> arrayList = interdictionTiles;
            synchronized (arrayList) {
                Iterator<IEBlockInterfaces.ISpawnInterdiction> it = interdictionTiles.iterator();
                while (it.hasNext()) {
                    IEBlockInterfaces.ISpawnInterdiction interdictor = it.next();
                    if (interdictor instanceof TileEntity) {
                        if (((TileEntity)interdictor).func_145837_r() || ((TileEntity)interdictor).func_145831_w() == null) {
                            it.remove();
                            continue;
                        }
                        if (((TileEntity)interdictor).func_145831_w().field_73011_w.field_76574_g != event.entity.field_70170_p.field_73011_w.field_76574_g || !(((TileEntity)interdictor).func_145835_a(event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v) <= interdictor.getInterdictionRangeSquared())) continue;
                        event.setResult(Event.Result.DENY);
                        continue;
                    }
                    if (!(interdictor instanceof Entity)) continue;
                    if (((Entity)interdictor).field_70128_L || ((Entity)interdictor).field_70170_p == null) {
                        it.remove();
                        continue;
                    }
                    if (((Entity)interdictor).field_70170_p.field_73011_w.field_76574_g != event.entity.field_70170_p.field_73011_w.field_76574_g || !(((Entity)interdictor).func_70068_e(event.entity) <= interdictor.getInterdictionRangeSquared())) continue;
                    event.setResult(Event.Result.DENY);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onEntitySpawnCheck(LivingSpawnEvent.CheckSpawn event) {
        if (event.getResult() == Event.Result.ALLOW || event.getResult() == Event.Result.DENY) {
            return;
        }
        if (event.entityLiving.isCreatureType(EnumCreatureType.monster, false)) {
            ArrayList<IEBlockInterfaces.ISpawnInterdiction> arrayList = interdictionTiles;
            synchronized (arrayList) {
                Iterator<IEBlockInterfaces.ISpawnInterdiction> it = interdictionTiles.iterator();
                while (it.hasNext()) {
                    IEBlockInterfaces.ISpawnInterdiction interdictor = it.next();
                    if (interdictor instanceof TileEntity) {
                        if (((TileEntity)interdictor).func_145837_r() || ((TileEntity)interdictor).func_145831_w() == null) {
                            it.remove();
                            continue;
                        }
                        if (((TileEntity)interdictor).func_145831_w().field_73011_w.field_76574_g != event.entity.field_70170_p.field_73011_w.field_76574_g || !(((TileEntity)interdictor).func_145835_a(event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v) <= interdictor.getInterdictionRangeSquared())) continue;
                        event.setResult(Event.Result.DENY);
                        continue;
                    }
                    if (!(interdictor instanceof Entity)) continue;
                    if (((Entity)interdictor).field_70128_L || ((Entity)interdictor).field_70170_p == null) {
                        it.remove();
                        continue;
                    }
                    if (((Entity)interdictor).field_70170_p.field_73011_w.field_76574_g != event.entity.field_70170_p.field_73011_w.field_76574_g || !(((Entity)interdictor).func_70068_e(event.entity) <= interdictor.getInterdictionRangeSquared())) continue;
                    event.setResult(Event.Result.DENY);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityInteract(EntityInteractEvent event) {
        if (event.target instanceof EntityLivingBase && OreDictionary.itemMatches((ItemStack)new ItemStack((Item)IEContent.itemRevolver, 1, Short.MAX_VALUE), (ItemStack)event.entityPlayer.func_71045_bC(), (boolean)false)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        if (event.player != null && OreDictionary.itemMatches((ItemStack)new ItemStack((Item)IEContent.itemTool, 1, 0), (ItemStack)event.crafting, (boolean)true)) {
            event.player.func_71029_a((StatBase)IEAchievements.craftHammer);
        }
        if (event.crafting != null && ItemNBTHelper.hasKey(event.crafting, "jerrycanFilling")) {
            int drain = ItemNBTHelper.getInt(event.crafting, "jerrycanFilling");
            for (int i = 0; i < event.craftMatrix.func_70302_i_(); ++i) {
                ItemStack stackInSlot = event.craftMatrix.func_70301_a(i);
                if (stackInSlot == null || !((Object)((Object)IEContent.itemJerrycan)).equals(stackInSlot.func_77973_b()) || !ItemNBTHelper.hasKey(stackInSlot, "fluid")) continue;
                ItemNBTHelper.setInt(stackInSlot, "jerrycanDrain", drain);
                break;
            }
            ItemNBTHelper.remove(event.crafting, "jerrycanFilling");
        }
    }

    @SubscribeEvent
    public void digSpeedEvent(PlayerEvent.BreakSpeed event) {
        ItemStack current = event.entityPlayer.func_71045_bC();
        if (current != null && current.func_77973_b().equals((Object)IEContent.itemDrill) && current.func_77960_j() == 0 && event.entityPlayer.func_70055_a(Material.field_151586_h)) {
            if (((ItemDrill)IEContent.itemDrill).getUpgrades(current).func_74767_n("waterproof")) {
                event.newSpeed *= 5.0f;
            } else {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onAnvilChange(AnvilUpdateEvent event) {
        if (event.left != null && event.left.func_77973_b() instanceof IDrillHead && ((IDrillHead)event.left.func_77973_b()).getHeadDamage(event.left) > 0 && event.right != null && event.left.func_77973_b().func_82789_a(event.left, event.right)) {
            int cost;
            event.output = event.left.func_77946_l();
            int repair = Math.min(((IDrillHead)event.output.func_77973_b()).getHeadDamage(event.output), ((IDrillHead)event.output.func_77973_b()).getMaximumHeadDamage(event.output) / 4);
            for (cost = 0; repair > 0 && cost < event.right.field_77994_a; ++cost) {
                ((IDrillHead)event.output.func_77973_b()).damageHead(event.output, -repair);
                event.cost += Math.max(1, repair / 200);
                repair = Math.min(((IDrillHead)event.output.func_77973_b()).getHeadDamage(event.output), ((IDrillHead)event.output.func_77973_b()).getMaximumHeadDamage(event.output) / 4);
            }
            event.materialCost = cost;
            if (event.name == null || event.name.isEmpty()) {
                if (event.left.func_82837_s()) {
                    event.cost += 5;
                    event.output.func_135074_t();
                }
            } else if (!event.name.equals(event.left.func_82833_r())) {
                event.cost += 5;
                if (event.left.func_82837_s()) {
                    event.cost += 2;
                }
                event.output.func_151001_c(event.name);
            }
        }
    }
}

