/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConnectorLV;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.compat.IECompatModule;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.util.HashMap;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class Config {
    public static HashMap<String, Boolean> config_boolean = new HashMap();
    public static HashMap<String, Integer> config_int = new HashMap();
    public static HashMap<String, Double> config_double = new HashMap();
    public static HashMap<String, double[]> config_doubleArray = new HashMap();
    public static HashMap<String, int[]> config_intArray = new HashMap();
    public static HashMap<String, String[]> config_stringArray = new HashMap();

    public static void init(FMLPreInitializationEvent event) {
        Property connectionValidation;
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        double currentVersion = 0.61;
        Property propLastVersion = config.get("General", "LastVersion", 0.54, "The last version of IE that was run in this instance. DO NOT CHANGE THIS, IT WILL BREAK THINGS.");
        double lastVersion = propLastVersion.getDouble();
        if (lastVersion < currentVersion) {
            propLastVersion.set(currentVersion);
            IELogger.info("The Previous Version of IE was outdated!");
            if (lastVersion < 0.6) {
                IELogger.info("The config on transfer rates of IE wires will be reset to the default.");
                config.getCategory("general").remove((Object)"Cable transfer rates");
                config.getCategory("general").remove((Object)"Cable loss");
            }
            if (lastVersion < 0.61) {
                IELogger.info("The config on bullet damage will be reset to the default.");
                config.getCategory("tools").remove((Object)"BulletDamage-Casull");
                config.getCategory("tools").remove((Object)"BulletDamage-AP");
                config.getCategory("tools").remove((Object)"BulletDamage-Buck");
                config.getCategory("tools").remove((Object)"BulletDamage-Dragon");
                config.getCategory("tools").remove((Object)"BulletDamage-Homing");
                config.getCategory("tools").remove((Object)"BulletDamage-Wolfpack");
                config.getCategory("tools").remove((Object)"BulletDamage-WolfpackPart");
                config.getCategory("tools").remove((Object)"BulletDamage-Silver");
                config.getCategory("tools").remove((Object)"BulletDamage-Potion");
            }
            config.getCategory("general").remove((Object)"Show Update News");
        }
        if ((connectionValidation = config.get("General", "Validate Connections", false, "Drop connections with non-existing endpoints when loading the world. Use with care and backups and only when suspecting corrupted data. This option will check and load all connection endpoints and may slow down the world loading process.")).getBoolean()) {
            IELogger.warn("Connection validation enabled");
        }
        Config.setBoolean("validateConnections", connectionValidation.getBoolean());
        Property cableProperty = config.get("General", "Cable transfer rates", new int[]{2048, 8192, 32768, 0, 0}, "The transfer rates in RF/t for the cable tiers (copper, electrum, HV, Structural Rope & Cable(no transfer) )");
        if (cableProperty.getIntList().length < 5) {
            cableProperty.set(new int[]{2048, 8192, 32768, 0, 0});
        }
        Config.setIntArray("cableTransferRate", cableProperty.getIntList());
        cableProperty = config.get("General", "Cable loss", new double[]{0.05, 0.025, 0.025, 1.0, 1.0}, "The percentage of power lost every 16 blocks of distance for the cable tiers (copper, electrum, HV, Structural Rope & Cable(no transfer) )");
        if (cableProperty.getDoubleList().length < 5) {
            cableProperty.set(new double[]{0.05, 0.025, 0.1, 1.0, 1.0});
        }
        Config.setDoubleArray("cableLossRatio", cableProperty.getDoubleList());
        cableProperty = config.get("General", "Cable colouration", new int[]{13926474, 15576418, 0x6F6F6F, 9862765, 0x6F6F6F}, "");
        if (cableProperty.getIntList().length < 5) {
            cableProperty.set(new int[]{11758655, 15573061, 0x6F6F6F, 9862765, 0x6F6F6F});
        }
        Config.setIntArray("cableColouration", cableProperty.getIntList());
        cableProperty = config.get("General", "Cable length", new int[]{16, 16, 32, 32, 32}, "The maximum length cables can have. Copper and Electrum should be similar, Steel is meant for long range transport, Structural Rope & Cables are purely decorational");
        if (cableProperty.getIntList().length < 5) {
            cableProperty.set(new int[]{16, 16, 32, 32, 32});
        }
        Config.setIntArray("cableLength", cableProperty.getIntList());
        Config.setInt("revolverSheetID", config.get("General", "TextureSheet: Revolvers", 94, "The ID of the texture sheet used for revolvers. This should probably never conflict since not many mods do custom sheets.").getInt());
        IEApi.revolverTextureSheetID = Config.getInt("revolverSheetID");
        Config.setBoolean("increasedRenderboxes", config.get("General", "Increased Renderboxes", true, "By default all devices that accept cables have increased renderbounds to show cables even if the block itself is not in view. Disabling this reduces them to their minimum sizes, which might improve FPS on low-power PCs").getBoolean());
        Config.setBoolean("colourblindSupport", config.get("General", "ColourblindSupport", false, "Support for colourblind people, gives a text-based output on capacitor sides").getBoolean());
        Config.setBoolean("adjustManualScale", config.get("General", "AutoscaleManual", true, "Set this to false to disable tge manual's forced change of GUI scale").getBoolean());
        Config.setDouble("increasedTileRenderdistance", config.get("General", "Increased Tile Renderdistance", 1.5, "Increase the distance at which certain TileEntities (specifically windmills) are still visible. This is a modifier, so set it to 1 for default render distance, to 2 for doubled distance and so on.").getDouble());
        Config.setBoolean("disableHammerCrushing", config.get("General", "Disable Hammer Crushing", false, "Set this to true to completely disable the ore- and ingot-crushing recipes with the Engineers Hammer. Note that some of these disable automatically when other mods add the relevant dust (and by that probably a way to get them)").getBoolean());
        Config.setBoolean("forceHammerCrushing", config.get("General", "Force-Enable Hammer Crushing", false, "Set this to true to forefully enable the ore- and ingot-crushing recipes with the Engineers Hammer. This will override the disabling.").getBoolean());
        Config.setStringArray("preferredOres", config.get("General", "Preferred Ores", new String[]{"ImmersiveEngineering", "ThermalFoundation"}, "A list of preferred Mod IDs that results of IE processes should stem from, aka which mod you want the copper to come from. This affects the ores dug by the excavator, as well as those crushing recipes that don't have associated IE items. This list is in oreder of priority.").getStringList());
        Config.setBoolean("showUpdateNews", config.get("General", "Show Update News", true, "Set this to false to hide the update news in the manual").getBoolean());
        Config.setBoolean("ic2compat", config.get("General", "IC2 Compatability", true, "Set this to false to prevent wires from accepting and outputting EU").getBoolean());
        Config.setBoolean("gregtechcompat", config.get("General", "GregTech Compatability", true, "Set this to false to prevent wires from outputting GregTech EU").getBoolean());
        Config.setInt("euConversion", config.get("General", "EU Conversion", 4, "The amount of RF that equal 1 EU. 4 by default, so 4RF == 1EU and .25EU == 1RF").getInt());
        Config.setInt("villager_engineer", config.get("General", "Villager ID: Engineer", 512, "The villager ID for the Engineer Villager. Change if it conflicts").getInt());
        Property propConnectorInput = config.get("Machines", "Wire Connector Input", new int[]{256, 1024, 4096}, "In- and output rates of LV,MV and HV Wire Conenctors. This is independant of the transferrate of the wires.");
        if (propConnectorInput.getIntList().length < 3) {
            propConnectorInput.set(new int[]{256, 1024, 4096});
        }
        TileEntityConnectorLV.connectorInputValues = propConnectorInput.getIntList();
        Config.setIntArray("wireConnectorInput", propConnectorInput.getIntList());
        Config.setInt("capacitorLV_storage", config.get("Machines", "Capacitor LV: RF Storage", 100000, "The maximum amount of RF that can be stored in a low-voltage capacitor").getInt());
        Config.setInt("capacitorLV_input", config.get("Machines", "Capacitor LV: Input", 256, "The maximum amount of RF that can be input into a low-voltage capacitor (by IE net or other means)").getInt());
        Config.setInt("capacitorLV_output", config.get("Machines", "Capacitor LV: Output", 256, "The maximum amount of RF that can be output from a low-voltage capacitor (by IE net or other means)").getInt());
        Config.setInt("capacitorMV_storage", config.get("Machines", "Capacitor MV: RF Storage", 1000000, "The maximum amount of RF that can be stored in a medium-voltage capacitor").getInt());
        Config.setInt("capacitorMV_input", config.get("Machines", "Capacitor MV: Input", 1024, "The maximum amount of RF that can be input into a medium-voltage capacitor (by IE net or other means)").getInt());
        Config.setInt("capacitorMV_output", config.get("Machines", "Capacitor MV: Output", 1024, "The maximum amount of RF that can be output from a medium-voltage capacitor (by IE net or other means)").getInt());
        Config.setInt("capacitorHV_storage", config.get("Machines", "Capacitor HV: RF Storage", 4000000, "The maximum amount of RF that can be stored in a high-voltage capacitor").getInt());
        Config.setInt("capacitorHV_input", config.get("Machines", "Capacitor HV: Input", 4096, "The maximum amount of RF that can be input into a high-voltage capacitor (by IE net or other means)").getInt());
        Config.setInt("capacitorHV_output", config.get("Machines", "Capacitor HV: Output", 4096, "The maximum amount of RF that can be output from a high-voltage capacitor (by IE net or other means)").getInt());
        Config.setDouble("dynamo_output", config.get("Machines", "Dynamo: Output", 3.0, "The base RF that is output by the dynamo. This will be modified by the rotation modifier of the attached water- or windmill").getDouble());
        Config.setDouble("thermoelectric_output", config.get("Machines", "Thermoelectric: Output", 1.0, "Output modifier for the energy created by the Thermoelectric Generator").getDouble());
        Config.setInt("lightning_output", config.get("Machines", "Lightning Rod: Output", 16000000, "The RF that will be output by the lightning rod when it is struck").getInt());
        Config.setInt("dieselGen_output", config.get("Machines", "Diesel Generator: Output", 4096, "The RF per tick that the Diesel Generator will output. The burn time of the fuel determines the total output").getInt());
        Config.setInt("heater_consumption", config.get("Machines", "Heater: RF per Heat", 8, "The RF per tick consumed to add one heat to a furnace. Creates up to 4 heat in the startup time and then 1 heat per tick to keep it running").getInt());
        Config.setInt("heater_speedupConsumption", config.get("Machines", "Heater: Speedup", 24, "The RF per tick consumed to double the speed of the furnace. Only happens if furnace is at maximum heat.").getInt());
        Config.setInt("crusher_consumption", config.get("Machines", "Crusher: Consumed", 120, "The RF per tick consumed by the Crusher. Will also directly influence the speed.").getInt());
        Config.setInt("squeezer_consumption", config.get("Machines", "Squeezer: Consumed", 10, "The RF per tick per item that the Squeezer will consume to create Plant Oil").getInt());
        Config.setInt("fermenter_consumption", config.get("Machines", "Fermenter: Consumed", 10, "The RF per tick per item that the Fermenter will consume to create Ethanol").getInt());
        Config.setInt("refinery_consumption", config.get("Machines", "Refinery: Consumed", 80, "The RF per tick the Refinery will consume to mix two fluids").getInt());
        Config.setInt("excavator_consumption", config.get("Machines", "Excavator: Consumed", 4096, "The RF per tick the Excavator will consume to dig").getInt());
        Config.setDouble("excavator_speed", config.get("Machines", "Excavator: Speed", 1.0, "The speed of the Excavator. Basically translates to how many degrees per tick it will turn.").getDouble());
        Config.setDouble("excavator_chance", config.get("Machines", "Excavator: Chance", 0.05, "The chance that the Excavator will not dig up an ore with the currently downward-facing bucket.").getDouble());
        Config.setBoolean("excavator_particles", config.get("Machines", "Excavator: Particles", true, "Set this to false to disable the ridiculous amounts of particles the Excavator spawns").getBoolean());
        Config.setInt("excavator_depletion", config.get("Machines", "Excavator: Mineral Depletion", 76800, "The maximum amount of yield one can get out of a chunk with the excavator. Set a number smaller than zero to make it infinite").getInt());
        Config.setInt("excavator_depletion_days", Config.getInt("excavator_depletion") * 45 / 24000);
        Config.setInt("coredrill_time", config.get("Machines", "Core Sample Drill: Evaluation Time", 600, "The length in ticks it takes for the Core Sample Drill to figure out which mineral is found in a chunk").getInt());
        Config.setInt("coredrill_consumption", config.get("Machines", "Core Sample Drill: Consumption", 40, "The RF per tick consumed by the Core Sample Drill").getInt());
        Config.setInt("arcfurnace_electrodeDamage", config.get("Machines", "Arc Furnace: Graphite Electrodes", 96000, "The maximum amount of damage Graphite Electrodes can take. While the furnace is working, electrodes sustain 1 damage per tick, so this is effectively the lifetime in ticks. The default value of 96000 makes them last for 8 consecutive ingame days").getInt());
        Config.setBoolean("arcfurnace_electrodeCrafting", config.get("Machines", "Arc Furnace: Craftable Blueprint", false, "Set this to true to make the blueprint for graphite electrodes craftable in addition to villager/dungeon loot").getBoolean());
        Config.setBoolean("arcfurnace_recycle", config.get("Machines", "Arc Furnace: Recycling", true, "Set this to false to disable the Arc Furnace's recycling of armors and tools").getBoolean());
        Config.setBoolean("lantern_spawnPrevent", config.get("Machines", "Powered Lantern: Spawn Prevention", true, "Set this to false to disable the mob-spawn prevention of the Powered Lantern").getBoolean());
        Config.setBoolean("floodlight_spawnPrevent", config.get("Machines", "Floodlight: Spawn Prevention", true, "Set this to false to disable the mob-spawn prevention of the Floodlight").getBoolean());
        Config.setInt("pump_consumption", config.get("Machines", "Fluid Pump: Consumed", 250, "The RF the Fluid Pump will consume to pick up a fluid block in the world").getInt());
        Config.setInt("pump_consumption_accelerate", config.get("Machines", "Fluid Pump: Acceleration", 5, "The RF the Fluid Pump will consume pressurize+accellerate fluids, increasing the transferrate").getInt());
        Config.setInt("assembler_consumption", config.get("Machines", "Assembler: Consumed", 80, "The RF the Assembler will consume to craft an item from a recipe").getInt());
        Config.setInt("bottlingMachine_consumption", config.get("Machines", "Bottling: Consumed", 8, "The RF the Bottling Machine will consume per tick, when filling items").getInt());
        Config.setIntArray("ore_copper", config.get("OreGen", "Copper", new int[]{8, 40, 72, 8, 100}, "Generation config for Copper Ore. Parameters: Blocks per vein, lowest possible Y, highest possible Y, veins per chunk, chance for vein to spawn (out of 100). Set vein size to 0 to disable the generation").getIntList());
        Config.setIntArray("ore_bauxite", config.get("OreGen", "Bauxite", new int[]{4, 40, 85, 8, 100}, "Generation config for Bauxite Ore. Parameters: Blocks per vein, lowest possible Y, highest possible Y, veins per chunk, chance for vein to spawn (out of 100). Set vein size to 0 to disable the generation").getIntList());
        Config.setIntArray("ore_lead", config.get("OreGen", "Lead", new int[]{6, 8, 36, 4, 100}, "Generation config for Lead Ore. Parameters: Blocks per vein, lowest possible Y, highest possible Y, veins per chunk, chance for vein to spawn (out of 100). Set vein size to 0 to disable the generation").getIntList());
        Config.setIntArray("ore_silver", config.get("OreGen", "Silver", new int[]{8, 8, 40, 4, 80}, "Generation config for Silver Ore. Parameters: Blocks per vein, lowest possible Y, highest possible Y, veins per chunk, chance for vein to spawn (out of 100). Set vein size to 0 to disable the generation").getIntList());
        Config.setIntArray("ore_nickel", config.get("OreGen", "Nickel", new int[]{6, 8, 24, 2, 100}, "Generation config for Nickel Ore. Parameters: Blocks per vein, lowest possible Y, highest possible Y, veins per chunk, chance for vein to spawn (out of 100). Set vein size to 0 to disable the generation").getIntList());
        Config.setIntArray("oreDimBlacklist", config.get("OreGen", "DimensionBlacklist", new int[]{-1, 1}, "A blacklist of dimensions in which IE ores won't spawn. By default this is Nether (-1) and End (1)").getIntList());
        Config.setBoolean("hardmodeBulletRecipes", config.get("Tools", "Bullets: Hardmode Recipes", false, "Enable this to use the old, harder bullet recipes(require one ingot per bullet)").getBoolean());
        Config.setDouble("BulletDamage-Casull", config.get("Tools", "BulletDamage-Casull", 10.0, "The amount of base damage a Casull Cartridge inflicts").getDouble());
        Config.setDouble("BulletDamage-AP", config.get("Tools", "BulletDamage-AP", 10.0, "The amount of base damage an ArmorPiercing Cartridge inflicts").getDouble());
        Config.setDouble("BulletDamage-Buck", config.get("Tools", "BulletDamage-Buck", 2.0, "The amount of base damage a single part of Buckshot inflicts").getDouble());
        Config.setDouble("BulletDamage-Dragon", config.get("Tools", "BulletDamage-Dragon", 3.0, "The amount of base damage a DragonsBreath Cartridge inflicts").getDouble());
        Config.setDouble("BulletDamage-Homing", config.get("Tools", "BulletDamage-Homing", 10.0, "The amount of base damage a Homing Cartridge inflicts").getDouble());
        Config.setDouble("BulletDamage-Wolfpack", config.get("Tools", "BulletDamage-Wolfpack", 6.0, "The amount of base damage a Wolfpack Cartridge inflicts").getDouble());
        Config.setDouble("BulletDamage-WolfpackPart", config.get("Tools", "BulletDamage-WolfpackPart", 4.0, "The amount of damage the sub-projectiles of the Wolfpack Cartridge inflict").getDouble());
        Config.setDouble("BulletDamage-Silver", config.get("Tools", "BulletDamage-Silver", 10.0, "The amount of damage a silver bullet inflicts").getDouble());
        Config.setDouble("BulletDamage-Potion", config.get("Tools", "BulletDamage-Potion", 1.0, "The amount of base damage a Phial Cartridge inflicts").getDouble());
        for (String key : IECompatModule.moduleClasses.keySet()) {
            Config.setBoolean("compat_" + key, config.get("Compatability", "Enable Compatmodule: " + key, true, "Set this to false to disable IE's built in compatability with " + key).getBoolean());
        }
        config.save();
    }

    public static void setBoolean(String key, boolean b) {
        config_boolean.put(key, b);
    }

    public static boolean getBoolean(String key) {
        Boolean b = config_boolean.get(key);
        return b != null ? b : false;
    }

    public static void setInt(String key, int i) {
        config_int.put(key, i);
    }

    public static int getInt(String key) {
        Integer i = config_int.get(key);
        return i != null ? i : 0;
    }

    public static void setDouble(String key, double d) {
        config_double.put(key, d);
    }

    public static double getDouble(String key) {
        Double d = config_double.get(key);
        return d != null ? (double)d.floatValue() : 0.0;
    }

    public static void setDoubleArray(String key, double[] dA) {
        config_doubleArray.put(key, dA);
    }

    public static double[] getDoubleArray(String key) {
        return config_doubleArray.get(key);
    }

    public static void setIntArray(String key, int[] iA) {
        config_intArray.put(key, iA);
    }

    public static int[] getIntArray(String key) {
        return config_intArray.get(key);
    }

    public static void setStringArray(String key, String[] dA) {
        config_stringArray.put(key, dA);
    }

    public static String[] getStringArray(String key) {
        return config_stringArray.get(key);
    }
}

