/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.shader;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;

public class ShaderCaseRevolver
extends ShaderCase {
    public int overlayType = 0;
    public int[] colourBlade = new int[4];
    public String additionalTexture = null;
    public int glowLayer = -1;
    public IIcon i_revolverBase;
    public IIcon i_revolverOverlay;
    public IIcon i_revolverGrip;
    public IIcon i_revolverUncoloured;
    public IIcon i_revolverAdditional;

    public ShaderCaseRevolver(int overlayType, int[] colourGrip, int[] colourPrimary, int[] colourSecondary, int[] colourBlade, String additionalTexture) {
        super(colourGrip, colourPrimary, colourSecondary);
        this.colourBlade = colourBlade;
        this.overlayType = overlayType;
        this.additionalTexture = additionalTexture;
    }

    @Override
    public String getShaderType() {
        return "revolver";
    }

    @Override
    public int getPasses(ItemStack shader, ItemStack item, String modelPart) {
        int i;
        int n = i = this.additionalTexture != null ? 1 : 0;
        if (modelPart.equals("cosmetic_compensator")) {
            return 1 + i;
        }
        if (modelPart.equals("bayonet_attachment") || modelPart.equals("player_bayonet") || modelPart.equals("dev_bayonet") || modelPart.equals("player_mag") || modelPart.equals("dev_mag")) {
            return 2 + i;
        }
        return 3 + i;
    }

    @Override
    public IIcon getReplacementIcon(ItemStack shader, ItemStack item, String modelPart, int pass) {
        int maxPass = this.getPasses(shader, item, modelPart);
        if (pass == maxPass - 1 && this.i_revolverAdditional != null) {
            return this.i_revolverAdditional;
        }
        switch (modelPart) {
            case "revolver_frame": {
                return pass == 0 ? this.i_revolverGrip : (pass == 1 ? this.i_revolverBase : this.i_revolverOverlay);
            }
            case "barrel": 
            case "dev_scope": 
            case "player_mag": 
            case "dev_mag": 
            case "player_electro_0": 
            case "player_electro_1": {
                return pass == 0 ? this.i_revolverBase : (pass == 1 ? this.i_revolverOverlay : this.i_revolverUncoloured);
            }
            case "cosmetic_compensator": {
                return this.i_revolverOverlay;
            }
            case "bayonet_attachment": {
                if (pass == 0) {
                    return this.i_revolverGrip;
                }
                return this.i_revolverOverlay;
            }
            case "player_bayonet": 
            case "dev_bayonet": {
                return pass == 0 ? this.i_revolverBase : this.i_revolverOverlay;
            }
        }
        return this.i_revolverBase;
    }

    @Override
    public int[] getRGBAColourModifier(ItemStack shader, ItemStack item, String modelPart, int pass) {
        if (!shader.func_77942_o() || pass == 2 && (modelPart.equals("barrel") || modelPart.equals("dev_scope") || modelPart.equals("player_electro_0") || modelPart.equals("player_electro_1"))) {
            return new int[]{255, 255, 255, 255};
        }
        int i = this.getTextureType(modelPart, pass);
        if (i == 0) {
            return this.colourUnderlying;
        }
        if (i == 1) {
            return this.colourPrimary;
        }
        if (i == 2) {
            return this.colourSecondary;
        }
        if (i == 3) {
            return this.colourBlade;
        }
        return new int[]{255, 255, 255, 255};
    }

    public int getTextureType(String modelPart, int pass) {
        int i = 0;
        switch (modelPart) {
            case "revolver_frame": {
                i = pass;
                break;
            }
            case "barrel": 
            case "dev_scope": 
            case "player_mag": 
            case "dev_mag": 
            case "player_electro_0": 
            case "player_electro_1": {
                i = pass + 1;
                break;
            }
            case "cosmetic_compensator": {
                i = 2;
                break;
            }
            case "bayonet_attachment": {
                if (pass != 1) break;
                i = 2;
                break;
            }
            case "player_bayonet": 
            case "dev_bayonet": {
                i = pass == 1 ? 2 : 3;
            }
        }
        return i;
    }

    @Override
    public void stichTextures(IIconRegister ir, int sheetID) {
        if (sheetID == IEApi.revolverTextureSheetID) {
            this.i_revolverBase = ir.func_94245_a("immersiveengineering:shaders/revolver_0");
            this.i_revolverOverlay = ir.func_94245_a("immersiveengineering:shaders/revolver_1_" + this.overlayType);
            this.i_revolverGrip = ir.func_94245_a("immersiveengineering:shaders/revolver_grip");
            this.i_revolverUncoloured = ir.func_94245_a("immersiveengineering:shaders/revolver_noColour");
            if (this.additionalTexture != null) {
                this.i_revolverAdditional = ir.func_94245_a(this.additionalTexture);
            }
        }
    }

    @Override
    public void modifyRender(ItemStack shader, ItemStack item, String modelPart, int pass, boolean pre) {
        if (modelPart.equals("cosmetic_compensator")) {
            if (pre) {
                GL11.glDisable((int)2884);
            } else {
                GL11.glEnable((int)2884);
            }
        }
        if (this.glowLayer > -1 && (this.glowLayer & this.getTextureType(modelPart, pass) + 1) == 1) {
            if (pre) {
                GL11.glDisable((int)2896);
                Tessellator.field_78398_a.func_78380_c(0xFFFFFF);
            } else {
                GL11.glEnable((int)2896);
            }
        }
    }
}

