/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.gui.element;

import cofh.lib.gui.GuiBase;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public abstract class ElementBase {
    protected GuiBase gui;
    protected ResourceLocation texture;
    private FontRenderer fontRenderer;
    protected int posX;
    protected int posY;
    protected int sizeX;
    protected int sizeY;
    protected int texW = 256;
    protected int texH = 256;
    protected String name;
    private boolean visible = true;
    private boolean enabled = true;

    public ElementBase(GuiBase guiBase, int n, int n2) {
        this.gui = guiBase;
        this.posX = n;
        this.posY = n2;
    }

    public ElementBase(GuiBase guiBase, int n, int n2, int n3, int n4) {
        this.gui = guiBase;
        this.posX = n;
        this.posY = n2;
        this.sizeX = n3;
        this.sizeY = n4;
    }

    public ElementBase setName(String string) {
        this.name = string;
        return this;
    }

    public ElementBase setPosition(int n, int n2) {
        this.posX = n;
        this.posY = n2;
        return this;
    }

    public ElementBase setSize(int n, int n2) {
        this.sizeX = n;
        this.sizeY = n2;
        return this;
    }

    public ElementBase setTexture(String string, int n, int n2) {
        this.texture = new ResourceLocation(string);
        this.texW = n;
        this.texH = n2;
        return this;
    }

    public final ElementBase setVisible(boolean bl) {
        this.visible = bl;
        return this;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public final ElementBase setEnabled(boolean bl) {
        this.enabled = bl;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void update(int n, int n2) {
        this.update();
    }

    public void update() {
    }

    public abstract void drawBackground(int var1, int var2, float var3);

    public abstract void drawForeground(int var1, int var2);

    public void addTooltip(List<String> list) {
    }

    public void drawModalRect(int n, int n2, int n3, int n4, int n5) {
        this.gui.drawSizedModalRect(n, n2, n3, n4, n5);
    }

    public void drawStencil(int n, int n2, int n3, int n4, int n5) {
        GL11.glDisable((int)3553);
        GL11.glStencilFunc((int)519, (int)n5, (int)n5);
        GL11.glStencilOp((int)0, (int)0, (int)7681);
        GL11.glStencilMask((int)1);
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GL11.glDepthMask((boolean)false);
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78377_a((double)n, (double)n4, 0.0);
        Tessellator.field_78398_a.func_78377_a((double)n3, (double)n4, 0.0);
        Tessellator.field_78398_a.func_78377_a((double)n3, (double)n2, 0.0);
        Tessellator.field_78398_a.func_78377_a((double)n, (double)n2, 0.0);
        Tessellator.field_78398_a.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glStencilFunc((int)514, (int)n5, (int)n5);
        GL11.glStencilMask((int)0);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glDepthMask((boolean)true);
    }

    public void drawTexturedModalRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.gui.drawSizedTexturedModalRect(n, n2, n3, n4, n5, n6, this.texW, this.texH);
    }

    public void drawCenteredString(FontRenderer fontRenderer, String string, int n, int n2, int n3) {
        fontRenderer.func_78261_a(string, n - fontRenderer.func_78256_a(string) / 2, n2, n3);
    }

    public boolean onMousePressed(int n, int n2, int n3) {
        return false;
    }

    public void onMouseReleased(int n, int n2) {
    }

    public boolean onMouseWheel(int n, int n2, int n3) {
        return false;
    }

    public boolean onKeyTyped(char c, int n) {
        return false;
    }

    public boolean intersectsWith(int n, int n2) {
        return n >= this.posX && n <= this.posX + this.sizeX && n2 >= this.posY && n2 <= this.posY + this.sizeY;
    }

    public FontRenderer getFontRenderer() {
        return this.fontRenderer == null ? this.gui.getFontRenderer() : this.fontRenderer;
    }

    public ElementBase setFontRenderer(FontRenderer fontRenderer) {
        this.fontRenderer = fontRenderer;
        return this;
    }

    public final String getName() {
        return this.name;
    }

    public final GuiBase getContainerScreen() {
        return this.gui;
    }

    public final int getPosY() {
        return this.posY;
    }

    public final int getPosX() {
        return this.posX;
    }

    public final int getHeight() {
        return this.sizeY;
    }

    public final int getWidth() {
        return this.sizeX;
    }
}

