/*
 * Decompiled with CFR 0.152.
 */
package cofh.asm;

import cofh.asm.LoadingPlugin;
import cofh.asm.relauncher.Implementable;
import cofh.asm.relauncher.Strippable;
import cofh.mod.updater.ModRange;
import cofh.mod.updater.ModVersion;
import com.google.common.base.Throwables;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModAPIManager;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.InvalidVersionSpecificationException;
import cpw.mods.fml.common.versioning.VersionRange;
import gnu.trove.map.hash.TObjectByteHashMap;
import gnu.trove.set.hash.THashSet;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

class ASMCore {
    static Logger log = LogManager.getLogger((String)"CoFH ASM");
    static TObjectByteHashMap<String> hashes = new TObjectByteHashMap(30, 1.0f, 0);
    static THashSet<String> parsables;
    static THashSet<String> implementables;
    static THashSet<String> strippables;
    static final String implementableDesc;
    static final String strippableDesc;
    static String side;
    static final ArrayList<String> workingPath;
    private static final String[] emptyList;
    private static Map<String, ModContainer> mods;
    private static Map<String, ModContainer> apis;

    ASMCore() {
    }

    static void init() {
    }

    static byte[] parse(String string, String string2, byte[] byArray) {
        ClassWriter classWriter;
        ClassNode classNode;
        ClassReader classReader;
        workingPath.add(string2);
        if (implementables.contains((Object)string)) {
            log.debug("Adding runtime interfaces to " + string2);
            classReader = new ClassReader(byArray);
            classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 0);
            if (ASMCore.implement(classNode)) {
                classWriter = new ClassWriter(0);
                classNode.accept((ClassVisitor)classWriter);
                byArray = classWriter.toByteArray();
            } else {
                log.debug("Nothing implemented on " + string2);
            }
        }
        if (strippables.contains((Object)string)) {
            log.debug("Stripping methods and fields from " + string2);
            classReader = new ClassReader(byArray);
            classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 0);
            if (ASMCore.strip(classNode)) {
                classWriter = new ClassWriter(0);
                classNode.accept((ClassVisitor)classWriter);
                byArray = classWriter.toByteArray();
            } else {
                log.debug("Nothing stripped from " + string2);
            }
        }
        workingPath.remove(workingPath.size() - 1);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void HACK(String string, byte[] byArray) {
        ArrayList<String> arrayList = workingPath;
        synchronized (arrayList) {
            workingPath.add(string);
            ClassReader classReader = new ClassReader(byArray);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 0);
            if (classNode.innerClasses != null) {
                for (InnerClassNode innerClassNode : classNode.innerClasses) {
                    log.debug("\tInner class: " + innerClassNode.name);
                    if (workingPath.contains(innerClassNode.name)) continue;
                    try {
                        Class.forName(innerClassNode.name, false, ASMCore.class.getClassLoader());
                    }
                    catch (Throwable throwable) {}
                }
            }
            workingPath.remove(workingPath.size() - 1);
        }
    }

    static byte[] transform(int n, String string, String string2, byte[] byArray) {
        ClassReader classReader = new ClassReader(byArray);
        switch (n) {
            case 1: {
                return ASMCore.writeWorldServer(string2, byArray, classReader);
            }
            case 2: {
                return ASMCore.writeWorld(string2, byArray, classReader);
            }
            case 3: {
                return ASMCore.writeWorldProxy(string, byArray, classReader);
            }
            case 4: {
                return ASMCore.writeWorldServerProxy(string, byArray, classReader);
            }
            case 5: {
                return ASMCore.alterBlockPane(string2, byArray, classReader);
            }
            case 6: {
                return ASMCore.alterBlock(string2, byArray, classReader);
            }
            case 7: {
                return ASMCore.alterController(string2, byArray, classReader);
            }
            case 8: {
                return ASMCore.alterLongHashMap(string2, byArray, classReader);
            }
            case 9: {
                return ASMCore.alterChunk(string2, byArray, classReader);
            }
            case 10: {
                return ASMCore.alterMinecraft(string2, byArray, classReader);
            }
            case 11: {
                return ASMCore.alterRenderBlocks(string2, byArray, classReader);
            }
            case 12: {
                return ASMCore.alterTileEntity(string2, byArray, classReader);
            }
            case 13: {
                return ASMCore.fixWorldGenLag(string2, byArray, classReader);
            }
            case 14: {
                return ASMCore.alterEntity(string2, byArray, classReader);
            }
            case 15: {
                return ASMCore.alterEntityItem(string2, byArray, classReader);
            }
            case 16: {
                return ASMCore.alterHooksCore(string, byArray, classReader);
            }
            case 17: {
                return ASMCore.alterEnchantment(string2, byArray, classReader);
            }
            case 18: {
                return ASMCore.alterItem(string2, byArray, classReader);
            }
            case 19: {
                return ASMCore.alterKeyEntry(string2, byArray, classReader);
            }
            case 20: {
                return ASMCore.alterKeyBinding(string2, byArray, classReader);
            }
        }
        return byArray;
    }

    private static byte[] alterEnchantment(String string, byte[] byArray, ClassReader classReader) {
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_92089_a", "func_77973_b", ""} : new String[]{"canApply", "getItem", ""};
        ClassNode classNode = new ClassNode(327680);
        classReader.accept((ClassVisitor)classNode, 8);
        MethodNode methodNode = null;
        for (MethodNode methodNode2 : classNode.methods) {
            if (!stringArray[0].equals(methodNode2.name)) continue;
            methodNode = methodNode2;
            break;
        }
        if (methodNode != null) {
            MethodNode methodNode2;
            AbstractInsnNode abstractInsnNode = methodNode.instructions.getFirst();
            methodNode2 = new LabelNode();
            LabelNode labelNode = new LabelNode();
            AbstractInsnNode abstractInsnNode2 = abstractInsnNode;
            abstractInsnNode = new VarInsnNode(25, 1);
            methodNode.instructions.insertBefore(abstractInsnNode2, abstractInsnNode);
            AbstractInsnNode abstractInsnNode3 = abstractInsnNode;
            abstractInsnNode = new MethodInsnNode(182, "net/minecraft/item/ItemStack", stringArray[1], "()Lnet/minecraft/item/Item;", false);
            methodNode.instructions.insert(abstractInsnNode3, abstractInsnNode);
            AbstractInsnNode abstractInsnNode4 = abstractInsnNode;
            abstractInsnNode = new VarInsnNode(25, 1);
            methodNode.instructions.insert(abstractInsnNode4, abstractInsnNode);
            AbstractInsnNode abstractInsnNode5 = abstractInsnNode;
            abstractInsnNode = new VarInsnNode(25, 0);
            methodNode.instructions.insert(abstractInsnNode5, abstractInsnNode);
            AbstractInsnNode abstractInsnNode6 = abstractInsnNode;
            abstractInsnNode = new MethodInsnNode(182, "net/minecraft/item/Item", "cofh_canEnchantApply", "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/enchantment/Enchantment;)I", false);
            methodNode.instructions.insert(abstractInsnNode6, abstractInsnNode);
            AbstractInsnNode abstractInsnNode7 = abstractInsnNode;
            abstractInsnNode = new InsnNode(89);
            methodNode.instructions.insert(abstractInsnNode7, abstractInsnNode);
            AbstractInsnNode abstractInsnNode8 = abstractInsnNode;
            abstractInsnNode = new JumpInsnNode(155, (LabelNode)methodNode2);
            methodNode.instructions.insert(abstractInsnNode8, abstractInsnNode);
            AbstractInsnNode abstractInsnNode9 = abstractInsnNode;
            abstractInsnNode = new JumpInsnNode(153, labelNode);
            methodNode.instructions.insert(abstractInsnNode9, abstractInsnNode);
            AbstractInsnNode abstractInsnNode10 = abstractInsnNode;
            abstractInsnNode = new InsnNode(4);
            methodNode.instructions.insert(abstractInsnNode10, abstractInsnNode);
            AbstractInsnNode abstractInsnNode11 = abstractInsnNode;
            abstractInsnNode = new InsnNode(172);
            methodNode.instructions.insert(abstractInsnNode11, abstractInsnNode);
            AbstractInsnNode abstractInsnNode12 = abstractInsnNode;
            abstractInsnNode = labelNode;
            methodNode.instructions.insert(abstractInsnNode12, abstractInsnNode);
            AbstractInsnNode abstractInsnNode13 = abstractInsnNode;
            abstractInsnNode = new FrameNode(3, 0, null, 0, null);
            methodNode.instructions.insert(abstractInsnNode13, abstractInsnNode);
            AbstractInsnNode abstractInsnNode14 = abstractInsnNode;
            abstractInsnNode = new InsnNode(3);
            methodNode.instructions.insert(abstractInsnNode14, abstractInsnNode);
            AbstractInsnNode abstractInsnNode15 = abstractInsnNode;
            abstractInsnNode = new InsnNode(172);
            methodNode.instructions.insert(abstractInsnNode15, abstractInsnNode);
            AbstractInsnNode abstractInsnNode16 = abstractInsnNode;
            abstractInsnNode = methodNode2;
            methodNode.instructions.insert(abstractInsnNode16, abstractInsnNode);
            AbstractInsnNode abstractInsnNode17 = abstractInsnNode;
            abstractInsnNode = new FrameNode(4, 0, null, 0, new Object[]{"I"});
            methodNode.instructions.insert(abstractInsnNode17, abstractInsnNode);
            AbstractInsnNode abstractInsnNode18 = abstractInsnNode;
            abstractInsnNode = new InsnNode(87);
            methodNode.instructions.insert(abstractInsnNode18, abstractInsnNode);
            ClassWriter classWriter = new ClassWriter(0);
            classNode.accept((ClassVisitor)classWriter);
            byArray = classWriter.toByteArray();
        }
        return byArray;
    }

    private static byte[] alterItem(String string, byte[] byArray, ClassReader classReader) {
        string = string.replace('.', '/');
        ClassWriter classWriter = new ClassWriter(0);
        classReader.accept((ClassVisitor)classWriter, 0);
        String string2 = "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/enchantment/Enchantment;)I";
        classWriter.newMethod(string, "cofh_canEnchantApply", string2, true);
        MethodVisitor methodVisitor = classWriter.visitMethod(4097, "cofh_canEnchantApply", string2, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitInsn(2);
        methodVisitor.visitInsn(172);
        methodVisitor.visitMaxs(1, 2);
        methodVisitor.visitEnd();
        classWriter.visitEnd();
        byArray = classWriter.toByteArray();
        return byArray;
    }

    private static byte[] alterBlock(String string, byte[] byArray, ClassReader classReader) {
        MethodNode methodNode;
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_149671_p", "", ""} : new String[]{"registerBlocks", "t", ""};
        ClassNode classNode = new ClassNode(327680);
        classReader.accept((ClassVisitor)classNode, 8);
        MethodNode methodNode2 = null;
        AbstractInsnNode abstractInsnNode = classNode.methods.iterator();
        while (abstractInsnNode.hasNext()) {
            methodNode = (MethodNode)abstractInsnNode.next();
            if (!stringArray[0].equals(methodNode.name)) continue;
            methodNode2 = methodNode;
            break;
        }
        if (methodNode2 != null) {
            for (abstractInsnNode = methodNode2.instructions.getFirst(); abstractInsnNode != null; abstractInsnNode = abstractInsnNode.getNext()) {
                if (abstractInsnNode.getOpcode() != 187 || (methodNode = abstractInsnNode.getPrevious().getPrevious()).getOpcode() != 16) continue;
                TypeInsnNode typeInsnNode = (TypeInsnNode)abstractInsnNode;
                switch (((IntInsnNode)methodNode).operand) {
                    case 8: {
                        typeInsnNode.desc = "cofh/asmhooks/block/BlockTickingWater";
                        break;
                    }
                    case 9: {
                        typeInsnNode.desc = "cofh/asmhooks/block/BlockWater";
                        break;
                    }
                    default: {
                        typeInsnNode = null;
                    }
                }
                if (typeInsnNode == null) continue;
                ((MethodInsnNode)abstractInsnNode.getNext().getNext().getNext()).owner = typeInsnNode.desc;
            }
            abstractInsnNode = new ClassWriter(0);
            classNode.accept((ClassVisitor)abstractInsnNode);
            byArray = abstractInsnNode.toByteArray();
        }
        return byArray;
    }

    private static byte[] alterEntityItem(String string, byte[] byArray, ClassReader classReader) {
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_85054_d", "", ""} : new String[]{"searchForOtherItemsNearby", "", ""};
        ClassNode classNode = new ClassNode(327680);
        classReader.accept((ClassVisitor)classNode, 8);
        MethodNode methodNode = null;
        for (MethodNode methodNode2 : classNode.methods) {
            if (!stringArray[0].equals(methodNode2.name)) continue;
            methodNode = methodNode2;
            break;
        }
        if (methodNode != null) {
            methodNode.localVariables = null;
            methodNode.instructions.clear();
            methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodNode.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "cofh/asmhooks/HooksCore", "stackItems", "(Lnet/minecraft/entity/item/EntityItem;)V", false));
            methodNode.instructions.add((AbstractInsnNode)new InsnNode(177));
            ClassWriter classWriter = new ClassWriter(1);
            classNode.accept((ClassVisitor)classWriter);
            byArray = classWriter.toByteArray();
        }
        return byArray;
    }

    private static byte[] alterEntity(String string, byte[] byArray, ClassReader classReader) {
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_70091_d", "func_72945_a", "func_70104_M"} : new String[]{"moveEntity", "getCollidingBoundingBoxes", "canBePushed"};
        string = string.replace('.', '/');
        ClassNode classNode = new ClassNode(327680);
        classReader.accept((ClassVisitor)classNode, 8);
        String string2 = "net/minecraft/world/World";
        MethodNode methodNode = null;
        for (MethodNode methodNode2 : classNode.methods) {
            if (!stringArray[0].equals(methodNode2.name)) continue;
            methodNode = methodNode2;
            break;
        }
        if (methodNode != null) {
            int n = methodNode.instructions.size();
            for (int i = 0; i < n; ++i) {
                AbstractInsnNode abstractInsnNode = methodNode.instructions.get(i);
                if (abstractInsnNode.getOpcode() != 182) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
                if (!string2.equals(methodInsnNode.owner) || !stringArray[1].equals(methodInsnNode.name)) continue;
                methodInsnNode.setOpcode(184);
                methodInsnNode.owner = "cofh/asmhooks/HooksCore";
                methodInsnNode.desc = "(Lnet/minecraft/world/World;Lnet/minecraft/entity/Entity;Lnet/minecraft/util/AxisAlignedBB;)Ljava/util/List;";
                methodInsnNode.name = "getEntityCollisionBoxes";
            }
            methodNode = new MethodNode(1, "cofh_collideCheck", "()Z", null, null);
            classNode.methods.add(methodNode);
            methodNode.instructions.insert((AbstractInsnNode)new InsnNode(172));
            methodNode.instructions.insert((AbstractInsnNode)new MethodInsnNode(182, string, stringArray[2], "()Z", false));
            methodNode.instructions.insert((AbstractInsnNode)new VarInsnNode(25, 0));
            ClassWriter classWriter = new ClassWriter(1);
            classNode.accept((ClassVisitor)classWriter);
            byArray = classWriter.toByteArray();
        }
        return byArray;
    }

    private static byte[] alterHooksCore(String string, byte[] byArray, ClassReader classReader) {
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_70104_M"} : new String[]{"canBePushed"};
        ClassNode classNode = new ClassNode(327680);
        classReader.accept((ClassVisitor)classNode, 8);
        MethodNode methodNode = null;
        for (MethodNode methodNode2 : classNode.methods) {
            if (!"getEntityCollisionBoxes".equals(methodNode2.name)) continue;
            methodNode = methodNode2;
            break;
        }
        int n = methodNode.instructions.size();
        for (int i = 0; i < n; ++i) {
            AbstractInsnNode abstractInsnNode = methodNode.instructions.get(i);
            if (abstractInsnNode.getOpcode() != 182) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
            if (!stringArray[0].equals(methodInsnNode.name)) continue;
            methodInsnNode.name = "cofh_collideCheck";
        }
        ClassWriter classWriter = new ClassWriter(1);
        classNode.accept((ClassVisitor)classWriter);
        byArray = classWriter.toByteArray();
        return byArray;
    }

    private static byte[] alterKeyEntry(String string, byte[] byArray, ClassReader classReader) {
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_148279_a", "func_151463_i"} : new String[]{"drawEntry", "getKeyCode"};
        string = string.replace('.', '/');
        ClassNode classNode = new ClassNode(327680);
        classReader.accept((ClassVisitor)classNode, 8);
        MethodNode methodNode = null;
        for (MethodNode methodNode2 : classNode.methods) {
            if (!stringArray[0].equals(methodNode2.name)) continue;
            methodNode = methodNode2;
            break;
        }
        if (methodNode != null) {
            int n = methodNode.instructions.size();
            for (int i = 0; i < n; ++i) {
                AbstractInsnNode abstractInsnNode = methodNode.instructions.get(i);
                if (abstractInsnNode.getOpcode() != 182 || abstractInsnNode.getNext().getOpcode() != 153) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
                if (!stringArray[1].equals(methodInsnNode.name)) continue;
                methodInsnNode.name = "cofh_conflictCode";
            }
            ClassWriter classWriter = new ClassWriter(1);
            classNode.accept((ClassVisitor)classWriter);
            byArray = classWriter.toByteArray();
        }
        return byArray;
    }

    private static byte[] alterKeyBinding(String string, byte[] byArray, ClassReader classReader) {
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_148279_a", "func_151463_i"} : new String[]{"drawEntry", "getKeyCode"};
        string = string.replace('.', '/');
        ClassWriter classWriter = new ClassWriter(1);
        classReader.accept((ClassVisitor)classWriter, 0);
        classWriter.newMethod(string, "cofh_conflictCode", "()I", true);
        MethodVisitor methodVisitor = classWriter.visitMethod(4097, "cofh_conflictCode", "()I", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(182, "net/minecraft/client/settings/KeyBinding", stringArray[1], "()I", false);
        methodVisitor.visitInsn(172);
        methodVisitor.visitMaxs(2, 1);
        methodVisitor.visitEnd();
        classWriter.visitEnd();
        byArray = classWriter.toByteArray();
        return byArray;
    }

    private static byte[] alterRenderBlocks(String string, byte[] byArray, ClassReader classReader) {
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_147733_k", "func_150098_a", "func_147439_a"} : new String[]{"renderBlockStainedGlassPane", "canPaneConnectToBlock", "getBlock"};
        ClassNode classNode = new ClassNode(327680);
        classReader.accept((ClassVisitor)classNode, 8);
        MethodNode methodNode = null;
        for (MethodNode methodNode2 : classNode.methods) {
            if (!stringArray[0].equals(methodNode2.name) || !"(Lnet/minecraft/block/Block;III)Z".equals(methodNode2.desc)) continue;
            methodNode = methodNode2;
            break;
        }
        if (methodNode != null) {
            methodNode.localVariables = null;
            String[] stringArray2 = new String[]{"NORTH", "NORTH", "SOUTH", "SOUTH", "WEST", "WEST", "EAST", "EAST"};
            int n = 0;
            int n2 = methodNode.instructions.size();
            for (int i = 0; i < n2; ++i) {
                AbstractInsnNode abstractInsnNode = methodNode.instructions.get(i);
                if (abstractInsnNode.getType() != 5) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
                if (abstractInsnNode.getOpcode() != 185 || abstractInsnNode.getNext().getOpcode() != 182 || !stringArray[2].equals(methodInsnNode.name) || !"(III)Lnet/minecraft/block/Block;".equals(methodInsnNode.desc) || !"(Lnet/minecraft/block/Block;)Z".equals(((MethodInsnNode)methodInsnNode.getNext()).desc)) continue;
                methodNode.instructions.insertBefore(abstractInsnNode, (AbstractInsnNode)new FieldInsnNode(178, "net/minecraftforge/common/util/ForgeDirection", stringArray2[n++], "Lnet/minecraftforge/common/util/ForgeDirection;"));
                methodNode.instructions.insertBefore(abstractInsnNode, (AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/block/BlockPane", "canPaneConnectTo", "(Lnet/minecraft/world/IBlockAccess;IIILnet/minecraftforge/common/util/ForgeDirection;)Z", false));
                methodNode.instructions.remove(abstractInsnNode.getNext());
                methodNode.instructions.remove(abstractInsnNode);
            }
            if (n != 0) {
                ClassWriter classWriter = new ClassWriter(1);
                classNode.accept((ClassVisitor)classWriter);
                byArray = classWriter.toByteArray();
            }
        }
        return byArray;
    }

    private static byte[] alterBlockPane(String string, byte[] byArray, ClassReader classReader) {
        String string2 = "canPaneConnectTo";
        ClassNode classNode = new ClassNode(327680);
        classReader.accept((ClassVisitor)classNode, 8);
        MethodNode methodNode = null;
        for (MethodNode methodNode2 : classNode.methods) {
            if (!string2.equals(methodNode2.name) || !"(Lnet/minecraft/world/IBlockAccess;IIILnet/minecraftforge/common/util/ForgeDirection;)Z".equals(methodNode2.desc)) continue;
            methodNode = methodNode2;
            break;
        }
        if (methodNode != null) {
            methodNode.instructions.clear();
            methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(21, 2));
            methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(21, 3));
            methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(21, 4));
            methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(25, 5));
            methodNode.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "cofh/asmhooks/HooksCore", "paneConnectsTo", "(Lnet/minecraft/world/IBlockAccess;IIILnet/minecraftforge/common/util/ForgeDirection;)Z", false));
            methodNode.instructions.add((AbstractInsnNode)new InsnNode(172));
            methodNode.localVariables = null;
            ClassWriter classWriter = new ClassWriter(1);
            classNode.accept((ClassVisitor)classWriter);
            byArray = classWriter.toByteArray();
        }
        return byArray;
    }

    private static byte[] alterMinecraft(String string, byte[] byArray, ClassReader classReader) {
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_71407_l", "func_110550_d"} : new String[]{"runTick", "tick"};
        ClassNode classNode = new ClassNode(327680);
        classReader.accept((ClassVisitor)classNode, 8);
        String string2 = "net/minecraft/client/renderer/texture/TextureManager";
        boolean bl = false;
        block0: for (MethodNode methodNode : classNode.methods) {
            String string3 = methodNode.name;
            if (!stringArray[0].equals(string3) || !"()V".equals(methodNode.desc)) continue;
            bl = true;
            int n = methodNode.instructions.size();
            for (int i = 0; i < n; ++i) {
                AbstractInsnNode abstractInsnNode = methodNode.instructions.get(i);
                if (abstractInsnNode.getOpcode() != 182) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
                if (!string2.equals(methodInsnNode.owner) || !stringArray[1].equals(methodInsnNode.name) || !"()V".equals(methodInsnNode.desc)) continue;
                methodNode.instructions.set((AbstractInsnNode)methodInsnNode, (AbstractInsnNode)new MethodInsnNode(184, "cofh/asmhooks/HooksCore", "tickTextures", "(Lnet/minecraft/client/renderer/texture/ITickable;)V", false));
                break block0;
            }
        }
        if (bl) {
            ClassWriter classWriter = new ClassWriter(1);
            classNode.accept((ClassVisitor)classWriter);
            byArray = classWriter.toByteArray();
        }
        return byArray;
    }

    private static byte[] alterChunk(String string, byte[] byArray, ClassReader classReader) {
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_150803_c", "field_76650_s"} : new String[]{"recheckGaps", "isGapLightingUpdated"};
        string = string.replace('.', '/');
        ClassNode classNode = new ClassNode(327680);
        classReader.accept((ClassVisitor)classNode, 8);
        boolean bl = false;
        block0: for (MethodNode methodNode : classNode.methods) {
            String string2 = methodNode.name;
            if (!stringArray[0].equals(string2) || !"(Z)V".equals(methodNode.desc)) continue;
            bl = true;
            int n = methodNode.instructions.size();
            for (int i = 0; i < n; ++i) {
                AbstractInsnNode abstractInsnNode = methodNode.instructions.get(i);
                if (abstractInsnNode.getOpcode() != 177) continue;
                methodNode.instructions.insertBefore(abstractInsnNode, (AbstractInsnNode)new VarInsnNode(25, 0));
                methodNode.instructions.insertBefore(abstractInsnNode, (AbstractInsnNode)new InsnNode(3));
                methodNode.instructions.insertBefore(abstractInsnNode, (AbstractInsnNode)new FieldInsnNode(181, string, stringArray[1], "Z"));
                continue block0;
            }
        }
        if (bl) {
            ClassWriter classWriter = new ClassWriter(1);
            classNode.accept((ClassVisitor)classWriter);
            byArray = classWriter.toByteArray();
        }
        return byArray;
    }

    private static byte[] fixWorldGenLag(String string, byte[] byArray, ClassReader classReader) {
        String string2 = LoadingPlugin.runtimeDeobfEnabled ? "func_73254_a" : "sendChunkUpdate";
        ClassNode classNode = new ClassNode(327680);
        classReader.accept((ClassVisitor)classNode, 8);
        String string3 = "()V";
        MethodNode methodNode = null;
        for (MethodNode methodNode2 : classNode.methods) {
            if (!string2.equals(methodNode2.name) || !string3.equals(methodNode2.desc)) continue;
            methodNode = methodNode2;
            break;
        }
        if (methodNode != null) {
            int n = methodNode.instructions.size();
            block1: for (int i = 0; i < n; ++i) {
                AbstractInsnNode abstractInsnNode = methodNode.instructions.get(i);
                if (abstractInsnNode.getOpcode() != 178 || !"net/minecraftforge/common/ForgeModContainer".equals(((FieldInsnNode)abstractInsnNode).owner)) continue;
                while (abstractInsnNode != null) {
                    if (abstractInsnNode.getOpcode() == 160) {
                        ((JumpInsnNode)abstractInsnNode).setOpcode(161);
                        break block1;
                    }
                    abstractInsnNode = abstractInsnNode.getNext();
                }
            }
            ClassWriter classWriter = new ClassWriter(1);
            classNode.accept((ClassVisitor)classWriter);
            byArray = classWriter.toByteArray();
        }
        return byArray;
    }

    private static byte[] alterLongHashMap(String string, byte[] byArray, ClassReader classReader) {
        ClassNode classNode;
        Object object;
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_76155_g", "func_76160_c", "func_76161_b"} : new String[]{"getHashedKey", "getEntry", "containsItem"};
        ClassNode classNode2 = new ClassNode(327680);
        classReader.accept((ClassVisitor)classNode2, 8);
        boolean bl = false;
        MethodNode methodNode = null;
        Object object2 = null;
        for (Object object3 : classNode2.methods) {
            object = ((MethodNode)object3).name;
            if (stringArray[0].equals(object) && "(J)I".equals(((MethodNode)object3).desc)) {
                bl = true;
                int n = ((MethodNode)object3).instructions.size();
                for (int i = 0; i < n; ++i) {
                    AbstractInsnNode abstractInsnNode = ((MethodNode)object3).instructions.get(i);
                    if (abstractInsnNode.getOpcode() != 131) continue;
                    ((MethodNode)object3).instructions.insertBefore(abstractInsnNode, (AbstractInsnNode)new LdcInsnNode((Object)new Long(13L)));
                    ((MethodNode)object3).instructions.insertBefore(abstractInsnNode, (AbstractInsnNode)new InsnNode(105));
                    break;
                }
                if (object2 == null) continue;
                break;
            }
            if (!stringArray[2].equals(object) || !"(J)Z".equals(((MethodNode)object3).desc)) continue;
            object2 = object3;
            if (!bl) continue;
            break;
        }
        if (object2 != null) {
            Object object3;
            classNode = new ClassNode(327680);
            classReader.accept((ClassVisitor)classNode, 8);
            object3 = "(J)Lnet/minecraft/util/LongHashMap$Entry;";
            object = classNode.methods.iterator();
            while (object.hasNext()) {
                MethodNode methodNode2 = (MethodNode)object.next();
                String string2 = methodNode2.name;
                if (!stringArray[1].equals(string2) || !((String)object3).equals(methodNode2.desc)) continue;
                methodNode = methodNode2;
                break;
            }
            if (methodNode != null) {
                bl = true;
                ((MethodNode)object2).instructions.clear();
                ((MethodNode)object2).instructions.add(methodNode.instructions);
                for (object = ((MethodNode)object2).instructions.get(0); object != null; object = object.getNext()) {
                    if (object.getOpcode() != 176) continue;
                    AbstractInsnNode abstractInsnNode = object.getPrevious();
                    if (abstractInsnNode.getOpcode() == 1) {
                        ((MethodNode)object2).instructions.set(abstractInsnNode, (AbstractInsnNode)new InsnNode(3));
                    } else {
                        ((MethodNode)object2).instructions.set(abstractInsnNode, (AbstractInsnNode)new InsnNode(4));
                    }
                    Object object4 = object;
                    object = new InsnNode(172);
                    ((MethodNode)object2).instructions.set((AbstractInsnNode)object4, (AbstractInsnNode)object);
                }
            }
        }
        if (bl) {
            classNode = new ClassWriter(1);
            classNode2.accept((ClassVisitor)classNode);
            byArray = classNode.toByteArray();
        }
        return byArray;
    }

    private static byte[] alterController(String string, byte[] byArray, ClassReader classReader) {
        block7: {
            String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_85182_a", "field_85183_f"} : new String[]{"sameToolAndBlock", "currentItemHittingBlock"};
            string = string.replace('.', '/');
            ClassNode classNode = new ClassNode(327680);
            classReader.accept((ClassVisitor)classNode, 8);
            MethodNode methodNode = null;
            for (MethodNode methodNode2 : classNode.methods) {
                if (!stringArray[0].equals(methodNode2.name) || !"(III)Z".equals(methodNode2.desc)) continue;
                methodNode = methodNode2;
                break;
            }
            if (methodNode != null) {
                int n = methodNode.instructions.size();
                for (int i = 0; i < n; ++i) {
                    AbstractInsnNode abstractInsnNode = methodNode.instructions.get(i);
                    if (abstractInsnNode.getOpcode() != 182) continue;
                    MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
                    if (!"net/minecraft/item/ItemStack".equals(methodInsnNode.owner)) continue;
                    LabelNode labelNode = null;
                    LabelNode labelNode2 = null;
                    block2: for (int j = i; j < n; ++j) {
                        int n2;
                        abstractInsnNode = methodNode.instructions.get(j);
                        if (abstractInsnNode.getOpcode() != 4) continue;
                        for (n2 = j; n2 > i; --n2) {
                            abstractInsnNode = methodNode.instructions.get(n2);
                            if (abstractInsnNode.getType() != 8) continue;
                            labelNode = (LabelNode)abstractInsnNode;
                            break;
                        }
                        for (n2 = j; n2 < n; ++n2) {
                            abstractInsnNode = methodNode.instructions.get(n2);
                            if (abstractInsnNode.getType() != 8) continue;
                            labelNode2 = (LabelNode)abstractInsnNode;
                            break block2;
                        }
                    }
                    if (labelNode != null && labelNode2 != null) {
                        methodNode.instructions.insertBefore((AbstractInsnNode)methodInsnNode, (AbstractInsnNode)new VarInsnNode(25, 0));
                        methodNode.instructions.insertBefore((AbstractInsnNode)methodInsnNode, (AbstractInsnNode)new FieldInsnNode(180, string, stringArray[1], "Lnet/minecraft/item/ItemStack;"));
                        methodNode.instructions.insertBefore((AbstractInsnNode)methodInsnNode, (AbstractInsnNode)new MethodInsnNode(184, "cofh/asmhooks/HooksCore", "areItemsEqualHook", "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/ItemStack;)Z", false));
                        methodNode.instructions.insertBefore((AbstractInsnNode)methodInsnNode, (AbstractInsnNode)new JumpInsnNode(153, labelNode2));
                        methodNode.instructions.insertBefore((AbstractInsnNode)methodInsnNode, (AbstractInsnNode)new JumpInsnNode(167, labelNode));
                        break;
                    }
                    break block7;
                }
                ClassWriter classWriter = new ClassWriter(1);
                classNode.accept((ClassVisitor)classWriter);
                byArray = classWriter.toByteArray();
            }
        }
        return byArray;
    }

    private static byte[] alterTileEntity(String string, byte[] byArray, ClassReader classReader) {
        string = string.replace('.', '/');
        ClassWriter classWriter = new ClassWriter(1);
        classReader.accept((ClassVisitor)classWriter, 0);
        classWriter.newMethod(string, "cofh_validate", "()V", true);
        MethodVisitor methodVisitor = classWriter.visitMethod(4097, "cofh_validate", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 1);
        methodVisitor.visitEnd();
        classWriter.visitEnd();
        classWriter.newMethod(string, "cofh_invalidate", "()V", true);
        methodVisitor = classWriter.visitMethod(4097, "cofh_invalidate", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 1);
        methodVisitor.visitEnd();
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    private static byte[] writeWorld(String string, byte[] byArray, ClassReader classReader) {
        LabelNode labelNode;
        AbstractInsnNode abstractInsnNode;
        LabelNode labelNode2;
        MethodNode methodNode7;
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"field_73019_z", "field_72986_A", "field_73011_w", "field_72984_F", "func_147448_a", "func_147455_a", "func_72939_s", "func_145830_o", "field_147481_N", "func_147457_a"} : new String[]{"saveHandler", "worldInfo", "provider", "theProfiler", "func_147448_a", "setTileEntity", "updateEntities", "hasWorldObj", "field_147481_N", "func_147457_a"};
        string = string.replace('.', '/');
        ClassNode classNode = new ClassNode(327680);
        classReader.accept((ClassVisitor)classNode, 8);
        MethodNode methodNode2 = null;
        MethodNode methodNode3 = null;
        MethodNode methodNode4 = null;
        MethodNode methodNode5 = null;
        MethodNode methodNode6 = null;
        boolean bl = false;
        for (MethodNode methodNode7 : classNode.methods) {
            if ("<init>".equals(methodNode7.name)) {
                if ("(Lnet/minecraft/world/storage/ISaveHandler;Ljava/lang/String;Lnet/minecraft/world/WorldProvider;Lnet/minecraft/world/WorldSettings;Lnet/minecraft/profiler/Profiler;)V".equals(methodNode7.desc)) {
                    bl = true;
                }
                labelNode2 = new LabelNode(new Label());
                abstractInsnNode = methodNode7.instructions.getFirst();
                while (abstractInsnNode.getOpcode() != 183 || !((MethodInsnNode)abstractInsnNode).name.equals("<init>")) {
                    abstractInsnNode = abstractInsnNode.getNext();
                }
                AbstractInsnNode abstractInsnNode2 = abstractInsnNode;
                abstractInsnNode = labelNode2;
                methodNode7.instructions.insert(abstractInsnNode2, abstractInsnNode);
                AbstractInsnNode abstractInsnNode3 = abstractInsnNode;
                abstractInsnNode = new LineNumberNode(-15000, labelNode2);
                methodNode7.instructions.insert(abstractInsnNode3, abstractInsnNode);
                AbstractInsnNode abstractInsnNode4 = abstractInsnNode;
                abstractInsnNode = new VarInsnNode(25, 0);
                methodNode7.instructions.insert(abstractInsnNode4, abstractInsnNode);
                AbstractInsnNode abstractInsnNode5 = abstractInsnNode;
                abstractInsnNode = new TypeInsnNode(187, "cofh/lib/util/IdentityLinkedHashList");
                methodNode7.instructions.insert(abstractInsnNode5, abstractInsnNode);
                AbstractInsnNode abstractInsnNode6 = abstractInsnNode;
                abstractInsnNode = new InsnNode(89);
                methodNode7.instructions.insert(abstractInsnNode6, abstractInsnNode);
                AbstractInsnNode abstractInsnNode7 = abstractInsnNode;
                abstractInsnNode = new MethodInsnNode(183, "cofh/lib/util/IdentityLinkedHashList", "<init>", "()V", false);
                methodNode7.instructions.insert(abstractInsnNode7, abstractInsnNode);
                AbstractInsnNode abstractInsnNode8 = abstractInsnNode;
                abstractInsnNode = new FieldInsnNode(181, "net/minecraft/world/World", "cofh_recentTiles", "Lcofh/lib/util/LinkedHashList;");
                methodNode7.instructions.insert(abstractInsnNode8, abstractInsnNode);
                continue;
            }
            if ("addTileEntity".equals(methodNode7.name) && "(Lnet/minecraft/tileentity/TileEntity;)V".equals(methodNode7.desc)) {
                methodNode2 = methodNode7;
                continue;
            }
            if (stringArray[4].equals(methodNode7.name) && "(Ljava/util/Collection;)V".equals(methodNode7.desc)) {
                methodNode3 = methodNode7;
                continue;
            }
            if (stringArray[5].equals(methodNode7.name) && "(IIILnet/minecraft/tileentity/TileEntity;)V".equals(methodNode7.desc)) {
                methodNode4 = methodNode7;
                continue;
            }
            if (stringArray[6].equals(methodNode7.name) && "()V".equals(methodNode7.desc)) {
                methodNode5 = methodNode7;
                continue;
            }
            if (!stringArray[9].equals(methodNode7.name) || !"(Lnet/minecraft/tileentity/TileEntity;)V".equals(methodNode7.desc)) continue;
            methodNode6 = methodNode7;
        }
        classNode.fields.add(new FieldNode(4098, "cofh_recentTiles", "Lcofh/lib/util/LinkedHashList;", null, null));
        if (methodNode6 != null) {
            labelNode = new LabelNode(new Label());
            methodNode7 = labelNode;
            methodNode6.instructions.insert((AbstractInsnNode)methodNode7);
            MethodNode methodNode8 = methodNode7;
            methodNode7 = new LineNumberNode(-15005, labelNode);
            methodNode6.instructions.insert((AbstractInsnNode)methodNode8, (AbstractInsnNode)methodNode7);
            MethodNode methodNode9 = methodNode7;
            methodNode7 = new VarInsnNode(25, 1);
            methodNode6.instructions.insert((AbstractInsnNode)methodNode9, (AbstractInsnNode)methodNode7);
            MethodNode methodNode10 = methodNode7;
            methodNode7 = new MethodInsnNode(182, "net/minecraft/tileentity/TileEntity", "cofh_invalidate", "()V", false);
            methodNode6.instructions.insert((AbstractInsnNode)methodNode10, (AbstractInsnNode)methodNode7);
        }
        if (methodNode2 != null) {
            labelNode = new LabelNode(new Label());
            methodNode7 = labelNode;
            methodNode2.instructions.insert((AbstractInsnNode)methodNode7);
            MethodNode methodNode11 = methodNode7;
            methodNode7 = new LineNumberNode(-15001, labelNode);
            methodNode2.instructions.insert((AbstractInsnNode)methodNode11, (AbstractInsnNode)methodNode7);
            MethodNode methodNode12 = methodNode7;
            methodNode7 = new VarInsnNode(25, 0);
            methodNode2.instructions.insert((AbstractInsnNode)methodNode12, (AbstractInsnNode)methodNode7);
            MethodNode methodNode13 = methodNode7;
            methodNode7 = new FieldInsnNode(180, "net/minecraft/world/World", "cofh_recentTiles", "Lcofh/lib/util/LinkedHashList;");
            methodNode2.instructions.insert((AbstractInsnNode)methodNode13, (AbstractInsnNode)methodNode7);
            MethodNode methodNode14 = methodNode7;
            methodNode7 = new VarInsnNode(25, 1);
            methodNode2.instructions.insert((AbstractInsnNode)methodNode14, (AbstractInsnNode)methodNode7);
            MethodNode methodNode15 = methodNode7;
            methodNode7 = new MethodInsnNode(182, "cofh/lib/util/LinkedHashList", "push", "(Ljava/lang/Object;)Z", false);
            methodNode2.instructions.insert((AbstractInsnNode)methodNode15, (AbstractInsnNode)methodNode7);
            MethodNode methodNode16 = methodNode7;
            methodNode7 = new InsnNode(87);
            methodNode2.instructions.insert((AbstractInsnNode)methodNode16, (AbstractInsnNode)methodNode7);
        }
        if (methodNode4 != null) {
            labelNode = new LabelNode(new Label());
            methodNode7 = methodNode4.instructions.getLast();
            while (methodNode7.getOpcode() != 177) {
                methodNode7 = methodNode7.getPrevious();
            }
            methodNode7 = methodNode7.getPrevious();
            methodNode7 = labelNode;
            methodNode4.instructions.insert((AbstractInsnNode)methodNode7);
            MethodNode methodNode17 = methodNode7;
            methodNode7 = new LineNumberNode(-15002, labelNode);
            methodNode4.instructions.insert((AbstractInsnNode)methodNode17, (AbstractInsnNode)methodNode7);
            MethodNode methodNode18 = methodNode7;
            methodNode7 = new VarInsnNode(25, 0);
            methodNode4.instructions.insert((AbstractInsnNode)methodNode18, (AbstractInsnNode)methodNode7);
            MethodNode methodNode19 = methodNode7;
            methodNode7 = new FieldInsnNode(180, "net/minecraft/world/World", "cofh_recentTiles", "Lcofh/lib/util/LinkedHashList;");
            methodNode4.instructions.insert((AbstractInsnNode)methodNode19, (AbstractInsnNode)methodNode7);
            MethodNode methodNode20 = methodNode7;
            methodNode7 = new VarInsnNode(25, 4);
            methodNode4.instructions.insert((AbstractInsnNode)methodNode20, (AbstractInsnNode)methodNode7);
            MethodNode methodNode21 = methodNode7;
            methodNode7 = new MethodInsnNode(182, "cofh/lib/util/LinkedHashList", "push", "(Ljava/lang/Object;)Z", false);
            methodNode4.instructions.insert((AbstractInsnNode)methodNode21, (AbstractInsnNode)methodNode7);
            MethodNode methodNode22 = methodNode7;
            methodNode7 = new InsnNode(87);
            methodNode4.instructions.insert((AbstractInsnNode)methodNode22, (AbstractInsnNode)methodNode7);
        }
        if (methodNode3 != null) {
            labelNode = new LabelNode(new Label());
            methodNode7 = methodNode3.instructions.getFirst();
            while (true) {
                if (methodNode7.getOpcode() != 192) {
                    methodNode7 = methodNode7.getNext();
                    continue;
                }
                if (((TypeInsnNode)methodNode7).desc.equals("net/minecraft/tileentity/TileEntity")) break;
            }
            MethodNode methodNode23 = methodNode7;
            methodNode7 = labelNode;
            methodNode3.instructions.insert((AbstractInsnNode)methodNode23, (AbstractInsnNode)methodNode7);
            MethodNode methodNode24 = methodNode7;
            methodNode7 = new LineNumberNode(-15003, labelNode);
            methodNode3.instructions.insert((AbstractInsnNode)methodNode24, (AbstractInsnNode)methodNode7);
            MethodNode methodNode25 = methodNode7;
            methodNode7 = new InsnNode(89);
            methodNode3.instructions.insert((AbstractInsnNode)methodNode25, (AbstractInsnNode)methodNode7);
            MethodNode methodNode26 = methodNode7;
            methodNode7 = new VarInsnNode(25, 0);
            methodNode3.instructions.insert((AbstractInsnNode)methodNode26, (AbstractInsnNode)methodNode7);
            MethodNode methodNode27 = methodNode7;
            methodNode7 = new FieldInsnNode(180, "net/minecraft/world/World", "cofh_recentTiles", "Lcofh/lib/util/LinkedHashList;");
            methodNode3.instructions.insert((AbstractInsnNode)methodNode27, (AbstractInsnNode)methodNode7);
            MethodNode methodNode28 = methodNode7;
            methodNode7 = new InsnNode(95);
            methodNode3.instructions.insert((AbstractInsnNode)methodNode28, (AbstractInsnNode)methodNode7);
            MethodNode methodNode29 = methodNode7;
            methodNode7 = new MethodInsnNode(182, "cofh/lib/util/LinkedHashList", "push", "(Ljava/lang/Object;)Z", false);
            methodNode3.instructions.insert((AbstractInsnNode)methodNode29, (AbstractInsnNode)methodNode7);
            MethodNode methodNode30 = methodNode7;
            methodNode7 = new InsnNode(87);
            methodNode3.instructions.insert((AbstractInsnNode)methodNode30, (AbstractInsnNode)methodNode7);
        }
        if (methodNode5 != null) {
            labelNode = methodNode5.instructions.getFirst();
            while (labelNode.getOpcode() != 182 || !"onChunkUnload".equals(((MethodInsnNode)labelNode).name) || !"()V".equals(((MethodInsnNode)labelNode).desc)) {
                labelNode = labelNode.getNext();
            }
            while (labelNode.getOpcode() != 181 || !stringArray[8].equals(((FieldInsnNode)labelNode).name)) {
                labelNode = labelNode.getPrevious();
            }
            labelNode = labelNode.getNext();
            methodNode7 = new LabelNode(new Label());
            labelNode2 = new LabelNode(new Label());
            abstractInsnNode = new LabelNode(new Label());
            LabelNode labelNode3 = new LabelNode(new Label());
            LabelNode labelNode4 = labelNode;
            labelNode = labelNode3;
            methodNode5.instructions.insertBefore((AbstractInsnNode)labelNode4, (AbstractInsnNode)labelNode);
            LabelNode labelNode5 = labelNode;
            labelNode = new LineNumberNode(-15004, labelNode3);
            methodNode5.instructions.insert((AbstractInsnNode)labelNode5, (AbstractInsnNode)labelNode);
            LabelNode labelNode6 = labelNode;
            labelNode = new JumpInsnNode(167, labelNode2);
            methodNode5.instructions.insert((AbstractInsnNode)labelNode6, (AbstractInsnNode)labelNode);
            LabelNode labelNode7 = labelNode;
            labelNode = methodNode7;
            methodNode5.instructions.insert((AbstractInsnNode)labelNode7, (AbstractInsnNode)labelNode);
            LabelNode labelNode8 = labelNode;
            labelNode = new FrameNode(3, 0, null, 0, null);
            methodNode5.instructions.insert((AbstractInsnNode)labelNode8, (AbstractInsnNode)labelNode);
            LabelNode labelNode9 = labelNode;
            labelNode = new VarInsnNode(25, 0);
            methodNode5.instructions.insert((AbstractInsnNode)labelNode9, (AbstractInsnNode)labelNode);
            LabelNode labelNode10 = labelNode;
            labelNode = new FieldInsnNode(180, "net/minecraft/world/World", "cofh_recentTiles", "Lcofh/lib/util/LinkedHashList;");
            methodNode5.instructions.insert((AbstractInsnNode)labelNode10, (AbstractInsnNode)labelNode);
            LabelNode labelNode11 = labelNode;
            labelNode = new MethodInsnNode(182, "cofh/lib/util/LinkedHashList", "shift", "()Ljava/lang/Object;", false);
            methodNode5.instructions.insert((AbstractInsnNode)labelNode11, (AbstractInsnNode)labelNode);
            LabelNode labelNode12 = labelNode;
            labelNode = new TypeInsnNode(192, "net/minecraft/tileentity/TileEntity");
            methodNode5.instructions.insert((AbstractInsnNode)labelNode12, (AbstractInsnNode)labelNode);
            LabelNode labelNode13 = labelNode;
            labelNode = new InsnNode(89);
            methodNode5.instructions.insert((AbstractInsnNode)labelNode13, (AbstractInsnNode)labelNode);
            LabelNode labelNode14 = labelNode;
            labelNode = new JumpInsnNode(198, (LabelNode)abstractInsnNode);
            methodNode5.instructions.insert((AbstractInsnNode)labelNode14, (AbstractInsnNode)labelNode);
            LabelNode labelNode15 = labelNode;
            labelNode = new InsnNode(89);
            methodNode5.instructions.insert((AbstractInsnNode)labelNode15, (AbstractInsnNode)labelNode);
            LabelNode labelNode16 = labelNode;
            labelNode = new MethodInsnNode(182, "net/minecraft/tileentity/TileEntity", stringArray[7], "()Z", false);
            methodNode5.instructions.insert((AbstractInsnNode)labelNode16, (AbstractInsnNode)labelNode);
            LabelNode labelNode17 = labelNode;
            labelNode = new JumpInsnNode(153, (LabelNode)abstractInsnNode);
            methodNode5.instructions.insert((AbstractInsnNode)labelNode17, (AbstractInsnNode)labelNode);
            LabelNode labelNode18 = labelNode;
            labelNode = new MethodInsnNode(182, "net/minecraft/tileentity/TileEntity", "cofh_validate", "()V", false);
            methodNode5.instructions.insert((AbstractInsnNode)labelNode18, (AbstractInsnNode)labelNode);
            LabelNode labelNode19 = labelNode;
            labelNode = new InsnNode(1);
            methodNode5.instructions.insert((AbstractInsnNode)labelNode19, (AbstractInsnNode)labelNode);
            LabelNode labelNode20 = labelNode;
            labelNode = abstractInsnNode;
            methodNode5.instructions.insert((AbstractInsnNode)labelNode20, (AbstractInsnNode)labelNode);
            LabelNode labelNode21 = labelNode;
            labelNode = new FrameNode(4, 0, null, 0, new Object[]{"Lnet/minecraft/tileentity/TileEntity;"});
            methodNode5.instructions.insert((AbstractInsnNode)labelNode21, (AbstractInsnNode)labelNode);
            LabelNode labelNode22 = labelNode;
            labelNode = new InsnNode(87);
            methodNode5.instructions.insert((AbstractInsnNode)labelNode22, (AbstractInsnNode)labelNode);
            LabelNode labelNode23 = labelNode;
            labelNode = labelNode2;
            methodNode5.instructions.insert((AbstractInsnNode)labelNode23, (AbstractInsnNode)labelNode);
            LabelNode labelNode24 = labelNode;
            labelNode = new FrameNode(3, 0, null, 0, null);
            methodNode5.instructions.insert((AbstractInsnNode)labelNode24, (AbstractInsnNode)labelNode);
            LabelNode labelNode25 = labelNode;
            labelNode = new VarInsnNode(25, 0);
            methodNode5.instructions.insert((AbstractInsnNode)labelNode25, (AbstractInsnNode)labelNode);
            LabelNode labelNode26 = labelNode;
            labelNode = new FieldInsnNode(180, "net/minecraft/world/World", "cofh_recentTiles", "Lcofh/lib/util/LinkedHashList;");
            methodNode5.instructions.insert((AbstractInsnNode)labelNode26, (AbstractInsnNode)labelNode);
            LabelNode labelNode27 = labelNode;
            labelNode = new MethodInsnNode(182, "cofh/lib/util/LinkedHashList", "size", "()I", false);
            methodNode5.instructions.insert((AbstractInsnNode)labelNode27, (AbstractInsnNode)labelNode);
            LabelNode labelNode28 = labelNode;
            labelNode = new JumpInsnNode(154, (LabelNode)methodNode7);
            methodNode5.instructions.insert((AbstractInsnNode)labelNode28, (AbstractInsnNode)labelNode);
        }
        labelNode = new ClassWriter(2);
        classNode.accept((ClassVisitor)labelNode);
        if (!bl) {
            labelNode.newMethod(string, "<init>", "(Lnet/minecraft/world/storage/ISaveHandler;Ljava/lang/String;Lnet/minecraft/world/WorldProvider;Lnet/minecraft/world/WorldSettings;Lnet/minecraft/profiler/Profiler;)V", true);
            methodNode7 = labelNode.visitMethod(1, "<init>", "(Lnet/minecraft/world/storage/ISaveHandler;Ljava/lang/String;Lnet/minecraft/world/WorldProvider;Lnet/minecraft/world/WorldSettings;Lnet/minecraft/profiler/Profiler;)V", null, null);
            methodNode7.visitCode();
            methodNode7.visitVarInsn(25, 0);
            methodNode7.visitInsn(89);
            methodNode7.visitInsn(89);
            methodNode7.visitInsn(89);
            methodNode7.visitInsn(89);
            methodNode7.visitInsn(89);
            methodNode7.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
            methodNode7.visitVarInsn(25, 1);
            methodNode7.visitFieldInsn(181, string, stringArray[0], "Lnet/minecraft/world/storage/ISaveHandler;");
            methodNode7.visitTypeInsn(187, "net/minecraft/world/storage/WorldInfo");
            methodNode7.visitInsn(89);
            methodNode7.visitVarInsn(25, 4);
            methodNode7.visitVarInsn(25, 2);
            methodNode7.visitMethodInsn(183, "net/minecraft/world/storage/WorldInfo", "<init>", "(Lnet/minecraft/world/WorldSettings;Ljava/lang/String;)V", false);
            methodNode7.visitFieldInsn(181, string, stringArray[1], "Lnet/minecraft/world/storage/WorldInfo;");
            methodNode7.visitVarInsn(25, 3);
            methodNode7.visitFieldInsn(181, string, stringArray[2], "Lnet/minecraft/world/WorldProvider;");
            methodNode7.visitVarInsn(25, 5);
            methodNode7.visitFieldInsn(181, string, stringArray[3], "Lnet/minecraft/profiler/Profiler;");
            methodNode7.visitInsn(177);
            methodNode7.visitMaxs(11, 10);
            methodNode7.visitEnd();
            labelNode.visitEnd();
        }
        byArray = labelNode.toByteArray();
        return byArray;
    }

    private static byte[] writeWorldServer(String string, byte[] byArray, ClassReader classReader) {
        block1: {
            MethodNode methodNode2;
            String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"field_73061_a", "field_73062_L", "field_73063_M", "field_85177_Q"} : new String[]{"mcServer", "theEntityTracker", "thePlayerManager", "worldTeleporter"};
            string = string.replace('.', '/');
            ClassNode classNode = new ClassNode(327680);
            classReader.accept((ClassVisitor)classNode, 8);
            for (MethodNode methodNode2 : classNode.methods) {
                if (!"<init>".equals(methodNode2.name) || !"(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/world/storage/ISaveHandler;Ljava/lang/String;Lnet/minecraft/world/WorldProvider;Lnet/minecraft/world/WorldSettings;Lnet/minecraft/profiler/Profiler;)V".equals(methodNode2.desc)) continue;
                break block1;
            }
            ClassWriter classWriter = new ClassWriter(2);
            classNode.accept((ClassVisitor)classWriter);
            classWriter.newMethod(string, "<init>", "(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/world/storage/ISaveHandler;Ljava/lang/String;Lnet/minecraft/world/WorldProvider;Lnet/minecraft/world/WorldSettings;Lnet/minecraft/profiler/Profiler;)V", true);
            methodNode2 = classWriter.visitMethod(1, "<init>", "(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/world/storage/ISaveHandler;Ljava/lang/String;Lnet/minecraft/world/WorldProvider;Lnet/minecraft/world/WorldSettings;Lnet/minecraft/profiler/Profiler;)V", null, null);
            methodNode2.visitCode();
            methodNode2.visitVarInsn(25, 0);
            methodNode2.visitInsn(89);
            methodNode2.visitInsn(89);
            methodNode2.visitInsn(89);
            methodNode2.visitInsn(89);
            methodNode2.visitVarInsn(25, 2);
            methodNode2.visitVarInsn(25, 3);
            methodNode2.visitVarInsn(25, 4);
            methodNode2.visitVarInsn(25, 5);
            methodNode2.visitVarInsn(25, 6);
            methodNode2.visitMethodInsn(183, "net/minecraft/world/World", "<init>", "(Lnet/minecraft/world/storage/ISaveHandler;Ljava/lang/String;Lnet/minecraft/world/WorldProvider;Lnet/minecraft/world/WorldSettings;Lnet/minecraft/profiler/Profiler;)V", false);
            methodNode2.visitVarInsn(25, 1);
            methodNode2.visitFieldInsn(181, string, stringArray[0], "Lnet/minecraft/server/MinecraftServer;");
            methodNode2.visitInsn(1);
            methodNode2.visitFieldInsn(181, string, stringArray[1], "Lnet/minecraft/entity/EntityTracker;");
            methodNode2.visitInsn(1);
            methodNode2.visitFieldInsn(181, string, stringArray[2], "Lnet/minecraft/server/management/PlayerManager;");
            methodNode2.visitInsn(1);
            methodNode2.visitFieldInsn(181, string, stringArray[3], "Lnet/minecraft/world/Teleporter;");
            methodNode2.visitInsn(177);
            methodNode2.visitMaxs(11, 10);
            methodNode2.visitEnd();
            classWriter.visitEnd();
            byArray = classWriter.toByteArray();
        }
        return byArray;
    }

    private static byte[] writeWorldProxy(String string, byte[] byArray, ClassReader classReader) {
        ClassWriter classWriter = null;
        try {
            classWriter = World.class.getDeclaredMethods();
        }
        catch (Throwable throwable) {
            Throwables.propagate((Throwable)throwable);
        }
        ClassNode classNode = new ClassNode(327680);
        classReader.accept((ClassVisitor)classNode, 4);
        for (Method method : classWriter) {
            Type[] typeArray;
            if (Modifier.isStatic(method.getModifiers())) continue;
            String string2 = Type.getMethodDescriptor((Method)method);
            MethodVisitor methodVisitor = classNode.methods.iterator();
            while (methodVisitor.hasNext()) {
                typeArray = (Type[])methodVisitor.next();
                if (!typeArray.name.equals(method.getName()) || !typeArray.desc.equals(string2)) continue;
                methodVisitor.remove();
            }
            methodVisitor = classNode.visitMethod(ASMCore.getAccess(method), method.getName(), string2, null, ASMCore.getExceptions(method));
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, "skyboy/core/world/WorldProxy", "proxiedWorld", "Lnet/minecraft/world/World;");
            typeArray = Type.getArgumentTypes((Method)method);
            int n = 1;
            int n2 = typeArray.length;
            for (int i = 0; i < n2; ++i) {
                methodVisitor.visitVarInsn(typeArray[i].getOpcode(21), n);
                n += typeArray[i].getSize();
            }
            methodVisitor.visitMethodInsn(182, "net/minecraft/world/World", method.getName(), string2, false);
            methodVisitor.visitInsn(Type.getReturnType((Method)method).getOpcode(172));
            methodVisitor.visitMaxs(1, 1);
            methodVisitor.visitEnd();
        }
        ClassWriter classWriter2 = new ClassWriter(2);
        classNode.accept((ClassVisitor)classWriter2);
        return classWriter2.toByteArray();
    }

    private static byte[] writeWorldServerProxy(String string, byte[] byArray, ClassReader classReader) {
        int n;
        int n2;
        int n3;
        Type[] typeArray;
        Object object;
        Method[] methodArray = null;
        try {
            methodArray = WorldServer.class.getDeclaredMethods();
        }
        catch (Throwable throwable) {
            Throwables.propagate((Throwable)throwable);
        }
        ClassWriter classWriter = null;
        try {
            classWriter = World.class.getDeclaredMethods();
        }
        catch (Throwable throwable) {
            Throwables.propagate((Throwable)throwable);
        }
        ClassNode classNode = new ClassNode(327680);
        classReader.accept((ClassVisitor)classNode, 4);
        classNode.superName = "net/minecraft/world/WorldServer";
        block4: for (MethodNode methodNode : classNode.methods) {
            if (!"<init>".equals(methodNode.name)) continue;
            InsnList insnList = methodNode.instructions;
            int n4 = insnList.size();
            for (int i = 0; i < n4; ++i) {
                object = insnList.get(i);
                if (!(object instanceof MethodInsnNode) || (typeArray = (Type[])object).getOpcode() != 183) continue;
                typeArray.owner = classNode.superName;
                continue block4;
            }
        }
        for (Method method : classWriter) {
            if (Modifier.isStatic(method.getModifiers())) continue;
            String string2 = Type.getMethodDescriptor((Method)method);
            object = classNode.methods.iterator();
            while (object.hasNext()) {
                typeArray = (MethodNode)object.next();
                if (!typeArray.name.equals(method.getName()) || !typeArray.desc.equals(string2)) continue;
                object.remove();
            }
            object = classNode.visitMethod(ASMCore.getAccess(method), method.getName(), string2, null, ASMCore.getExceptions(method));
            object.visitCode();
            object.visitVarInsn(25, 0);
            object.visitFieldInsn(180, "skyboy/core/world/WorldServerProxy", "proxiedWorld", "Lnet/minecraft/world/WorldServer;");
            typeArray = Type.getArgumentTypes((Method)method);
            n3 = 1;
            n2 = typeArray.length;
            for (n = 0; n < n2; ++n) {
                object.visitVarInsn(typeArray[n].getOpcode(21), n3);
                n3 += typeArray[n].getSize();
            }
            object.visitMethodInsn(182, "net/minecraft/world/World", method.getName(), string2, false);
            object.visitInsn(Type.getReturnType((Method)method).getOpcode(172));
            object.visitMaxs(1, 1);
            object.visitEnd();
        }
        for (Method method : methodArray) {
            if (Modifier.isStatic(method.getModifiers())) continue;
            String string3 = Type.getMethodDescriptor((Method)method);
            object = classNode.methods.iterator();
            while (object.hasNext()) {
                typeArray = (MethodNode)object.next();
                if (!typeArray.name.equals(method.getName()) || !typeArray.desc.equals(string3)) continue;
                object.remove();
            }
            object = classNode.visitMethod(ASMCore.getAccess(method), method.getName(), string3, null, ASMCore.getExceptions(method));
            object.visitCode();
            object.visitVarInsn(25, 0);
            object.visitFieldInsn(180, "skyboy/core/world/WorldServerProxy", "proxiedWorld", "Lnet/minecraft/world/WorldServer;");
            typeArray = Type.getArgumentTypes((Method)method);
            n3 = 1;
            n2 = typeArray.length;
            for (n = 0; n < n2; ++n) {
                object.visitVarInsn(typeArray[n].getOpcode(21), n3);
                n3 += typeArray[n].getSize();
            }
            object.visitMethodInsn(182, "net/minecraft/world/WorldServer", method.getName(), string3, false);
            object.visitInsn(Type.getReturnType((Method)method).getOpcode(172));
            object.visitMaxs(1, 1);
            object.visitEnd();
        }
        ClassWriter classWriter2 = new ClassWriter(2);
        classNode.accept((ClassVisitor)classWriter2);
        byArray = classWriter2.toByteArray();
        return byArray;
    }

    private static int getAccess(Method method) {
        int n = method.getModifiers();
        n &= 0xFFFFFBA8;
        return n |= 0x1001;
    }

    private static String[] getExceptions(Method method) {
        Class<?>[] classArray = method.getExceptionTypes();
        if (classArray == null) {
            return null;
        }
        String[] stringArray = new String[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            stringArray[i] = Type.getInternalName(classArray[i]);
        }
        return stringArray;
    }

    static boolean implement(ClassNode classNode) {
        if (classNode.visibleAnnotations == null) {
            return false;
        }
        boolean bl = false;
        for (AnnotationNode annotationNode : classNode.visibleAnnotations) {
            AnnotationInfo annotationInfo = ASMCore.parseAnnotation(annotationNode, implementableDesc);
            if (annotationInfo == null || annotationInfo.side != "NONE" && side != annotationInfo.side) continue;
            String[] stringArray = annotationInfo.values;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i].trim();
                String string2 = string.replace('.', '/');
                if (classNode.interfaces.contains(string2)) continue;
                try {
                    if (!workingPath.contains(string)) {
                        Class.forName(string, false, ASMCore.class.getClassLoader());
                    }
                    classNode.interfaces.add(string2);
                    bl = true;
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    static boolean strip(ClassNode classNode) {
        Iterator iterator;
        AnnotationNode annotationNode2;
        boolean bl = false;
        if (classNode.visibleAnnotations != null) {
            for (AnnotationNode annotationNode2 : classNode.visibleAnnotations) {
                AnnotationInfo annotationInfo = ASMCore.parseAnnotation(annotationNode2, strippableDesc);
                if (annotationInfo == null) continue;
                AnnotationNode annotationNode3 = annotationInfo.values;
                boolean bl2 = side == annotationInfo.side;
                for (AnnotationNode annotationNode4 : annotationNode3) {
                    String string = annotationNode4.replace('.', '/');
                    if (!classNode.interfaces.contains(string)) continue;
                    boolean bl3 = true;
                    try {
                        if (!bl2 && !workingPath.contains(annotationNode4)) {
                            Class.forName((String)annotationNode4, false, ASMCore.class.getClassLoader());
                            bl3 = false;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (!bl3) continue;
                    classNode.interfaces.remove(string);
                    bl = true;
                }
            }
        }
        if (classNode.methods != null) {
            iterator = classNode.methods.iterator();
            block4: while (iterator.hasNext()) {
                annotationNode2 = (MethodNode)iterator.next();
                if (annotationNode2.visibleAnnotations == null) continue;
                for (AnnotationNode annotationNode3 : annotationNode2.visibleAnnotations) {
                    if (!ASMCore.checkRemove(ASMCore.parseAnnotation(annotationNode3, strippableDesc), iterator)) continue;
                    bl = true;
                    continue block4;
                }
            }
        }
        if (classNode.fields != null) {
            iterator = classNode.fields.iterator();
            block6: while (iterator.hasNext()) {
                annotationNode2 = (FieldNode)iterator.next();
                if (annotationNode2.visibleAnnotations == null) continue;
                for (AnnotationNode annotationNode3 : annotationNode2.visibleAnnotations) {
                    if (!ASMCore.checkRemove(ASMCore.parseAnnotation(annotationNode3, strippableDesc), iterator)) continue;
                    bl = true;
                    continue block6;
                }
            }
        }
        return bl;
    }

    static boolean checkRemove(AnnotationInfo annotationInfo, Iterator<? extends Object> iterator) {
        if (annotationInfo != null) {
            boolean bl;
            boolean bl2 = bl = annotationInfo.side == side;
            if (!bl) {
                for (String string : annotationInfo.values) {
                    block20: {
                        ModContainer modContainer;
                        String string2 = string.substring(4);
                        if (string.startsWith("mod:")) {
                            int n = string2.indexOf(64);
                            if (n > 0) {
                                string = string2.substring(n + 1);
                                string2 = string2.substring(0, n);
                            }
                            boolean bl3 = bl = !Loader.isModLoaded((String)string2);
                            if (!bl && n > 0) {
                                modContainer = ASMCore.getLoadedMods().get(string2);
                                try {
                                    if (Boolean.parseBoolean((String)modContainer.getCustomModProperties().get("cofhversion"))) {
                                        bl = !ModRange.createFromVersionSpec(string2, string).containsVersion((ArtifactVersion)new ModVersion(string2, modContainer.getVersion()));
                                        break block20;
                                    }
                                    bl = !VersionRange.createFromVersionSpec((String)string).containsVersion(modContainer.getProcessedVersion());
                                }
                                catch (InvalidVersionSpecificationException invalidVersionSpecificationException) {
                                    bl = true;
                                }
                            }
                        } else if (string.startsWith("api:")) {
                            int n = string2.indexOf(64);
                            if (n > 0) {
                                string = string2.substring(n + 1);
                                string2 = string2.substring(0, n);
                            }
                            boolean bl4 = bl = !ModAPIManager.INSTANCE.hasAPI(string2);
                            if (!bl && n > 0) {
                                modContainer = ASMCore.getLoadedAPIs().get(string2);
                                try {
                                    bl = !VersionRange.createFromVersionSpec((String)string).containsVersion(modContainer.getProcessedVersion());
                                }
                                catch (InvalidVersionSpecificationException invalidVersionSpecificationException) {
                                    bl = true;
                                }
                            }
                        } else {
                            try {
                                if (!workingPath.contains(string)) {
                                    Class.forName(string, false, ASMCore.class.getClassLoader());
                                }
                            }
                            catch (Throwable throwable) {
                                bl = true;
                            }
                        }
                    }
                    if (bl) break;
                }
            }
            if (bl) {
                iterator.remove();
                return true;
            }
        }
        return false;
    }

    static Map<String, ModContainer> getLoadedMods() {
        if (mods == null) {
            mods = new HashMap<String, ModContainer>();
            for (ModContainer modContainer : Loader.instance().getModList()) {
                mods.put(modContainer.getModId(), modContainer);
            }
        }
        return mods;
    }

    static Map<String, ModContainer> getLoadedAPIs() {
        if (apis == null) {
            apis = new HashMap<String, ModContainer>();
            for (ModContainer modContainer : ModAPIManager.INSTANCE.getAPIList()) {
                apis.put(modContainer.getModId(), modContainer);
            }
        }
        return apis;
    }

    static AnnotationInfo parseAnnotation(AnnotationNode annotationNode, String string) {
        AnnotationInfo annotationInfo = null;
        if (annotationNode.desc.equals(string)) {
            annotationInfo = new AnnotationInfo();
            if (annotationNode.values != null) {
                List list = annotationNode.values;
                int n = 0;
                int n2 = list.size();
                while (n < n2) {
                    String string2;
                    Object e = list.get(n++);
                    Object e2 = list.get(n++);
                    if ("value".equals(e)) {
                        if (!(e2 instanceof List) || ((List)e2).size() <= 0 || !(((List)e2).get(0) instanceof String)) continue;
                        annotationInfo.values = ((List)e2).toArray(emptyList);
                        continue;
                    }
                    if (!"side".equals(e) || !(e2 instanceof String[]) || (string2 = ((String[])e2)[1]) == null) continue;
                    annotationInfo.side = string2.toUpperCase().intern();
                }
            }
        }
        return annotationInfo;
    }

    static void scrapeData(ASMDataTable aSMDataTable) {
        String string;
        log.debug("Scraping data");
        side = FMLCommonHandler.instance().getSide().toString().toUpperCase().intern();
        for (ASMDataTable.ASMData aSMData : aSMDataTable.getAll(Implementable.class.getName())) {
            string = aSMData.getClassName();
            parsables.add((Object)string);
            parsables.add((Object)(string + "$class"));
            implementables.add((Object)string);
            implementables.add((Object)(string + "$class"));
        }
        for (ASMDataTable.ASMData aSMData : aSMDataTable.getAll(Strippable.class.getName())) {
            string = aSMData.getClassName();
            parsables.add((Object)string);
            parsables.add((Object)(string + "$class"));
            strippables.add((Object)string);
            strippables.add((Object)(string + "$class"));
        }
        log.debug("Found " + implementables.size() + " @Implementable and " + strippables.size() + " @Strippable");
    }

    static /* synthetic */ String[] access$000() {
        return emptyList;
    }

    static {
        implementableDesc = Type.getDescriptor(Implementable.class);
        strippableDesc = Type.getDescriptor(Strippable.class);
        parsables = new THashSet(10);
        implementables = new THashSet(10);
        strippables = new THashSet(10);
        hashes.put((Object)"net.minecraft.world.WorldServer", (byte)1);
        hashes.put((Object)"net.minecraft.world.World", (byte)2);
        hashes.put((Object)"skyboy.core.world.WorldProxy", (byte)3);
        hashes.put((Object)"skyboy.core.world.WorldServerProxy", (byte)4);
        hashes.put((Object)"net.minecraft.block.BlockPane", (byte)5);
        hashes.put((Object)"net.minecraft.block.Block", (byte)6);
        hashes.put((Object)"net.minecraft.client.multiplayer.PlayerControllerMP", (byte)7);
        hashes.put((Object)"net.minecraft.util.LongHashMap", (byte)8);
        if (Boolean.parseBoolean(System.getProperty("cofh.lightedit", "true"))) {
            hashes.put((Object)"net.minecraft.world.chunk.Chunk", (byte)9);
        }
        hashes.put((Object)"net.minecraft.client.Minecraft", (byte)10);
        hashes.put((Object)"net.minecraft.client.renderer.RenderBlocks", (byte)11);
        hashes.put((Object)"net.minecraft.tileentity.TileEntity", (byte)12);
        hashes.put((Object)"net.minecraft.server.management.PlayerManager$PlayerInstance", (byte)13);
        hashes.put((Object)"net.minecraft.entity.Entity", (byte)14);
        hashes.put((Object)"net.minecraft.entity.item.EntityItem", (byte)15);
        hashes.put((Object)"cofh.asmhooks.HooksCore", (byte)16);
        hashes.put((Object)"net.minecraft.enchantment.Enchantment", (byte)17);
        hashes.put((Object)"net.minecraft.item.Item", (byte)18);
        hashes.put((Object)"net.minecraft.client.gui.GuiKeyBindingList$KeyEntry", (byte)19);
        hashes.put((Object)"net.minecraft.client.settings.KeyBinding", (byte)20);
        workingPath = new ArrayList();
        emptyList = new String[0];
    }

    static class AnnotationInfo {
        public String side = "NONE";
        public String[] values = ASMCore.access$000();

        AnnotationInfo() {
        }
    }
}

