/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.gui.inventory;

import com.mrcrayfish.furniture.MrCrayfishFurnitureMod;
import com.mrcrayfish.furniture.items.IMail;
import com.mrcrayfish.furniture.util.NBTHelper;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventoryPackage
extends InventoryBasic {
    protected EntityPlayer playerEntity;
    protected static ItemStack packag3;
    protected boolean reading = false;
    protected String uniqueID = "";

    public InventoryPackage(EntityPlayer player, ItemStack packag3) {
        super("Package", false, InventoryPackage.getInventorySize());
        this.playerEntity = player;
        InventoryPackage.packag3 = packag3;
        if (!this.hasInventory()) {
            this.uniqueID = UUID.randomUUID().toString();
            this.createInventory();
        }
        this.loadInventory();
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (!this.reading) {
            this.saveInventory();
        }
    }

    public static boolean isSigned() {
        boolean isValid = false;
        if (packag3.func_77973_b() == MrCrayfishFurnitureMod.itemPackageSigned) {
            isValid = true;
        }
        return isValid;
    }

    public void func_70295_k_() {
        this.loadInventory();
    }

    public void func_70305_f() {
        this.saveInventory();
    }

    protected static int getInventorySize() {
        return 6;
    }

    protected boolean hasInventory() {
        return NBTHelper.hasTag(packag3, "Package");
    }

    protected void createInventory() {
        this.writeToNBT();
    }

    protected void setNBT() {
        for (ItemStack itemStack : this.playerEntity.field_71071_by.field_70462_a) {
            NBTTagCompound nbt;
            if (itemStack == null || !(itemStack.func_77973_b() instanceof IMail) || (nbt = itemStack.func_77978_p()) == null || nbt.func_74775_l("Package").func_74779_i("UniqueID") != this.uniqueID) continue;
            itemStack.func_77982_d(packag3.func_77978_p());
            break;
        }
    }

    public void loadInventory() {
        this.readFromNBT();
    }

    public void saveInventory() {
        this.writeToNBT();
        this.setNBT();
    }

    public String getSender() {
        return NBTHelper.getString(packag3, "Author");
    }

    protected void readFromNBT() {
        this.reading = true;
        NBTTagCompound nbt = NBTHelper.getCompoundTag(packag3, "Package");
        if ("".equals(this.uniqueID)) {
            this.uniqueID = nbt.func_74779_i("UniqueID");
            if ("".equals(this.uniqueID)) {
                this.uniqueID = UUID.randomUUID().toString();
            }
        }
        NBTTagList itemList = (NBTTagList)NBTHelper.getCompoundTag(packag3, "Package").func_74781_a("Items");
        for (int i = 0; i < itemList.func_74745_c(); ++i) {
            NBTTagCompound slotEntry = itemList.func_150305_b(i);
            int j = slotEntry.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.func_70302_i_()) continue;
            this.func_70299_a(j, ItemStack.func_77949_a((NBTTagCompound)slotEntry));
        }
        this.reading = false;
    }

    protected void writeToNBT() {
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null) continue;
            NBTTagCompound slotEntry = new NBTTagCompound();
            slotEntry.func_74774_a("Slot", (byte)i);
            this.func_70301_a(i).func_77955_b(slotEntry);
            itemList.func_74742_a((NBTBase)slotEntry);
        }
        NBTTagCompound inventory = new NBTTagCompound();
        inventory.func_74782_a("Items", (NBTBase)itemList);
        inventory.func_74778_a("UniqueID", this.uniqueID);
        NBTHelper.setCompoundTag(packag3, "Package", inventory);
    }
}

