/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.ichunutil.common.core.packet.mod;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ichun.common.core.CommonProxy;
import ichun.common.core.network.AbstractPacket;
import ichun.common.core.network.PacketHandler;
import ichun.common.iChunUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import us.ichun.mods.ichunutil.client.thread.ThreadStatistics;

public class PacketPatientData
extends AbstractPacket {
    public int level;
    public boolean mutate;
    public String infector;

    public PacketPatientData() {
    }

    public PacketPatientData(int i, boolean isMutation, String inf) {
        this.level = i;
        this.mutate = isMutation;
        this.infector = inf;
    }

    @Override
    public void writeTo(ByteBuf buffer, Side side) {
        buffer.writeInt(this.level);
        buffer.writeBoolean(this.mutate);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.infector);
    }

    @Override
    public void readFrom(ByteBuf buffer, Side side) {
        this.level = buffer.readInt();
        this.mutate = buffer.readBoolean();
        this.infector = ByteBufUtils.readUTF8String((ByteBuf)buffer);
    }

    @Override
    public void execute(Side side, EntityPlayer player) {
        if (side.isServer()) {
            CommonProxy.tickHandlerServer.infectionMap.put(player.func_146103_bH().getId().toString(), this.level);
        } else {
            this.handleClient();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClient() {
        if (ThreadStatistics.stats.getInt("statsOptOut") != 1) {
            CommonProxy.tickHandlerClient.infectionTimeout = this.level == 0 ? 100 : 60;
            CommonProxy.tickHandlerClient.isFirstInfection = this.level == 0;
            int currentInfection = ThreadStatistics.getInfectionLevel(ThreadStatistics.stats.getString("statsData"));
            if (currentInfection < this.level) {
                if (currentInfection >= 0 && this.level != currentInfection + 1) {
                    PacketHandler.sendToServer(iChunUtil.channels, new PacketPatientData(currentInfection, false, ""));
                } else {
                    ThreadStatistics.stats.get("statsData").set(ThreadStatistics.getInfectionHash(this.level));
                    ThreadStatistics.stats.save();
                    if (!this.mutate) {
                        new ThreadStatistics(2, this.level, this.infector).start();
                    } else {
                        new ThreadStatistics(3, this.level).start();
                    }
                }
            }
        }
    }
}

