/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage.items;

import forestry.api.apiculture.BeeManager;
import forestry.api.core.ForestryAPI;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.storage.EnumBackpackType;
import forestry.api.storage.IBackpackDefinition;
import forestry.storage.BackpackDefinition;
import forestry.storage.items.ItemBackpack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ItemNaturalistBackpack
extends ItemBackpack {
    private final int guiId;

    public ItemNaturalistBackpack(int guiId, IBackpackDefinition definition) {
        super(definition, EnumBackpackType.APIARIST);
        this.guiId = guiId;
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, this.guiId, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
    }

    public static class BackpackDefinitionLepidopterist
    extends BackpackDefinition {
        public BackpackDefinitionLepidopterist(int primaryColor) {
            super("lepidopterist", primaryColor);
        }

        @Override
        public boolean isValidItem(ItemStack itemStack) {
            return ButterflyManager.butterflyRoot.isMember(itemStack);
        }
    }

    public static class BackpackDefinitionApiarist
    extends BackpackDefinition {
        public BackpackDefinitionApiarist(int primaryColor) {
            super("apiarist", primaryColor);
        }

        @Override
        public boolean isValidItem(ItemStack itemStack) {
            return BeeManager.beeRoot.isMember(itemStack);
        }
    }
}

