/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.items;

import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorSource;
import forestry.api.core.IErrorState;
import forestry.api.mail.ILetter;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.errors.EnumErrorCode;
import forestry.core.gui.IHintSource;
import forestry.core.inventory.ItemInventory;
import forestry.core.items.ItemInventoried;
import forestry.core.network.GuiId;
import forestry.core.render.TextureManager;
import forestry.core.utils.SlotUtil;
import forestry.core.utils.StringUtil;
import forestry.mail.Letter;
import forestry.mail.items.ItemStamps;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemLetter
extends ItemInventoried {
    @SideOnly(value=Side.CLIENT)
    private IIcon[][] icons;

    public static ItemStack createStampedLetterStack(ILetter letter) {
        LetterSize size = ItemLetter.getSize(letter);
        int meta = ItemLetter.encodeMeta(LetterState.STAMPED, size);
        return ForestryItem.letters.getItemStack(1, meta);
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (!world.field_72995_K) {
            if (itemstack.field_77994_a == 1) {
                entityplayer.openGui(ForestryAPI.instance, GuiId.LetterGUI.ordinal(), world, (int)entityplayer.field_70165_t, (int)entityplayer.field_70163_u, (int)entityplayer.field_70161_v);
            } else {
                entityplayer.func_145747_a((IChatComponent)new ChatComponentTranslation("for.chat.mail.wrongstacksize", new Object[0]));
            }
        }
        return itemstack;
    }

    public boolean func_77651_p() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.icons = new IIcon[3][4];
        for (int i = 0; i < 3; ++i) {
            this.icons[i][0] = TextureManager.registerTex(register, "mail/letter." + i + ".fresh");
            this.icons[i][1] = TextureManager.registerTex(register, "mail/letter." + i + ".stamped");
            this.icons[i][2] = TextureManager.registerTex(register, "mail/letter." + i + ".opened");
            this.icons[i][3] = TextureManager.registerTex(register, "mail/letter." + i + ".emptied");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        LetterState state = ItemLetter.getState(damage);
        LetterSize size = ItemLetter.getSize(damage);
        return this.icons[size.ordinal()][state.ordinal()];
    }

    private static int encodeMeta(LetterState state, LetterSize size) {
        int meta = size.ordinal() << 4;
        return meta |= state.ordinal();
    }

    private static LetterState getState(int meta) {
        int ordinal = meta & 0xF;
        LetterState[] values = LetterState.values();
        if (ordinal >= values.length) {
            ordinal = 0;
        }
        return values[ordinal];
    }

    private static LetterSize getSize(int meta) {
        int ordinal = meta >> 4;
        LetterSize[] values = LetterSize.values();
        if (ordinal >= values.length) {
            ordinal = 0;
        }
        return values[ordinal];
    }

    private static LetterSize getSize(ILetter letter) {
        int count = letter.countAttachments();
        if (count > 5) {
            return LetterSize.BIG;
        }
        if (count > 1) {
            return LetterSize.SMALL;
        }
        return LetterSize.EMPTY;
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean flag) {
        NBTTagCompound nbttagcompound = itemstack.func_77978_p();
        if (nbttagcompound == null) {
            list.add('<' + StringUtil.localize("gui.blank") + '>');
            return;
        }
        Letter letter = new Letter(nbttagcompound);
        letter.addTooltip(list);
    }

    public static class LetterInventory
    extends ItemInventory
    implements IErrorSource,
    IHintSource {
        private ILetter letter;

        public LetterInventory(EntityPlayer player, ItemStack itemstack) {
            super(player, 0, itemstack);
        }

        public ILetter getLetter() {
            return this.letter;
        }

        public void onContainerClosed() {
            ItemStack parent = this.getParent();
            if (parent == null) {
                return;
            }
            LetterState state = ItemLetter.getState(parent.func_77960_j());
            LetterSize size = ItemLetter.getSize(parent.func_77960_j());
            switch (state) {
                case OPENED: {
                    if (this.letter.countAttachments() > 0) break;
                    state = LetterState.EMPTIED;
                    break;
                }
                case FRESH: 
                case STAMPED: {
                    state = this.letter.isMailable() && this.letter.isPostPaid() ? LetterState.STAMPED : LetterState.FRESH;
                    size = ItemLetter.getSize(this.letter);
                    break;
                }
            }
            int meta = ItemLetter.encodeMeta(state, size);
            parent.func_77964_b(meta);
            this.letter.writeToNBT(parent.func_77978_p());
        }

        public void onLetterOpened() {
            int oldMeta;
            LetterState state;
            ItemStack parent = this.getParent();
            if (parent != null && ((state = ItemLetter.getState(oldMeta = parent.func_77960_j())) == LetterState.FRESH || state == LetterState.STAMPED)) {
                LetterSize size = ItemLetter.getSize(oldMeta);
                int newMeta = ItemLetter.encodeMeta(LetterState.OPENED, size);
                parent.func_77964_b(newMeta);
            }
        }

        @Override
        public void readFromNBT(NBTTagCompound nbttagcompound) {
            if (nbttagcompound == null) {
                return;
            }
            this.letter = new Letter(nbttagcompound);
        }

        @Override
        public ItemStack func_70298_a(int i, int j) {
            ItemStack result = this.letter.func_70298_a(i, j);
            this.letter.writeToNBT(this.getParent().func_77978_p());
            return result;
        }

        @Override
        public void func_70299_a(int i, ItemStack itemstack) {
            this.letter.func_70299_a(i, itemstack);
            this.letter.writeToNBT(this.getParent().func_77978_p());
        }

        @Override
        public ItemStack func_70301_a(int i) {
            return this.letter.func_70301_a(i);
        }

        @Override
        public int func_70302_i_() {
            return this.letter.func_70302_i_();
        }

        @Override
        public String func_145825_b() {
            return this.letter.func_145825_b();
        }

        @Override
        public int func_70297_j_() {
            return this.letter.func_70297_j_();
        }

        @Override
        public boolean func_70300_a(EntityPlayer entityplayer) {
            return this.letter.func_70300_a(entityplayer);
        }

        @Override
        public ItemStack func_70304_b(int slot) {
            return this.letter.func_70304_b(slot);
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (this.letter.isProcessed()) {
                return false;
            }
            if (SlotUtil.isSlotInRange(slotIndex, 18, 4)) {
                Item item = itemStack.func_77973_b();
                return item instanceof ItemStamps;
            }
            if (SlotUtil.isSlotInRange(slotIndex, 0, 18)) {
                return !ForestryItem.letters.isItemEqual(itemStack);
            }
            return false;
        }

        @Override
        public ImmutableSet<IErrorState> getErrorStates() {
            ImmutableSet.Builder errorStates = ImmutableSet.builder();
            if (!this.letter.hasRecipient()) {
                errorStates.add((Object)EnumErrorCode.NORECIPIENT);
            }
            if (!this.letter.isProcessed() && !this.letter.isPostPaid()) {
                errorStates.add((Object)EnumErrorCode.NOTPOSTPAID);
            }
            return errorStates.build();
        }

        @Override
        public boolean hasHints() {
            return Config.hints.get("letter") != null && Config.hints.get("letter").length > 0;
        }

        @Override
        public String[] getHints() {
            return Config.hints.get("letter");
        }
    }

    private static enum LetterSize {
        EMPTY,
        SMALL,
        BIG;

    }

    private static enum LetterState {
        FRESH,
        STAMPED,
        OPENED,
        EMPTIED;

    }
}

