/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.render;

import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.IButterfly;
import forestry.core.proxy.Proxies;
import forestry.lepidopterology.entities.EntityButterfly;
import forestry.lepidopterology.render.ModelButterfly;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderButterflyItem
implements IItemRenderer {
    private final ModelButterfly model = new ModelButterfly();
    private EntityButterfly entity;

    private static float getWingYaw(IButterfly butterfly) {
        float wingYaw = 1.0f;
        if (butterfly.isAlive()) {
            long systemTime = System.currentTimeMillis();
            long flapping = systemTime + (long)butterfly.getIdent().hashCode();
            float flap = (float)(flapping % 1024L) / 1024.0f;
            wingYaw = RenderButterflyItem.getIrregularWingYaw(flapping, flap);
        }
        return wingYaw;
    }

    public static float getIrregularWingYaw(long flapping, float flap) {
        float wingYaw;
        long irregular = flapping / 1024L;
        if (irregular % 11L == 0L) {
            wingYaw = 0.75f;
        } else {
            if (irregular % 7L == 0L) {
                flap *= 4.0f;
                flap %= 1.0f;
            } else if (irregular % 19L == 0L) {
                flap *= 6.0f;
                flap %= 1.0f;
            }
            wingYaw = RenderButterflyItem.getRegularWingYaw(flap);
        }
        return wingYaw;
    }

    private static float getRegularWingYaw(float flap) {
        return (double)flap < 0.5 ? 0.75f + flap : 1.75f - flap;
    }

    private IButterfly initButterfly(ItemStack item, boolean scaled) {
        IButterfly butterfly = ButterflyManager.butterflyRoot.getMember(item);
        if (butterfly == null) {
            butterfly = ButterflyManager.butterflyRoot.templateAsIndividual(ButterflyManager.butterflyRoot.getDefaultTemplate());
        }
        if (this.entity == null) {
            this.entity = new EntityButterfly((World)Proxies.common.getClientInstance().field_71441_e);
        }
        this.entity.setSpecies(butterfly.getGenome().getPrimary());
        if (scaled) {
            this.entity.setScale(butterfly.getSize());
        } else {
            this.entity.setScale(0.75f);
        }
        return butterfly;
    }

    private void renderButterflyItem(IButterfly butterfly, float translateX, float translateY, float translateZ) {
        float yaw = 1.0f;
        float pitch = 1.0f;
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2903);
        GL11.glPushMatrix();
        if (RenderItem.field_82407_g) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)1.1f, (float)1.0f, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)-0.7f, (float)0.2f);
            this.entity.field_70761_aq = 0.0f;
            this.entity.field_70177_z = 0.0f;
            this.entity.field_70125_A = 0.0f;
            this.entity.field_70759_as = this.entity.field_70177_z;
            RenderManager.field_78727_a.func_147940_a((Entity)this.entity, 0.0, 0.0, 0.0, 0.0f, 1.0f);
        } else {
            GL11.glTranslatef((float)translateX, (float)translateY, (float)translateZ);
            GL11.glScalef((float)-2.0f, (float)2.0f, (float)2.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glRotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-((float)Math.atan(pitch / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            this.entity.field_70761_aq = (float)Math.atan(yaw / 40.0f) * 20.0f;
            this.entity.field_70177_z = (float)Math.atan(yaw / 40.0f) * 40.0f;
            this.entity.field_70125_A = -((float)Math.atan(pitch / 40.0f)) * 20.0f;
            this.entity.field_70759_as = this.entity.field_70177_z;
            RenderManager.field_78727_a.func_147940_a((Entity)this.entity, 0.0, 0.0, 0.0, 0.0f, RenderButterflyItem.getWingYaw(butterfly));
        }
        GL11.glPopMatrix();
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
        GL11.glPopAttrib();
    }

    private void renderButterflyInInventory(IButterfly butterfly) {
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2903);
        RenderHelper.func_74519_b();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)-0.75f, (float)0.0f);
        GL11.glScalef((float)-2.0f, (float)2.0f, (float)2.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glRotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)-35.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)1.1f, (float)1.0f, (float)1.0f);
        this.entity.field_70761_aq = 0.0f;
        this.entity.field_70177_z = 0.0f;
        this.entity.field_70125_A = 0.0f;
        this.entity.field_70759_as = this.entity.field_70177_z;
        RenderManager.field_78727_a.func_147940_a((Entity)this.entity, 0.0, 0.0, 0.0, 0.0f, RenderButterflyItem.getWingYaw(butterfly));
        GL11.glPopMatrix();
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
        GL11.glPopAttrib();
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: 
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: 
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        switch (helper) {
            case ENTITY_BOBBING: 
            case ENTITY_ROTATION: {
                return false;
            }
        }
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case ENTITY: {
                this.renderButterflyItem(this.initButterfly(item, true), 0.0f, -1.0f, 0.0f);
                break;
            }
            case EQUIPPED: {
                this.renderButterflyItem(this.initButterfly(item, true), 0.5f, -0.9f, 1.0f);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.renderButterflyItem(this.initButterfly(item, true), 0.5f, -0.9f, 1.0f);
                break;
            }
            case INVENTORY: {
                this.renderButterflyInInventory(this.initButterfly(item, false));
                break;
            }
        }
    }
}

