/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.entities;

import forestry.lepidopterology.entities.AIButterflyBase;
import forestry.lepidopterology.entities.EntityButterfly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockWall;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IPlantable;

public class AIButterflyRest
extends AIButterflyBase {
    public AIButterflyRest(EntityButterfly entity) {
        super(entity);
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        int z;
        if (this.entity.getExhaustion() < 1000 && this.entity.canFly()) {
            return false;
        }
        int x = (int)this.entity.field_70165_t;
        int y = (int)Math.floor(this.entity.field_70163_u);
        if (!this.canLand(x, y, z = (int)this.entity.field_70161_v)) {
            return false;
        }
        if (this.entity.field_70170_p.func_147437_c(x, --y, z)) {
            return false;
        }
        if (this.entity.field_70170_p.func_147439_a(x, y, z).func_149688_o().func_76224_d()) {
            return false;
        }
        if (!this.entity.getButterfly().isAcceptedEnvironment(this.entity.field_70170_p, x, y, z)) {
            return false;
        }
        this.entity.setDestination(null);
        this.entity.setState(EntityButterfly.EnumButterflyState.RESTING);
        return true;
    }

    public boolean func_75253_b() {
        if (this.entity.getExhaustion() <= 0 && this.entity.canFly()) {
            return false;
        }
        return !this.entity.func_70090_H();
    }

    public void func_75249_e() {
    }

    public void func_75251_c() {
    }

    public void func_75246_d() {
        this.entity.changeExhaustion(-1);
    }

    private boolean canLand(int x, int y, int z) {
        Block block = this.entity.field_70170_p.func_147439_a(x, y, z);
        if (!block.func_149655_b((IBlockAccess)this.entity.field_70170_p, x, y, z)) {
            return false;
        }
        if (AIButterflyRest.isPlant(block)) {
            return true;
        }
        block = this.entity.field_70170_p.func_147439_a(x, y - 1, z);
        return AIButterflyRest.isRest(block) || block.isLeaves((IBlockAccess)this.entity.field_70170_p, x, y - 1, z);
    }

    private static boolean isRest(Block block) {
        if (block instanceof BlockFence) {
            return true;
        }
        return block instanceof BlockWall;
    }

    private static boolean isPlant(Block block) {
        if (block instanceof BlockFlower) {
            return true;
        }
        if (block instanceof IPlantable) {
            return true;
        }
        if (block instanceof IGrowable) {
            return true;
        }
        return block.func_149688_o() == Material.field_151585_k;
    }
}

