/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.api.recipes.ICarpenterRecipe;
import forestry.core.config.Config;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.render.TankRenderInfo;
import forestry.core.tiles.IItemStackDisplay;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.PlayerUtil;
import forestry.core.utils.SlotUtil;
import forestry.factory.recipes.CarpenterRecipeManager;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileCarpenter
extends TilePowered
implements ISidedInventory,
ILiquidTankTile,
IFluidHandler,
IItemStackDisplay {
    private static final int TICKS_PER_RECIPE_TIME = 1;
    private static final int ENERGY_PER_WORK_CYCLE = 2040;
    private static final int ENERGY_PER_RECIPE_TIME = 204;
    public static final int SLOT_CRAFTING_1 = 0;
    public static final int SLOT_CRAFTING_COUNT = 9;
    public static final int SLOT_BOX = 9;
    public static final int SLOT_PRODUCT = 10;
    public static final int SLOT_PRODUCT_COUNT = 1;
    public static final int SLOT_CAN_INPUT = 11;
    public static final short SLOT_INVENTORY_1 = 12;
    public static final short SLOT_INVENTORY_COUNT = 18;
    private final FilteredTank resourceTank;
    private final TankManager tankManager;
    private final TileInventoryAdapter craftingInventory;
    private final InventoryCraftResult craftPreviewInventory;
    @Nullable
    private ICarpenterRecipe currentRecipe;

    private ItemStack getBoxStack() {
        return this.getInternalInventory().func_70301_a(9);
    }

    public TileCarpenter() {
        super(1100, 4000, 2040);
        this.setHints(Config.hints.get("carpenter"));
        this.resourceTank = new FilteredTank(10000, CarpenterRecipeManager.recipeFluids);
        this.craftingInventory = new TileInventoryAdapter<TileCarpenter>(this, 10, "CraftItems");
        this.craftPreviewInventory = new InventoryCraftResult();
        this.setInternalInventory(new CarpenterInventoryAdapter(this));
        this.tankManager = new TankManager(this, this.resourceTank);
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, GuiId.CarpenterGUI.ordinal(), player.field_70170_p, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        this.tankManager.writeToNBT(nbttagcompound);
        this.craftingInventory.writeToNBT(nbttagcompound);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.tankManager.readFromNBT(nbttagcompound);
        this.craftingInventory.readFromNBT(nbttagcompound);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.tankManager.writeData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readData(data);
    }

    public void checkRecipe() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!CarpenterRecipeManager.matches(this.currentRecipe, this.resourceTank.getFluid(), this.getBoxStack(), (IInventory)this.craftingInventory)) {
            this.currentRecipe = CarpenterRecipeManager.findMatchingRecipe(this.resourceTank.getFluid(), this.getBoxStack(), (IInventory)this.craftingInventory);
            if (this.currentRecipe != null) {
                int recipeTime = this.currentRecipe.getPackagingTime();
                this.setTicksPerWorkCycle(recipeTime * 1);
                this.setEnergyPerWorkCycle(recipeTime * 204);
                ItemStack craftingResult = this.currentRecipe.getCraftingGridRecipe().func_77571_b();
                this.craftPreviewInventory.func_70299_a(0, craftingResult);
            } else {
                this.craftPreviewInventory.func_70299_a(0, null);
            }
        }
    }

    @Override
    public void updateServerSide() {
        super.updateServerSide();
        if (this.updateOnInterval(20)) {
            FluidHelper.drainContainers(this.tankManager, (IInventory)this, 11);
        }
    }

    @Override
    public boolean workCycle() {
        if (!this.removeResources(true)) {
            return false;
        }
        ItemStack pendingProduct = this.currentRecipe.getCraftingGridRecipe().func_77571_b();
        InventoryUtil.tryAddStack((IInventory)this, pendingProduct, 10, 1, true);
        return true;
    }

    private boolean removeResources(boolean doRemove) {
        if (this.currentRecipe == null) {
            return true;
        }
        FluidStack fluid = this.currentRecipe.getFluidResource();
        if (fluid != null) {
            if (!this.resourceTank.canDrain(fluid)) {
                return false;
            }
            if (doRemove) {
                this.resourceTank.drain(fluid.amount, true);
            }
        }
        if (this.currentRecipe.getBox() != null) {
            ItemStack box = this.func_70301_a(9);
            if (box == null || box.field_77994_a == 0) {
                return false;
            }
            if (doRemove) {
                this.func_70298_a(9, 1);
            }
        }
        EntityPlayer player = PlayerUtil.getPlayer(this.field_145850_b, this.getAccessHandler().getOwner());
        ItemStack[] craftingSets = InventoryUtil.getStacks((IInventory)this.craftingInventory, 0, 9);
        InventoryMapper inventory = new InventoryMapper((IInventory)this.getInternalInventory(), 12, 18);
        return InventoryUtil.removeSets(inventory, 1, craftingSets, player, true, true, false, doRemove);
    }

    @Override
    public boolean hasWork() {
        if (this.updateOnInterval(20)) {
            this.checkRecipe();
        }
        boolean hasRecipe = this.currentRecipe != null;
        boolean hasResources = true;
        boolean canAdd = true;
        if (hasRecipe) {
            hasResources = this.removeResources(false);
            ItemStack pendingProduct = this.currentRecipe.getCraftingGridRecipe().func_77571_b();
            canAdd = InventoryUtil.tryAddStack((IInventory)this, pendingProduct, 10, 1, true, false);
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.setCondition(!hasRecipe, EnumErrorCode.NORECIPE);
        errorLogic.setCondition(!hasResources, EnumErrorCode.NORESOURCE);
        errorLogic.setCondition(!canAdd, EnumErrorCode.NOSPACE);
        return hasRecipe && hasResources && canAdd;
    }

    @Override
    public TankRenderInfo getResourceTankInfo() {
        return new TankRenderInfo((IFluidTank)this.resourceTank);
    }

    public IInventory getCraftingInventory() {
        return this.craftingInventory;
    }

    public IInventory getCraftPreviewInventory() {
        return this.craftPreviewInventory;
    }

    @Override
    public void handleItemStackForDisplay(ItemStack itemStack) {
        this.craftPreviewInventory.func_70299_a(0, itemStack);
    }

    public int fill(ForgeDirection direction, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(direction, resource, doFill);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tankManager.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.tankManager.getTankInfo(from);
    }

    private static class CarpenterInventoryAdapter
    extends TileInventoryAdapter<TileCarpenter> {
        public CarpenterInventoryAdapter(TileCarpenter carpenter) {
            super(carpenter, 30, "Items");
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (slotIndex == 11) {
                Fluid fluid = FluidHelper.getFluidInContainer(itemStack);
                return ((TileCarpenter)this.tile).tankManager.accepts(fluid);
            }
            if (slotIndex == 9) {
                return CarpenterRecipeManager.isBox(itemStack);
            }
            if (this.canSlotAccept(11, itemStack) || this.canSlotAccept(9, itemStack)) {
                return false;
            }
            return SlotUtil.isSlotInRange(slotIndex, 12, 18);
        }

        @Override
        public boolean func_102008_b(int slotIndex, ItemStack itemstack, int side) {
            return slotIndex == 10;
        }
    }
}

