/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import forestry.api.recipes.ISqueezerManager;
import forestry.api.recipes.ISqueezerRecipe;
import forestry.core.fluids.FluidHelper;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.datastructures.ItemStackMap;
import forestry.factory.recipes.ISqueezerContainerRecipe;
import forestry.factory.recipes.SqueezerContainerRecipe;
import forestry.factory.recipes.SqueezerRecipe;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class SqueezerRecipeManager
implements ISqueezerManager {
    private static final Set<ISqueezerRecipe> recipes = new HashSet<ISqueezerRecipe>();
    public static final ItemStackMap<ISqueezerContainerRecipe> containerRecipes = new ItemStackMap();

    @Override
    public void addRecipe(int timePerItem, ItemStack[] resources, FluidStack liquid, @Nullable ItemStack remnants, int chance) {
        SqueezerRecipe recipe = new SqueezerRecipe(timePerItem, resources, liquid, remnants, (float)chance / 100.0f);
        this.addRecipe(recipe);
    }

    @Override
    public void addRecipe(int timePerItem, ItemStack[] resources, FluidStack liquid) {
        this.addRecipe(timePerItem, resources, liquid, null, 0);
    }

    @Override
    public void addContainerRecipe(int timePerItem, ItemStack emptyContainer, @Nullable ItemStack remnants, float chance) {
        containerRecipes.put(emptyContainer, new SqueezerContainerRecipe(emptyContainer, timePerItem, remnants, chance));
    }

    @Nullable
    public static ISqueezerContainerRecipe findMatchingContainerRecipe(ItemStack filledContainer) {
        ItemStack emptyContainer = FluidHelper.getEmptyContainer(filledContainer);
        if (emptyContainer == null) {
            return null;
        }
        return (ISqueezerContainerRecipe)containerRecipes.get(emptyContainer);
    }

    public static ISqueezerRecipe findMatchingRecipe(ItemStack[] items) {
        for (ItemStack itemStack : items) {
            ISqueezerRecipe recipe;
            ISqueezerContainerRecipe containerRecipe = SqueezerRecipeManager.findMatchingContainerRecipe(itemStack);
            if (containerRecipe == null || (recipe = containerRecipe.getSqueezerRecipe(itemStack)) == null) continue;
            return recipe;
        }
        for (ISqueezerRecipe recipe : recipes) {
            if (ItemStackUtil.containsSets(recipe.getResources(), items, false, false) <= 0) continue;
            return recipe;
        }
        for (ISqueezerRecipe recipe : recipes) {
            if (ItemStackUtil.containsSets(recipe.getResources(), items, true, false) <= 0) continue;
            return recipe;
        }
        return null;
    }

    public static boolean canUse(ItemStack itemStack) {
        for (ISqueezerRecipe recipe : recipes) {
            for (ItemStack recipeInput : recipe.getResources()) {
                if (!ItemStackUtil.isCraftingEquivalent(recipeInput, itemStack, true, false)) continue;
                return true;
            }
        }
        return SqueezerRecipeManager.findMatchingContainerRecipe(itemStack) != null;
    }

    @Override
    public boolean addRecipe(ISqueezerRecipe recipe) {
        return recipes.add(recipe);
    }

    @Override
    public boolean removeRecipe(ISqueezerRecipe recipe) {
        return recipes.remove(recipe);
    }

    @Override
    public Set<ISqueezerRecipe> recipes() {
        return Collections.unmodifiableSet(recipes);
    }

    @Override
    public Map<Object[], Object[]> getRecipes() {
        HashMap<Object[], Object[]> recipeList = new HashMap<Object[], Object[]>();
        for (ISqueezerRecipe recipe : recipes) {
            recipeList.put(recipe.getResources(), new Object[]{recipe.getRemnants(), recipe.getFluidOutput()});
        }
        return recipeList;
    }
}

