/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gui;

import forestry.core.gui.ContainerTile;
import forestry.core.gui.IContainerCrafting;
import forestry.core.gui.IGuiSelectable;
import forestry.core.gui.slots.SlotCraftMatrix;
import forestry.core.gui.slots.SlotCrafter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.network.PacketGuiSelectRequest;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ItemStackUtil;
import forestry.factory.network.PacketWorktableMemoryUpdate;
import forestry.factory.tiles.TileWorktable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerWorktable
extends ContainerTile<TileWorktable>
implements IContainerCrafting,
IGuiSelectable {
    private final InventoryCrafting craftMatrix = new InventoryCrafting((Container)this, 3, 3);
    private long lastUpdate;

    public ContainerWorktable(EntityPlayer player, TileWorktable tile) {
        super(tile, player.field_71071_by, 8, 136);
        IInventory craftingInventory = tile.getCraftingInventory();
        IInventoryAdapter internalInventory = tile.getInternalInventory();
        for (int i = 0; i < 2; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.func_75146_a(new Slot((IInventory)internalInventory, 0 + k + i * 9, 8 + k * 18, 90 + i * 18));
            }
        }
        for (int l = 0; l < 3; ++l) {
            for (int k1 = 0; k1 < 3; ++k1) {
                this.func_75146_a(new SlotCraftMatrix(this, craftingInventory, k1 + l * 3, 11 + k1 * 18, 20 + l * 18));
            }
        }
        this.func_75146_a((Slot)new SlotCrafter(player, craftingInventory, tile, 9, 77, 38));
        this.updateMatrix();
        this.updateRecipe();
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        if (this.lastUpdate == ((TileWorktable)this.tile).getMemory().getLastUpdate()) {
            return;
        }
        this.lastUpdate = ((TileWorktable)this.tile).getMemory().getLastUpdate();
        PacketWorktableMemoryUpdate packet = new PacketWorktableMemoryUpdate((TileWorktable)this.tile);
        this.sendPacketToCrafters(packet);
    }

    @Override
    public void onCraftMatrixChanged(IInventory iinventory, int slot) {
        ItemStack currentStack;
        if (slot >= this.craftMatrix.func_70302_i_()) {
            return;
        }
        ItemStack stack = iinventory.func_70301_a(slot);
        if (!ItemStackUtil.isIdenticalItem(stack, currentStack = this.craftMatrix.func_70301_a(slot))) {
            this.craftMatrix.func_70299_a(slot, stack);
            this.updateRecipe();
        }
    }

    private void updateMatrix() {
        for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
            this.craftMatrix.func_70299_a(i, ((TileWorktable)this.tile).getCraftingInventory().func_70301_a(i));
        }
    }

    private void updateRecipe() {
        ((TileWorktable)this.tile).setRecipe(this.craftMatrix);
    }

    public static void clearRecipe() {
        ContainerWorktable.sendRecipeClick(0, 9);
    }

    public static void sendRecipeClick(int mouseButton, int recipeIndex) {
        Proxies.net.sendToServer(new PacketGuiSelectRequest(mouseButton, recipeIndex));
    }

    @Override
    public void handleSelectionRequest(EntityPlayerMP player, PacketGuiSelectRequest packet) {
        if (packet.getPrimaryIndex() > 0) {
            ((TileWorktable)this.tile).getMemory().toggleLock(player.field_70170_p, packet.getSecondaryIndex());
        } else {
            ((TileWorktable)this.tile).chooseRecipe(packet.getSecondaryIndex());
            this.updateMatrix();
            this.updateRecipe();
        }
    }
}

