/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ICrashCallable;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.Side;
import forestry.plugins.PluginManager;
import java.util.ArrayList;
import java.util.List;

public class ForestryModEnvWarningCallable
implements ICrashCallable {
    private final List<String> modIDs = new ArrayList<String>();
    private final List<String> disabledModules;

    public static void register() {
        ForestryModEnvWarningCallable callable = new ForestryModEnvWarningCallable();
        if (callable.modIDs.size() > 0 || callable.disabledModules.size() > 0) {
            FMLCommonHandler.instance().registerCrashCallable((ICrashCallable)callable);
        }
    }

    private ForestryModEnvWarningCallable() {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT && FMLClientHandler.instance().hasOptifine()) {
            this.modIDs.add("Optifine");
        }
        if (Loader.isModLoaded((String)"gregtech_addon")) {
            this.modIDs.add("GregTech");
        }
        try {
            Class<?> c = Class.forName("org.bukkit.Bukkit");
            if (c != null) {
                this.modIDs.add("Bukkit, Cauldron, or other Bukkit replacement");
            }
        }
        catch (Throwable c) {
            // empty catch block
        }
        this.disabledModules = new ArrayList<String>();
        for (PluginManager.Module module : PluginManager.configDisabledModules) {
            this.disabledModules.add(module.configName());
        }
    }

    public String call() throws Exception {
        int i;
        StringBuilder message = new StringBuilder();
        if (this.modIDs.size() > 0) {
            message.append("Warning: You have mods that change the behavior of Minecraft, ForgeModLoader, and/or Minecraft Forge to your client: \r\n");
            message.append(this.modIDs.get(0));
            for (i = 1; i < this.modIDs.size(); ++i) {
                message.append(", ").append(this.modIDs.get(i));
            }
            message.append("\r\nThese may have caused this error, and may not be supported. Try reproducing the crash WITHOUT these mods, and report it then.");
        }
        if (this.disabledModules.size() > 0) {
            if (message.length() > 0) {
                message.append("\r\n");
            }
            message.append("Info: The following plugins have been disabled in the config: ");
            message.append(this.disabledModules.get(0));
            for (i = 1; i < this.disabledModules.size(); ++i) {
                message.append(", ").append(this.disabledModules.get(i));
            }
        }
        return message.toString();
    }

    public String getLabel() {
        return "Forestry ";
    }
}

