/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.recipes.nei;

import codechicken.nei.LayoutManager;
import codechicken.nei.OffsetPositioner;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.DefaultOverlayRenderer;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IStackPositioner;
import codechicken.nei.recipe.IRecipeHandler;
import forestry.core.proxy.Proxies;
import forestry.core.recipes.nei.PacketWorktableNEISelect;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class CustomOverlayHandler
implements IOverlayHandler {
    private final int xOffs;
    private final int yOffs;
    private final boolean forceShift;

    public CustomOverlayHandler(int xOffs, int yOffs, boolean forceShift) {
        this.xOffs = xOffs;
        this.yOffs = yOffs;
        this.forceShift = forceShift;
    }

    public void overlayRecipe(GuiContainer cont, IRecipeHandler recipe, int recipeIndex, boolean shift) {
        List ingr = recipe.getIngredientStacks(recipeIndex);
        if (shift || this.forceShift) {
            NBTTagList stacksnbt = new NBTTagList();
            for (PositionedStack pstack : ingr) {
                if (pstack != null) {
                    int x = (pstack.relx - 25) / 18;
                    int y = (pstack.rely - 6) / 18;
                    ItemStack stack = pstack.item;
                    NBTTagCompound stacknbt = stack.func_77955_b(new NBTTagCompound());
                    stacknbt.func_74768_a("slot", y * 3 + x);
                    stacksnbt.func_74742_a((NBTBase)stacknbt);
                }
                ItemStack stack = recipe.getResultStack((int)recipeIndex).items[0];
                NBTTagCompound stacknbt = stack.func_77955_b(new NBTTagCompound());
                stacknbt.func_74768_a("slot", 9);
                stacksnbt.func_74742_a((NBTBase)stacknbt);
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74782_a("stacks", (NBTBase)stacksnbt);
            Proxies.net.sendToServer(new PacketWorktableNEISelect(data));
        } else {
            OffsetPositioner positioner = new OffsetPositioner(this.xOffs, this.yOffs);
            LayoutManager.overlayRenderer = new DefaultOverlayRenderer(ingr, (IStackPositioner)positioner);
        }
    }
}

