/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.recipes;

import forestry.core.recipes.RecipeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ShapelessRecipeCustom
implements IRecipe {
    private final List<ItemStack> ingredients;
    private final ItemStack product;
    private boolean preservesNbt = false;

    public static ShapelessRecipeCustom buildRecipe(ItemStack product, ItemStack ... ingredients) {
        ShapelessRecipeCustom recipe = new ShapelessRecipeCustom(product, ingredients);
        CraftingManager.func_77594_a().func_77592_b().add(recipe);
        return recipe;
    }

    public static ShapelessRecipeCustom buildPriorityRecipe(ItemStack product, ItemStack ... ingredients) {
        ShapelessRecipeCustom recipe = new ShapelessRecipeCustom(product, ingredients);
        CraftingManager.func_77594_a().func_77592_b().add(0, recipe);
        return recipe;
    }

    private ShapelessRecipeCustom(ItemStack product, ItemStack ... ingredients) {
        this.ingredients = Arrays.asList(ingredients);
        this.product = product;
    }

    public ShapelessRecipeCustom setPreserveNBT() {
        this.preservesNbt = true;
        return this;
    }

    public boolean preservesNbt() {
        return this.preservesNbt;
    }

    public boolean func_77569_a(InventoryCrafting inventoryCrafting, World world) {
        ArrayList<ItemStack> arraylist = new ArrayList<ItemStack>(this.ingredients);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                ItemStack itemstack = inventoryCrafting.func_70463_b(j, i);
                if (itemstack == null) continue;
                boolean flag = false;
                for (ItemStack itemstack1 : arraylist) {
                    if (itemstack.func_77973_b() != itemstack1.func_77973_b() || itemstack1.func_77960_j() != Short.MAX_VALUE && itemstack.func_77960_j() != itemstack1.func_77960_j()) continue;
                    flag = true;
                    arraylist.remove(itemstack1);
                    break;
                }
                if (flag) continue;
                return false;
            }
        }
        if (!arraylist.isEmpty()) {
            return false;
        }
        return !this.preservesNbt || RecipeUtil.getCraftingNbt((IInventory)inventoryCrafting) != null;
    }

    public ItemStack func_77572_b(InventoryCrafting inventoryCrafting) {
        ItemStack result = this.product.func_77946_l();
        if (this.preservesNbt) {
            NBTTagCompound craftingNbt = RecipeUtil.getCraftingNbt((IInventory)inventoryCrafting);
            if (craftingNbt == null) {
                return null;
            }
            result.func_77982_d(craftingNbt);
        }
        return result;
    }

    public int func_77570_a() {
        return this.ingredients.size();
    }

    public List<ItemStack> getIngredients() {
        return this.ingredients;
    }

    public ItemStack func_77571_b() {
        return this.product.func_77946_l();
    }
}

