/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.recipes;

import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.recipes.IDescriptiveRecipe;
import forestry.api.recipes.RecipeManagers;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.fluids.Fluids;
import forestry.core.gui.ContainerDummy;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public abstract class RecipeUtil {
    private static final Container DUMMY_CONTAINER = new ContainerDummy();

    public static void addFermenterRecipes(ItemStack resource, int fermentationValue, Fluids output) {
        if (RecipeManagers.fermenterManager == null) {
            return;
        }
        RecipeManagers.fermenterManager.addRecipe(resource, fermentationValue, 1.0f, output.getFluid(1), Fluids.WATER.getFluid(1));
        if (FluidRegistry.isFluidRegistered((Fluid)Fluids.JUICE.getFluid())) {
            RecipeManagers.fermenterManager.addRecipe(resource, fermentationValue, 1.5f, output.getFluid(1), Fluids.JUICE.getFluid(1));
        }
        if (FluidRegistry.isFluidRegistered((Fluid)Fluids.HONEY.getFluid())) {
            RecipeManagers.fermenterManager.addRecipe(resource, fermentationValue, 1.5f, output.getFluid(1), Fluids.HONEY.getFluid(1));
        }
    }

    public static List getOreDictRecipeEquivalents(ItemStack itemStack) {
        int[] oreDictIds = OreDictionary.getOreIDs((ItemStack)itemStack);
        ArrayList<String> oreDictNames = new ArrayList<String>(oreDictIds.length);
        for (int oreId : oreDictIds) {
            String oreDictName = OreDictionary.getOreName((int)oreId);
            oreDictNames.add(oreDictName);
        }
        if (oreDictNames.isEmpty()) {
            return Collections.singletonList(itemStack);
        }
        return oreDictNames;
    }

    public static NBTTagCompound getCraftingNbt(IInventory inventoryCrafting) {
        NBTTagCompound craftingNbt = null;
        for (int i = 0; i < inventoryCrafting.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inventoryCrafting.func_70301_a(i);
            if (stackInSlot == null || !stackInSlot.func_77942_o()) continue;
            NBTTagCompound tagCompound = stackInSlot.func_77978_p();
            if (craftingNbt != null && !craftingNbt.equals((Object)tagCompound)) {
                return null;
            }
            craftingNbt = tagCompound;
        }
        return craftingNbt;
    }

    public static Object[] getCraftingRecipeAsArray(IDescriptiveRecipe recipe) {
        try {
            return RecipeUtil.getShapedRecipeAsArray(recipe.getWidth(), recipe.getHeight(), recipe.getIngredients(), recipe.func_77571_b());
        }
        catch (Exception ex) {
            Log.warning("Exception while trying to parse an ItemStack[10] from an IRecipe:");
            Log.warning(ex.getMessage());
            return null;
        }
    }

    private static Object[] getShapedRecipeAsArray(int width, int height, Object[] ingredients, ItemStack output) {
        Object[] result = new Object[10];
        for (int y = 0; y < height; ++y) {
            System.arraycopy(ingredients, y * width, result, y * 3, width);
        }
        result[9] = output;
        return result;
    }

    public static boolean canCraftRecipe(World world, ItemStack[] recipeItems, ItemStack recipeOutput, ItemStack[] availableItems) {
        if (ItemStackUtil.containsSets(recipeItems, availableItems, true, true) == 0) {
            return false;
        }
        InventoryCrafting crafting = new InventoryCrafting(DUMMY_CONTAINER, 3, 3);
        ItemStack[] stockCopy = ItemStackUtil.condenseStacks(availableItems);
        block0: for (int slot = 0; slot < recipeItems.length; ++slot) {
            ItemStack stack;
            ItemStack recipeStack = recipeItems[slot];
            if (recipeStack == null) continue;
            for (ItemStack stockStack : stockCopy) {
                if (stockStack.field_77994_a <= 0 || !ItemStackUtil.isCraftingEquivalent(recipeStack, stockStack, false, false)) continue;
                stack = ItemStackUtil.createSplitStack(stockStack, 1);
                --stockStack.field_77994_a;
                crafting.func_70299_a(slot, stack);
                break;
            }
            if (crafting.func_70301_a(slot) != null) continue;
            for (ItemStack stockStack : stockCopy) {
                if (stockStack.field_77994_a <= 0 || !ItemStackUtil.isCraftingEquivalent(recipeStack, stockStack, true, true)) continue;
                stack = ItemStackUtil.createSplitStack(stockStack, 1);
                --stockStack.field_77994_a;
                crafting.func_70299_a(slot, stack);
                continue block0;
            }
        }
        ItemStack output = CraftingManager.func_77594_a().func_82787_a(crafting, world);
        return ItemStack.func_77989_b((ItemStack)output, (ItemStack)recipeOutput);
    }

    public static List<ItemStack> findMatchingRecipes(InventoryCrafting inventory, World world) {
        ItemStack repairRecipe = RecipeUtil.findRepairRecipe(inventory);
        if (repairRecipe != null) {
            return Collections.singletonList(repairRecipe);
        }
        ArrayList<ItemStack> matchingRecipes = new ArrayList<ItemStack>();
        for (Object recipe : CraftingManager.func_77594_a().func_77592_b()) {
            IRecipe irecipe = (IRecipe)recipe;
            if (!irecipe.func_77569_a(inventory, world)) continue;
            ItemStack result = irecipe.func_77572_b(inventory);
            matchingRecipes.add(result);
        }
        return matchingRecipes;
    }

    private static ItemStack findRepairRecipe(InventoryCrafting inventory) {
        int craftIngredientCount = 0;
        ItemStack itemstack0 = null;
        ItemStack itemstack1 = null;
        for (int j = 0; j < inventory.func_70302_i_(); ++j) {
            ItemStack itemstack = inventory.func_70301_a(j);
            if (itemstack == null) continue;
            if (craftIngredientCount == 0) {
                itemstack0 = itemstack;
            }
            if (craftIngredientCount == 1) {
                itemstack1 = itemstack;
            }
            ++craftIngredientCount;
        }
        if (craftIngredientCount == 2 && itemstack0.func_77973_b() == itemstack1.func_77973_b() && itemstack0.field_77994_a == 1 && itemstack1.field_77994_a == 1 && itemstack0.func_77973_b().isRepairable()) {
            Item item = itemstack0.func_77973_b();
            int damage0 = item.func_77612_l() - itemstack0.func_77952_i();
            int damage1 = item.func_77612_l() - itemstack1.func_77952_i();
            int repairAmount = damage0 + damage1 + item.func_77612_l() * 5 / 100;
            int repairedDamage = item.func_77612_l() - repairAmount;
            if (repairedDamage < 0) {
                repairedDamage = 0;
            }
            return new ItemStack(itemstack0.func_77973_b(), 1, repairedDamage);
        }
        return null;
    }

    private static void cleanRecipe(Object ... obj) {
        for (int i = 0; i < obj.length; ++i) {
            if (obj[i] instanceof ForestryItem) {
                obj[i] = ((ForestryItem)((Object)obj[i])).item();
                continue;
            }
            if (!(obj[i] instanceof ForestryBlock)) continue;
            obj[i] = ((ForestryBlock)((Object)obj[i])).block();
        }
    }

    public static void addRecipe(ItemStack itemstack, Object ... obj) {
        RecipeUtil.cleanRecipe(obj);
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(itemstack, obj));
    }

    public static void addShapelessRecipe(ItemStack itemstack, Object ... obj) {
        RecipeUtil.cleanRecipe(obj);
        CraftingManager.func_77594_a().func_77592_b().add(new ShapelessOreRecipe(itemstack, obj));
    }

    public static void addSmelting(ItemStack res, ItemStack prod, float xp) {
        if (res == null || res.func_77973_b() == null) {
            throw new IllegalArgumentException("Tried to register smelting recipe with null input");
        }
        if (prod == null || prod.func_77973_b() == null) {
            throw new IllegalArgumentException("Tried to register smelting recipe with null output");
        }
        GameRegistry.addSmelting((ItemStack)res, (ItemStack)prod, (float)xp);
    }

    public static ItemStack getCraftingResult(IDescriptiveRecipe recipe, IInventory inventoryCrafting) {
        return RecipeUtil.getCraftingResult(recipe.func_77571_b(), recipe.preserveNBT(), inventoryCrafting);
    }

    public static ItemStack getCraftingResult(ItemStack result, boolean preserveNBT, IInventory inventoryCrafting) {
        result = result.func_77946_l();
        if (preserveNBT) {
            NBTTagCompound craftingNbt = RecipeUtil.getCraftingNbt(inventoryCrafting);
            if (craftingNbt == null) {
                return null;
            }
            result.func_77982_d(craftingNbt);
        }
        return result;
    }

    public static boolean matches(IDescriptiveRecipe recipe, IInventory inventoryCrafting) {
        int height;
        int width;
        ItemStack[][] resources = RecipeUtil.getResources(inventoryCrafting);
        Object[] recipeIngredients = recipe.getIngredients();
        if (!RecipeUtil.matches(recipeIngredients, width = recipe.getWidth(), height = recipe.getHeight(), resources)) {
            return false;
        }
        return !recipe.preserveNBT() || RecipeUtil.getCraftingNbt(inventoryCrafting) != null;
    }

    private static ItemStack[][] getResources(IInventory inventoryCrafting) {
        ItemStack[][] resources = new ItemStack[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int k = i + j * 3;
                resources[i][j] = inventoryCrafting.func_70301_a(k);
            }
        }
        return resources;
    }

    public static boolean matches(Object[] recipeIngredients, int width, int height, ItemStack[][] resources) {
        for (int i = 0; i <= 3 - width; ++i) {
            for (int j = 0; j <= 3 - height; ++j) {
                if (RecipeUtil.checkMatch(recipeIngredients, width, height, resources, i, j, true)) {
                    return true;
                }
                if (!RecipeUtil.checkMatch(recipeIngredients, width, height, resources, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkMatch(Object[] recipeIngredients, int width, int height, ItemStack[][] resources, int xInGrid, int yInGrid, boolean mirror) {
        for (int k = 0; k < 3; ++k) {
            for (int l = 0; l < 3; ++l) {
                ItemStack resource = resources[k][l];
                int widthIt = k - xInGrid;
                int heightIt = l - yInGrid;
                Object recipeIngredient = null;
                if (widthIt >= 0 && heightIt >= 0 && widthIt < width && heightIt < height) {
                    recipeIngredient = mirror ? recipeIngredients[width - widthIt - 1 + heightIt * width] : recipeIngredients[widthIt + heightIt * width];
                }
                if (RecipeUtil.checkIngredientMatch(recipeIngredient, resource)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean checkIngredientMatch(Object recipeIngredient, ItemStack resource) {
        if (recipeIngredient == null && resource == null) {
            return true;
        }
        if (recipeIngredient instanceof ItemStack) {
            return ItemStackUtil.isCraftingEquivalent((ItemStack)recipeIngredient, resource);
        }
        if (recipeIngredient instanceof Iterable) {
            for (Object item : (Iterable)recipeIngredient) {
                if (!RecipeUtil.checkIngredientMatch(item, resource)) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

