/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import cpw.mods.fml.common.eventhandler.Event;
import forestry.api.core.ForestryEvent;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.PacketIdClient;
import forestry.core.network.PacketNBT;
import forestry.core.proxy.Proxies;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;

public class PacketGenomeTrackerUpdate
extends PacketNBT
implements IForestryPacketClient {
    public PacketGenomeTrackerUpdate() {
    }

    public PacketGenomeTrackerUpdate(NBTTagCompound nbtTagCompound) {
        super(PacketIdClient.GENOME_TRACKER_UPDATE, nbtTagCompound);
    }

    @Override
    public void onPacketData(DataInputStreamForestry data, EntityPlayer player) throws IOException {
        IBreedingTracker tracker = null;
        String type = this.getTagCompound().func_74779_i("TYPE");
        ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(type);
        if (root != null) {
            tracker = root.getBreedingTracker(Proxies.common.getRenderWorld(), player.func_146103_bH());
        }
        if (tracker != null) {
            tracker.decodeFromNBT(this.getTagCompound());
            MinecraftForge.EVENT_BUS.post((Event)new ForestryEvent.SyncedBreedingTracker(tracker, player));
        }
    }
}

