/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import forestry.apiculture.multiblock.IAlvearyController;
import forestry.apiculture.multiblock.TileAlveary;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.IForestryPacketServer;
import forestry.core.network.IPacketId;
import forestry.core.network.PacketCoordinates;
import forestry.core.network.PacketIdServer;
import forestry.core.tiles.IRestrictedAccessTile;
import forestry.farming.multiblock.IFarmController;
import forestry.farming.tiles.TileFarm;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;

public class PacketAccessSwitch
extends PacketCoordinates
implements IForestryPacketServer {
    public PacketAccessSwitch() {
    }

    public PacketAccessSwitch(ChunkCoordinates coordinates) {
        super((IPacketId)PacketIdServer.ACCESS_SWITCH, coordinates);
    }

    @Override
    public void onPacketData(DataInputStreamForestry data, EntityPlayerMP player) throws IOException {
        TileEntity tile = this.getTarget(player.field_70170_p);
        if (tile instanceof TileAlveary) {
            TileAlveary tileAlveary = (TileAlveary)tile;
            IAlvearyController alvearyController = tileAlveary.getAlvearyController();
            alvearyController.getAccessHandler().switchAccessRule((EntityPlayer)player);
        } else if (tile instanceof TileFarm) {
            TileFarm tileFarm = (TileFarm)tile;
            IFarmController farmController = tileFarm.getFarmController();
            farmController.getAccessHandler().switchAccessRule((EntityPlayer)player);
        } else if (tile instanceof IRestrictedAccessTile) {
            IRestrictedAccessTile restrictedAccessTile = (IRestrictedAccessTile)tile;
            restrictedAccessTile.getAccessHandler().switchAccessRule((EntityPlayer)player);
        }
    }
}

