/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.multiblock;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.mojang.authlib.GameProfile;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorLogicSource;
import forestry.core.access.AccessHandler;
import forestry.core.access.IAccessHandler;
import forestry.core.access.IOwnable;
import forestry.core.inventory.FakeInventoryAdapter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.multiblock.CoordTriplet;
import forestry.core.multiblock.IMultiblockPart;
import forestry.core.multiblock.MultiblockRegistry;
import forestry.core.multiblock.MultiblockValidationException;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.tiles.IRestrictedAccessTile;
import forestry.core.utils.Log;
import forestry.core.utils.StringUtil;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;

public abstract class MultiblockControllerBase
implements ISidedInventory,
IRestrictedAccessTile,
IErrorLogicSource {
    public static final short DIMENSION_UNBOUNDED = -1;
    protected World worldObj;
    protected AssemblyState assemblyState;
    protected HashSet<IMultiblockPart> connectedParts;
    private CoordTriplet referenceCoord;
    private CoordTriplet minimumCoord;
    private CoordTriplet maximumCoord;
    private boolean shouldCheckForDisconnections;
    private MultiblockValidationException lastValidationException;
    private static final Random rand = new Random();
    private int tickCount = rand.nextInt(256);
    private final AccessHandler accessHandler;
    private final IErrorLogic errorLogic;
    protected boolean debugMode;

    protected MultiblockControllerBase(World world) {
        this.worldObj = world;
        this.connectedParts = new HashSet();
        this.referenceCoord = null;
        this.assemblyState = AssemblyState.Disassembled;
        this.minimumCoord = null;
        this.maximumCoord = null;
        this.shouldCheckForDisconnections = true;
        this.lastValidationException = null;
        this.accessHandler = new AccessHandler(this);
        this.errorLogic = ForestryAPI.errorStateRegistry.createErrorLogic();
        this.debugMode = false;
    }

    @Override
    public IAccessHandler getAccessHandler() {
        return this.accessHandler;
    }

    @Override
    public IErrorLogic getErrorLogic() {
        return this.errorLogic;
    }

    public void setDebugMode(boolean active) {
        this.debugMode = active;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public abstract void onAttachedPartWithMultiblockData(IMultiblockPart var1, NBTTagCompound var2);

    public void attachBlock(IMultiblockPart part) {
        CoordTriplet coord = part.getWorldLocation();
        if (!this.connectedParts.add(part)) {
            Log.warning("[%s] Controller %s is double-adding part %d @ %s. This is unusual. If you encounter odd behavior, please tear down the machine and rebuild it.", this.worldObj.field_72995_K ? "CLIENT" : "SERVER", this.hashCode(), ((Object)((Object)part)).hashCode(), coord);
        }
        part.onAttached(this);
        this.onBlockAdded(part);
        if (part.hasMultiblockSaveData()) {
            NBTTagCompound savedData = part.getMultiblockSaveData();
            this.onAttachedPartWithMultiblockData(part, savedData);
            part.onMultiblockDataAssimilated();
        }
        if (this.referenceCoord == null) {
            this.referenceCoord = coord;
            part.becomeMultiblockSaveDelegate();
        } else if (coord.compareTo(this.referenceCoord) < 0) {
            TileEntity te = this.worldObj.func_147438_o(this.referenceCoord.x, this.referenceCoord.y, this.referenceCoord.z);
            ((IMultiblockPart)te).forfeitMultiblockSaveDelegate();
            this.referenceCoord = coord;
            part.becomeMultiblockSaveDelegate();
        } else {
            part.forfeitMultiblockSaveDelegate();
        }
        if (this.minimumCoord != null) {
            if (part.field_145851_c < this.minimumCoord.x) {
                this.minimumCoord.x = part.field_145851_c;
            }
            if (part.field_145848_d < this.minimumCoord.y) {
                this.minimumCoord.y = part.field_145848_d;
            }
            if (part.field_145849_e < this.minimumCoord.z) {
                this.minimumCoord.z = part.field_145849_e;
            }
        }
        if (this.maximumCoord != null) {
            if (part.field_145851_c > this.maximumCoord.x) {
                this.maximumCoord.x = part.field_145851_c;
            }
            if (part.field_145848_d > this.maximumCoord.y) {
                this.maximumCoord.y = part.field_145848_d;
            }
            if (part.field_145849_e > this.maximumCoord.z) {
                this.maximumCoord.z = part.field_145849_e;
            }
        }
        MultiblockRegistry.addDirtyController(this.worldObj, this);
    }

    protected abstract void onBlockAdded(IMultiblockPart var1);

    protected abstract void onBlockRemoved(IMultiblockPart var1);

    protected void onMachineAssembled() {
        if (this.worldObj.field_72995_K) {
            return;
        }
        HashMultiset owners = HashMultiset.create();
        for (IMultiblockPart part : this.connectedParts) {
            IOwnable ownable;
            GameProfile owner;
            if (part instanceof IRestrictedAccessTile) {
                IAccessHandler accessHandler = ((IRestrictedAccessTile)((Object)part)).getAccessHandler();
                owner = accessHandler.getOwner();
                if (owner == null) continue;
                owners.add((Object)owner);
                continue;
            }
            if (!(part instanceof IOwnable) || (owner = (ownable = (IOwnable)((Object)part)).getOwner()) == null) continue;
            owners.add((Object)owner);
        }
        GameProfile owner = null;
        int max = 0;
        for (Multiset.Entry entry : owners.entrySet()) {
            int count = entry.getCount();
            if (count <= max) continue;
            max = count;
            owner = (GameProfile)entry.getElement();
        }
        this.getAccessHandler().setOwner(owner);
    }

    protected void onMachineRestored() {
    }

    protected void onMachinePaused() {
    }

    protected void onMachineDisassembled() {
    }

    private void onDetachBlock(IMultiblockPart part) {
        part.onDetached(this);
        this.onBlockRemoved(part);
        part.forfeitMultiblockSaveDelegate();
        this.maximumCoord = null;
        this.minimumCoord = null;
        if (this.referenceCoord != null && this.referenceCoord.equals(part.field_145851_c, part.field_145848_d, part.field_145849_e)) {
            this.referenceCoord = null;
        }
        this.shouldCheckForDisconnections = true;
    }

    public void detachBlock(IMultiblockPart part, boolean chunkUnloading) {
        if (chunkUnloading && this.assemblyState == AssemblyState.Assembled) {
            this.assemblyState = AssemblyState.Paused;
            this.onMachinePaused();
        }
        this.onDetachBlock(part);
        if (!this.connectedParts.remove((Object)part)) {
            Log.warning("[%s] Double-removing part (%d) @ %d, %d, %d, this is unexpected and may cause problems. If you encounter anomalies, please tear down the reactor and rebuild it.", this.worldObj.field_72995_K ? "CLIENT" : "SERVER", ((Object)((Object)part)).hashCode(), part.field_145851_c, part.field_145848_d, part.field_145849_e);
        }
        if (this.connectedParts.isEmpty()) {
            MultiblockRegistry.addDeadController(this.worldObj, this);
            return;
        }
        MultiblockRegistry.addDirtyController(this.worldObj, this);
        if (this.referenceCoord == null) {
            this.selectNewReferenceCoord();
        }
    }

    protected abstract int getMinimumNumberOfBlocksForAssembledMachine();

    protected abstract int getMaximumXSize();

    protected abstract int getMaximumZSize();

    protected abstract int getMaximumYSize();

    protected int getMinimumXSize() {
        return 1;
    }

    protected int getMinimumYSize() {
        return 1;
    }

    protected int getMinimumZSize() {
        return 1;
    }

    public MultiblockValidationException getLastValidationException() {
        return this.lastValidationException;
    }

    protected abstract void isMachineWhole() throws MultiblockValidationException;

    public void checkIfMachineIsWhole() {
        boolean isWhole;
        AssemblyState oldState = this.assemblyState;
        this.lastValidationException = null;
        try {
            this.isMachineWhole();
            isWhole = true;
        }
        catch (MultiblockValidationException e) {
            this.lastValidationException = e;
            isWhole = false;
        }
        if (isWhole) {
            this.assembleMachine(oldState);
        } else if (oldState == AssemblyState.Assembled) {
            this.disassembleMachine();
        }
    }

    private void assembleMachine(AssemblyState oldState) {
        this.assemblyState = AssemblyState.Assembled;
        for (IMultiblockPart part : this.connectedParts) {
            part.onMachineAssembled(this);
        }
        if (oldState == AssemblyState.Paused) {
            this.onMachineRestored();
        } else {
            this.onMachineAssembled();
        }
    }

    private void disassembleMachine() {
        this.assemblyState = AssemblyState.Disassembled;
        for (IMultiblockPart part : this.connectedParts) {
            part.onMachineBroken();
        }
        this.onMachineDisassembled();
    }

    public void assimilate(MultiblockControllerBase other) {
        CoordTriplet otherReferenceCoord = other.getReferenceCoord();
        if (otherReferenceCoord != null && this.getReferenceCoord().compareTo(otherReferenceCoord) >= 0) {
            throw new IllegalArgumentException("The controller with the lowest minimum-coord value must consume the one with the higher coords");
        }
        HashSet<IMultiblockPart> partsToAcquire = new HashSet<IMultiblockPart>(other.connectedParts);
        other._onAssimilated(this);
        for (IMultiblockPart acquiredPart : partsToAcquire) {
            if (acquiredPart.func_145837_r()) continue;
            this.connectedParts.add(acquiredPart);
            acquiredPart.onAssimilated(this);
            this.onBlockAdded(acquiredPart);
        }
        this.onAssimilate(other);
        other.onAssimilated(this);
    }

    private void _onAssimilated(MultiblockControllerBase otherController) {
        if (this.referenceCoord != null) {
            TileEntity te;
            if (this.worldObj.func_72863_F().func_73149_a(this.referenceCoord.getChunkX(), this.referenceCoord.getChunkZ()) && (te = this.worldObj.func_147438_o(this.referenceCoord.x, this.referenceCoord.y, this.referenceCoord.z)) instanceof IMultiblockPart) {
                ((IMultiblockPart)te).forfeitMultiblockSaveDelegate();
            }
            this.referenceCoord = null;
        }
        this.connectedParts.clear();
    }

    protected abstract void onAssimilate(MultiblockControllerBase var1);

    protected abstract void onAssimilated(MultiblockControllerBase var1);

    public final void updateMultiblockEntity() {
        ++this.tickCount;
        if (this.connectedParts.isEmpty()) {
            MultiblockRegistry.addDeadController(this.worldObj, this);
            return;
        }
        if (this.assemblyState != AssemblyState.Assembled) {
            return;
        }
        if (this.worldObj.field_72995_K) {
            this.updateClient(this.tickCount);
        } else if (this.updateServer(this.tickCount) && this.minimumCoord != null && this.maximumCoord != null && this.worldObj.func_72904_c(this.minimumCoord.x, this.minimumCoord.y, this.minimumCoord.z, this.maximumCoord.x, this.maximumCoord.y, this.maximumCoord.z)) {
            int minChunkX = this.minimumCoord.x >> 4;
            int minChunkZ = this.minimumCoord.z >> 4;
            int maxChunkX = this.maximumCoord.x >> 4;
            int maxChunkZ = this.maximumCoord.z >> 4;
            for (int x = minChunkX; x <= maxChunkX; ++x) {
                for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                    Chunk chunkToSave = this.worldObj.func_72964_e(x, z);
                    chunkToSave.func_76630_e();
                }
            }
        }
    }

    protected abstract boolean updateServer(int var1);

    protected abstract void updateClient(int var1);

    protected final boolean updateOnInterval(int tickInterval) {
        return this.tickCount % tickInterval == 0;
    }

    protected void isBlockGoodForExteriorLevel(int level, World world, int x, int y, int z) throws MultiblockValidationException {
        Block block = world.func_147439_a(x, y, z);
        throw new MultiblockValidationException(StringUtil.localizeAndFormatRaw("for.multiblock.error.invalid.interior", x, y, z, block.func_149732_F()));
    }

    protected void isBlockGoodForInterior(World world, int x, int y, int z) throws MultiblockValidationException {
        Block block = world.func_147439_a(x, y, z);
        throw new MultiblockValidationException(StringUtil.localizeAndFormatRaw("for.multiblock.error.invalid.interior", x, y, z, block.func_149732_F()));
    }

    public CoordTriplet getReferenceCoord() {
        if (this.referenceCoord == null) {
            this.selectNewReferenceCoord();
        }
        return this.referenceCoord;
    }

    public int getNumConnectedBlocks() {
        return this.connectedParts.size();
    }

    public void writeToNBT(NBTTagCompound data) {
        this.accessHandler.writeToNBT(data);
    }

    public void readFromNBT(NBTTagCompound data) {
        this.accessHandler.readFromNBT(data);
    }

    public void recalculateMinMaxCoords() {
        this.minimumCoord = new CoordTriplet(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.maximumCoord = new CoordTriplet(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        for (IMultiblockPart part : this.connectedParts) {
            if (part.field_145851_c < this.minimumCoord.x) {
                this.minimumCoord.x = part.field_145851_c;
            }
            if (part.field_145851_c > this.maximumCoord.x) {
                this.maximumCoord.x = part.field_145851_c;
            }
            if (part.field_145848_d < this.minimumCoord.y) {
                this.minimumCoord.y = part.field_145848_d;
            }
            if (part.field_145848_d > this.maximumCoord.y) {
                this.maximumCoord.y = part.field_145848_d;
            }
            if (part.field_145849_e < this.minimumCoord.z) {
                this.minimumCoord.z = part.field_145849_e;
            }
            if (part.field_145849_e <= this.maximumCoord.z) continue;
            this.maximumCoord.z = part.field_145849_e;
        }
    }

    public CoordTriplet getMinimumCoord() {
        if (this.minimumCoord == null) {
            this.recalculateMinMaxCoords();
        }
        return this.minimumCoord.copy();
    }

    public CoordTriplet getMaximumCoord() {
        if (this.maximumCoord == null) {
            this.recalculateMinMaxCoords();
        }
        return this.maximumCoord.copy();
    }

    public final CoordTriplet getCenterCoord() {
        CoordTriplet minCoord = this.getMinimumCoord();
        CoordTriplet maxCoord = this.getMaximumCoord();
        return new CoordTriplet((minCoord.x + maxCoord.x) / 2, (minCoord.y + maxCoord.y) / 2, (minCoord.z + maxCoord.z) / 2);
    }

    public final CoordTriplet getTopCenterCoord() {
        CoordTriplet minCoord = this.getMinimumCoord();
        CoordTriplet maxCoord = this.getMaximumCoord();
        return new CoordTriplet((minCoord.x + maxCoord.x) / 2, maxCoord.y, (minCoord.z + maxCoord.z) / 2);
    }

    public final boolean isCoordInMultiblock(int x, int y, int z) {
        return x >= this.minimumCoord.x && x <= this.maximumCoord.x && y >= this.minimumCoord.y && y <= this.maximumCoord.y && z >= this.minimumCoord.z && z <= this.maximumCoord.z;
    }

    public abstract void formatDescriptionPacket(NBTTagCompound var1);

    public abstract void decodeDescriptionPacket(NBTTagCompound var1);

    public boolean isEmpty() {
        return this.connectedParts.isEmpty();
    }

    public boolean shouldConsume(MultiblockControllerBase otherController) {
        if (!otherController.getClass().equals(this.getClass())) {
            throw new IllegalArgumentException("Attempting to merge two multiblocks with different master classes - this should never happen!");
        }
        if (otherController == this) {
            return false;
        }
        int res = this._shouldConsume(otherController);
        if (res < 0) {
            return true;
        }
        if (res > 0) {
            return false;
        }
        Log.warning("[%s] Encountered two controllers with the same reference coordinate. Auditing connected parts and retrying.", (Object)(this.worldObj.field_72995_K ? "CLIENT" : "SERVER"));
        this.auditParts();
        otherController.auditParts();
        res = this._shouldConsume(otherController);
        if (res < 0) {
            return true;
        }
        if (res > 0) {
            return false;
        }
        Log.severe("My Controller (%d): size (%d), parts: %s", this.hashCode(), this.connectedParts.size(), this.getPartsListString());
        Log.severe("Other Controller (%d): size (%d), coords: %s", otherController.hashCode(), otherController.connectedParts.size(), otherController.getPartsListString());
        throw new IllegalArgumentException("[" + (this.worldObj.field_72995_K ? "CLIENT" : "SERVER") + "] Two controllers with the same reference coord that somehow both have valid parts - this should never happen!");
    }

    private int _shouldConsume(MultiblockControllerBase otherController) {
        CoordTriplet myCoord = this.getReferenceCoord();
        CoordTriplet theirCoord = otherController.getReferenceCoord();
        if (theirCoord == null) {
            return -1;
        }
        return myCoord.compareTo(theirCoord);
    }

    private String getPartsListString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (IMultiblockPart part : this.connectedParts) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(String.format("(%d: %d, %d, %d)", ((Object)((Object)part)).hashCode(), part.field_145851_c, part.field_145848_d, part.field_145849_e));
            first = false;
        }
        return sb.toString();
    }

    private void auditParts() {
        HashSet<IMultiblockPart> deadParts = new HashSet<IMultiblockPart>();
        for (IMultiblockPart part : this.connectedParts) {
            if (!part.func_145837_r() && this.worldObj.func_147438_o(part.field_145851_c, part.field_145848_d, part.field_145849_e) == part) continue;
            this.onDetachBlock(part);
            deadParts.add(part);
        }
        this.connectedParts.removeAll(deadParts);
        Log.warning("[%s] Controller found %d dead parts during an audit, %d parts remain attached", this.worldObj.field_72995_K ? "CLIENT" : "SERVER", deadParts.size(), this.connectedParts.size());
    }

    public Set<IMultiblockPart> checkForDisconnections() {
        if (!this.shouldCheckForDisconnections) {
            return null;
        }
        if (this.isEmpty()) {
            MultiblockRegistry.addDeadController(this.worldObj, this);
            return null;
        }
        IChunkProvider chunkProvider = this.worldObj.func_72863_F();
        this.referenceCoord = null;
        HashSet<IMultiblockPart> deadParts = new HashSet<IMultiblockPart>();
        IMultiblockPart referencePart = null;
        int originalSize = this.connectedParts.size();
        for (IMultiblockPart part : this.connectedParts) {
            if (!chunkProvider.func_73149_a(part.field_145851_c >> 4, part.field_145849_e >> 4) || part.func_145837_r()) {
                deadParts.add(part);
                this.onDetachBlock(part);
                continue;
            }
            if (this.worldObj.func_147438_o(part.field_145851_c, part.field_145848_d, part.field_145849_e) != part) {
                deadParts.add(part);
                this.onDetachBlock(part);
                continue;
            }
            part.setUnvisited();
            part.forfeitMultiblockSaveDelegate();
            CoordTriplet c = part.getWorldLocation();
            if (this.referenceCoord == null) {
                this.referenceCoord = c;
                referencePart = part;
                continue;
            }
            if (c.compareTo(this.referenceCoord) >= 0) continue;
            this.referenceCoord = c;
            referencePart = part;
        }
        this.connectedParts.removeAll(deadParts);
        deadParts.clear();
        if (referencePart == null || this.isEmpty()) {
            this.shouldCheckForDisconnections = false;
            MultiblockRegistry.addDeadController(this.worldObj, this);
            return null;
        }
        referencePart.becomeMultiblockSaveDelegate();
        LinkedList<IMultiblockPart> partsToCheck = new LinkedList<IMultiblockPart>();
        int visitedParts = 0;
        partsToCheck.add(referencePart);
        while (!partsToCheck.isEmpty()) {
            IMultiblockPart[] nearbyParts;
            IMultiblockPart part = (IMultiblockPart)((Object)partsToCheck.removeFirst());
            part.setVisited();
            ++visitedParts;
            for (IMultiblockPart nearbyPart : nearbyParts = part.getNeighboringParts()) {
                if (nearbyPart.getMultiblockController() != this || nearbyPart.isVisited()) continue;
                nearbyPart.setVisited();
                partsToCheck.add(nearbyPart);
            }
        }
        HashSet<IMultiblockPart> removedParts = new HashSet<IMultiblockPart>();
        for (IMultiblockPart orphanCandidate : this.connectedParts) {
            if (orphanCandidate.isVisited()) continue;
            deadParts.add(orphanCandidate);
            orphanCandidate.onOrphaned(this, originalSize, visitedParts);
            this.onDetachBlock(orphanCandidate);
            removedParts.add(orphanCandidate);
        }
        this.connectedParts.removeAll(deadParts);
        deadParts.clear();
        if (this.referenceCoord == null) {
            this.selectNewReferenceCoord();
        }
        this.shouldCheckForDisconnections = false;
        return removedParts;
    }

    public Set<IMultiblockPart> detachAllBlocks() {
        if (this.worldObj == null) {
            return new HashSet<IMultiblockPart>();
        }
        IChunkProvider chunkProvider = this.worldObj.func_72863_F();
        for (IMultiblockPart part : this.connectedParts) {
            if (!chunkProvider.func_73149_a(part.field_145851_c >> 4, part.field_145849_e >> 4)) continue;
            this.onDetachBlock(part);
        }
        HashSet<IMultiblockPart> detachedParts = this.connectedParts;
        this.connectedParts = new HashSet();
        return detachedParts;
    }

    public boolean isAssembled() {
        return this.assemblyState == AssemblyState.Assembled;
    }

    private void selectNewReferenceCoord() {
        IChunkProvider chunkProvider = this.worldObj.func_72863_F();
        IMultiblockPart theChosenOne = null;
        this.referenceCoord = null;
        for (IMultiblockPart part : this.connectedParts) {
            if (part.func_145837_r() || !chunkProvider.func_73149_a(part.field_145851_c >> 4, part.field_145849_e >> 4) || this.referenceCoord != null && this.referenceCoord.compareTo(part.field_145851_c, part.field_145848_d, part.field_145849_e) <= 0) continue;
            this.referenceCoord = part.getWorldLocation();
            theChosenOne = part;
        }
        if (theChosenOne != null) {
            ((IMultiblockPart)theChosenOne).becomeMultiblockSaveDelegate();
        }
    }

    protected void markReferenceCoordForUpdate() {
        CoordTriplet rc = this.getReferenceCoord();
        if (this.worldObj != null && rc != null) {
            this.worldObj.func_147471_g(rc.x, rc.y, rc.z);
        }
    }

    protected void markReferenceCoordDirty() {
        if (this.worldObj == null || this.worldObj.field_72995_K) {
            return;
        }
        CoordTriplet referenceCoord = this.getReferenceCoord();
        if (referenceCoord == null) {
            return;
        }
        TileEntity saveTe = this.worldObj.func_147438_o(referenceCoord.x, referenceCoord.y, referenceCoord.z);
        this.worldObj.func_147476_b(referenceCoord.x, referenceCoord.y, referenceCoord.z, saveTe);
    }

    public IInventoryAdapter getInternalInventory() {
        return FakeInventoryAdapter.instance();
    }

    public void func_70296_d() {
        this.getInternalInventory().func_70296_d();
    }

    public final int func_70302_i_() {
        return this.getInternalInventory().func_70302_i_();
    }

    public final ItemStack func_70301_a(int slotIndex) {
        return this.getInternalInventory().func_70301_a(slotIndex);
    }

    public final ItemStack func_70298_a(int slotIndex, int amount) {
        return this.getInternalInventory().func_70298_a(slotIndex, amount);
    }

    public final ItemStack func_70304_b(int slotIndex) {
        return this.getInternalInventory().func_70304_b(slotIndex);
    }

    public final void func_70299_a(int slotIndex, ItemStack itemstack) {
        this.getInternalInventory().func_70299_a(slotIndex, itemstack);
    }

    public final int func_70297_j_() {
        return this.getInternalInventory().func_70297_j_();
    }

    public final void func_70295_k_() {
        this.getInternalInventory().func_70295_k_();
    }

    public final void func_70305_f() {
        this.getInternalInventory().func_70305_f();
    }

    public final String func_145825_b() {
        return this.getInternalInventory().func_145825_b();
    }

    public final boolean func_70300_a(EntityPlayer player) {
        return this.getInternalInventory().func_70300_a(player);
    }

    public final boolean func_145818_k_() {
        return this.getInternalInventory().func_145818_k_();
    }

    public final boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        return this.getInternalInventory().func_94041_b(slotIndex, itemStack);
    }

    public final int[] func_94128_d(int side) {
        return this.getInternalInventory().func_94128_d(side);
    }

    public final boolean func_102007_a(int slotIndex, ItemStack itemStack, int side) {
        return this.getInternalInventory().func_102007_a(slotIndex, itemStack, side);
    }

    public final boolean func_102008_b(int slotIndex, ItemStack itemStack, int side) {
        return this.getInternalInventory().func_102008_b(slotIndex, itemStack, side);
    }

    @Override
    public void writeGuiData(DataOutputStreamForestry data) throws IOException {
        this.accessHandler.writeData(data);
        this.errorLogic.writeData(data);
    }

    @Override
    public void readGuiData(DataInputStreamForestry data) throws IOException {
        this.accessHandler.readData(data);
        this.errorLogic.readData(data);
    }

    protected static enum AssemblyState {
        Disassembled,
        Assembled,
        Paused;

    }
}

