/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.alleles;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import net.minecraft.util.StatCollector;

public abstract class Allele
implements IAllele {
    private final String uid;
    private final boolean isDominant;
    private final String unlocalizedName;

    protected Allele(String uid, String unlocalizedName, boolean isDominant) {
        this(uid, unlocalizedName, isDominant, true);
    }

    protected Allele(String uid, String unlocalizedName, boolean isDominant, boolean doRegister) {
        this.uid = uid;
        this.isDominant = isDominant;
        this.unlocalizedName = unlocalizedName;
        if (doRegister) {
            AlleleManager.alleleRegistry.registerAllele(this);
        }
    }

    @Override
    public String getUID() {
        return this.uid;
    }

    @Override
    public boolean isDominant() {
        return this.isDominant;
    }

    @Override
    public String getName() {
        return StatCollector.func_74838_a((String)this.getUnlocalizedName());
    }

    @Override
    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public String toString() {
        return this.uid;
    }
}

