/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids;

import forestry.core.config.ForestryItem;
import forestry.core.fluids.BlockForestryFluid;
import forestry.core.fluids.FluidHelper;
import forestry.core.items.ItemLiquidContainer;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public enum Fluids {
    ETHANOL(new Color(255, 111, 0), 790, 1000){

        @Override
        public String getTag() {
            return "bioethanol";
        }

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this, 300, true);
        }

        @Override
        public ForestryItem getContainerForType(ItemLiquidContainer.EnumContainerType type) {
            switch (type) {
                case BUCKET: {
                    return ForestryItem.bucketEthanol;
                }
                case CAN: {
                    return ForestryItem.canEthanol;
                }
                case CAPSULE: {
                    return ForestryItem.waxCapsuleEthanol;
                }
                case REFRACTORY: {
                    return ForestryItem.refractoryEthanol;
                }
            }
            return null;
        }
    }
    ,
    BIOMASS(new Color(100, 132, 41), 400, 6560){

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this, 100, true);
        }

        @Override
        public ForestryItem getContainerForType(ItemLiquidContainer.EnumContainerType type) {
            switch (type) {
                case BUCKET: {
                    return ForestryItem.bucketBiomass;
                }
                case CAN: {
                    return ForestryItem.canBiomass;
                }
                case CAPSULE: {
                    return ForestryItem.waxCapsuleBiomass;
                }
                case REFRACTORY: {
                    return ForestryItem.refractoryBiomass;
                }
            }
            return null;
        }
    }
    ,
    GLASS(new Color(164, 164, 164), 2400, 10000){

        @Override
        public int getTemperature() {
            return 1200;
        }

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this, 0, true);
        }

        @Override
        public ForestryItem getContainerForType(ItemLiquidContainer.EnumContainerType type) {
            switch (type) {
                case BUCKET: {
                    return ForestryItem.bucketGlass;
                }
            }
            return null;
        }
    }
    ,
    HONEY(new Color(255, 196, 35), 1420, 73600){

        @Override
        public String getTag() {
            return "for.honey";
        }

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this);
        }

        @Override
        public ForestryItem getContainerForType(ItemLiquidContainer.EnumContainerType type) {
            switch (type) {
                case BUCKET: {
                    return ForestryItem.bucketHoney;
                }
                case CAN: {
                    return ForestryItem.canHoney;
                }
                case CAPSULE: {
                    return ForestryItem.waxCapsuleHoney;
                }
                case REFRACTORY: {
                    return ForestryItem.refractoryHoney;
                }
            }
            return null;
        }

        @Override
        public void setProperties(ItemLiquidContainer liquidContainer) {
            if (liquidContainer.getType() != ItemLiquidContainer.EnumContainerType.BUCKET) {
                liquidContainer.setDrink(2, 0.2f);
            }
        }
    }
    ,
    LEGACY_HONEY(new Color(255, 196, 35)){

        @Override
        public String getTag() {
            return "honey";
        }
    }
    ,
    ICE(new Color(175, 242, 255), 920, 1000){

        @Override
        public int getTemperature() {
            return 265;
        }

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this);
        }

        @Override
        public ForestryItem getContainerForType(ItemLiquidContainer.EnumContainerType type) {
            switch (type) {
                case BUCKET: {
                    return ForestryItem.bucketIce;
                }
                case CAN: {
                    return ForestryItem.canIce;
                }
                case CAPSULE: {
                    return ForestryItem.waxCapsuleIce;
                }
                case REFRACTORY: {
                    return ForestryItem.refractoryIce;
                }
            }
            return null;
        }
    }
    ,
    JUICE(new Color(168, 201, 114)){

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this);
        }

        @Override
        public ForestryItem getContainerForType(ItemLiquidContainer.EnumContainerType type) {
            switch (type) {
                case BUCKET: {
                    return ForestryItem.bucketJuice;
                }
                case CAN: {
                    return ForestryItem.canJuice;
                }
                case CAPSULE: {
                    return ForestryItem.waxCapsuleJuice;
                }
                case REFRACTORY: {
                    return ForestryItem.refractoryJuice;
                }
            }
            return null;
        }

        @Override
        public void setProperties(ItemLiquidContainer liquidContainer) {
            if (liquidContainer.getType() != ItemLiquidContainer.EnumContainerType.BUCKET) {
                liquidContainer.setDrink(2, 0.2f);
            }
        }
    }
    ,
    MILK(new Color(255, 255, 255), 1030, 3000){

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this);
        }

        @Override
        public List<ItemStack> getOtherContainers() {
            return Arrays.asList(new ItemStack(Items.field_151117_aB));
        }
    }
    ,
    SEEDOIL(new Color(255, 255, 168), 885, 5000){

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this, 2, true);
        }

        @Override
        public ForestryItem getContainerForType(ItemLiquidContainer.EnumContainerType type) {
            switch (type) {
                case BUCKET: {
                    return ForestryItem.bucketSeedoil;
                }
                case CAN: {
                    return ForestryItem.canSeedOil;
                }
                case CAPSULE: {
                    return ForestryItem.waxCapsuleSeedOil;
                }
                case REFRACTORY: {
                    return ForestryItem.refractorySeedOil;
                }
            }
            return null;
        }
    }
    ,
    SHORT_MEAD(new Color(239, 154, 56), 1000, 1200){

        @Override
        public String getTag() {
            return "short.mead";
        }

        @Override
        public Block makeBlock() {
            return new BlockForestryFluid(this);
        }

        @Override
        public ForestryItem getContainerForType(ItemLiquidContainer.EnumContainerType type) {
            switch (type) {
                case BUCKET: {
                    return ForestryItem.bucketShortMead;
                }
            }
            return null;
        }
    }
    ,
    WATER(new Color(2372332)){

        @Override
        public ForestryItem getContainerForType(ItemLiquidContainer.EnumContainerType type) {
            switch (type) {
                case CAN: {
                    return ForestryItem.canWater;
                }
                case CAPSULE: {
                    return ForestryItem.waxCapsuleWater;
                }
                case REFRACTORY: {
                    return ForestryItem.refractoryWater;
                }
            }
            return null;
        }
    }
    ,
    LAVA(new Color(16598559)){

        @Override
        public ForestryItem getContainerForType(ItemLiquidContainer.EnumContainerType type) {
            switch (type) {
                case CAN: {
                    return ForestryItem.canLava;
                }
                case REFRACTORY: {
                    return ForestryItem.refractoryLava;
                }
            }
            return null;
        }
    }
    ,
    FUEL(new Color(0xFFFF00)){

        @Override
        public ForestryItem getContainerForType(ItemLiquidContainer.EnumContainerType type) {
            switch (type) {
                case CAN: {
                    return ForestryItem.canFuel;
                }
                case CAPSULE: {
                    return ForestryItem.waxCapsuleFuel;
                }
                case REFRACTORY: {
                    return ForestryItem.refractoryFuel;
                }
            }
            return null;
        }
    }
    ,
    OIL(new Color(0x404040)){

        @Override
        public ForestryItem getContainerForType(ItemLiquidContainer.EnumContainerType type) {
            switch (type) {
                case CAN: {
                    return ForestryItem.canOil;
                }
                case CAPSULE: {
                    return ForestryItem.waxCapsuleOil;
                }
                case REFRACTORY: {
                    return ForestryItem.refractoryOil;
                }
            }
            return null;
        }
    }
    ,
    CREOSOTE(new Color(6511619)),
    STEAM(new Color(9540495));

    public static final Fluids[] forestryFluids;
    private static final Map<String, Fluids> tagToFluid;
    private final String tag = this.name().toLowerCase(Locale.ENGLISH);
    private final int density;
    private final int viscosity;
    @Nonnull
    private final Color color;

    private Fluids(Color color) {
        this(color, 1000, 1000);
    }

    private Fluids(Color color, int density, int viscosity) {
        this.color = color;
        this.density = density;
        this.viscosity = viscosity;
    }

    public int getTemperature() {
        return 295;
    }

    public String getTag() {
        return this.tag;
    }

    public final int getDensity() {
        return this.density;
    }

    public final int getViscosity() {
        return this.viscosity;
    }

    public final Fluid getFluid() {
        return FluidRegistry.getFluid((String)this.getTag());
    }

    public final FluidStack getFluid(int mb) {
        return FluidRegistry.getFluidStack((String)this.getTag(), (int)mb);
    }

    public final Block getBlock() {
        Fluid fluid = this.getFluid();
        if (fluid == null) {
            return null;
        }
        return fluid.getBlock();
    }

    @Nonnull
    public final Color getColor() {
        return this.color;
    }

    public final boolean is(Fluid fluid) {
        return this.getFluid() == fluid;
    }

    public final boolean is(FluidStack fluidStack) {
        return fluidStack != null && this.getFluid() == fluidStack.getFluid();
    }

    public final boolean isContained(ItemStack containerStack) {
        return containerStack != null && FluidHelper.containsFluid(containerStack, this.getFluid());
    }

    public static boolean areEqual(Fluid fluid, FluidStack fluidStack) {
        if (fluidStack != null && fluid == fluidStack.getFluid()) {
            return true;
        }
        return fluid == null && fluidStack == null;
    }

    public static boolean areEqual(FluidStack a, FluidStack b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.isFluidEqual(b);
    }

    @Nonnull
    public static Color getFluidColor(FluidStack fluidStack) {
        Fluids fluids;
        Fluid fluid;
        if (fluidStack != null && (fluid = fluidStack.getFluid()) != null && (fluids = tagToFluid.get(fluid.getName())) != null) {
            return fluids.getColor();
        }
        return WATER.getColor();
    }

    public ForestryItem getContainerForType(ItemLiquidContainer.EnumContainerType type) {
        return null;
    }

    public List<ItemStack> getOtherContainers() {
        return Collections.emptyList();
    }

    public Block makeBlock() {
        return null;
    }

    public void setProperties(ItemLiquidContainer liquidContainer) {
    }

    static {
        forestryFluids = new Fluids[]{ETHANOL, BIOMASS, GLASS, HONEY, LEGACY_HONEY, ICE, JUICE, MILK, SEEDOIL, SHORT_MEAD};
        tagToFluid = new HashMap<String, Fluids>();
        for (Fluids fluids : Fluids.values()) {
            tagToFluid.put(fluids.getTag(), fluids);
        }
    }
}

