/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.errors;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorState;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;

public enum EnumErrorCode implements IErrorState
{
    UNKNOWN("unknown"),
    INVALIDBIOME("invalidBiome"),
    ISRAINING("isRaining"),
    NOTRAINING("notRaining"),
    NOFUEL("noFuel"),
    NOHEAT("noHeat"),
    NODISPOSAL("noDisposal"),
    NORESOURCE("noResource"),
    NOTGLOOMY("notGloomy"),
    NOTLUCID("notLucid"),
    NOTDAY("notDay"),
    NOTNIGHT("notNight"),
    NOFLOWER("noFlower"),
    NOQUEEN("noQueen"),
    NODRONE("noDrone"),
    NOSKY("noSky"),
    NOSPACE("noSpace"),
    NOSPACETANK("noSpaceTank", "noLiquid"),
    NORECIPE("noRecipe"),
    NOENERGYNET("noEnergyNet"),
    NOTHINGANALYZE("noSpecimen"),
    FORCEDCOOLDOWN("forcedCooldown"),
    NOHONEY("noHoney"),
    NOTPOSTPAID("notPostpaid", "noStamps"),
    NORECIPIENT("noRecipient"),
    NOTALPHANUMERIC("notAlphaNumeric"),
    NOTUNIQUE("notUnique"),
    NOSTAMPS("noStamps"),
    NOCIRCUITBOARD("noCircuitBoard"),
    NOCIRCUITLAYOUT("noCircuitLayout"),
    WRONGSTACKSIZE("wrongStacksize"),
    NOFERTILIZER("noFertilizer"),
    NOFARMLAND("noFarmland"),
    CIRCUITMISMATCH("circuitMismatch"),
    NOLIQUID("noLiquid"),
    NOPAPER("noPaper"),
    NOSUPPLIES("noSupplies", "noResource"),
    NOTRADE("noTrade", "noResource"),
    NOPOWER("noPower"),
    NOREDSTONE("noRedstone", "disabled"),
    DISABLED("disabledRedstone", "disabled");

    private final String name;
    private final String iconName;
    @SideOnly(value=Side.CLIENT)
    private IIcon icon;

    private EnumErrorCode(String name) {
        this(name, name);
    }

    private EnumErrorCode(String name, String iconName) {
        this.name = name;
        this.iconName = iconName;
    }

    @Override
    public String getDescription() {
        return "errors." + this.name + ".desc";
    }

    @Override
    public String getHelp() {
        return "errors." + this.name + ".help";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.icon = register.func_94245_a("forestry:errors/" + this.iconName);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return this.icon;
    }

    @Override
    public short getID() {
        return (short)this.ordinal();
    }

    @Override
    public String getUniqueName() {
        return "Forestry:" + this.name;
    }

    public static void init() {
        for (EnumErrorCode code : EnumErrorCode.values()) {
            ForestryAPI.errorStateRegistry.registerErrorState(code);
        }
    }
}

