/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitBoard;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.circuits.ICircuitSocketType;
import forestry.core.circuits.EnumCircuitBoardType;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public class CircuitBoard<T>
implements ICircuitBoard {
    private EnumCircuitBoardType type;
    private ICircuitLayout layout;
    private ICircuit[] circuits;

    public CircuitBoard(EnumCircuitBoardType type, ICircuitLayout layout, ICircuit[] circuits) {
        this.type = type;
        this.layout = layout;
        this.circuits = circuits;
    }

    public CircuitBoard(NBTTagCompound nbttagcompound) {
        this.readFromNBT(nbttagcompound);
    }

    @Override
    public int getPrimaryColor() {
        return this.type.primaryColor;
    }

    @Override
    public int getSecondaryColor() {
        return this.type.secondaryColor;
    }

    @Override
    public void addTooltip(List<String> list) {
        if (this.layout != null) {
            list.add(EnumChatFormatting.GOLD + this.layout.getUsage() + ":");
        }
        ArrayList<String> extendedTooltip = new ArrayList<String>();
        for (ICircuit circuit : this.circuits) {
            if (circuit == null) continue;
            circuit.addTooltip(extendedTooltip);
        }
        if (Proxies.common.isShiftDown() || extendedTooltip.size() <= 4) {
            list.addAll(extendedTooltip);
        } else {
            list.add(EnumChatFormatting.ITALIC + "<" + StringUtil.localize("gui.tooltip.tmi") + ">");
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.type = EnumCircuitBoardType.values()[nbttagcompound.func_74765_d("T")];
        if (nbttagcompound.func_74764_b("LY")) {
            this.layout = ChipsetManager.circuitRegistry.getLayout(nbttagcompound.func_74779_i("LY"));
        }
        if (this.layout == null) {
            ChipsetManager.circuitRegistry.getDefaultLayout();
        }
        this.circuits = new ICircuit[4];
        for (int i = 0; i < 4; ++i) {
            ICircuit circuit;
            if (!nbttagcompound.func_74764_b("CA.I" + i) || (circuit = ChipsetManager.circuitRegistry.getCircuit(nbttagcompound.func_74779_i("CA.I" + i))) == null) continue;
            this.circuits[i] = circuit;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74777_a("T", (short)this.type.ordinal());
        if (this.layout != null) {
            nbttagcompound.func_74778_a("LY", this.layout.getUID());
        }
        for (int i = 0; i < this.circuits.length; ++i) {
            ICircuit circuit = this.circuits[i];
            if (circuit == null) continue;
            nbttagcompound.func_74778_a("CA.I" + i, circuit.getUID());
        }
    }

    @Override
    public void onInsertion(Object tile) {
        for (int i = 0; i < this.circuits.length; ++i) {
            ICircuit circuit = this.circuits[i];
            if (circuit == null) continue;
            circuit.onInsertion(i, tile);
        }
    }

    @Override
    public void onLoad(Object tile) {
        for (int i = 0; i < this.circuits.length; ++i) {
            ICircuit circuit = this.circuits[i];
            if (circuit == null) continue;
            circuit.onLoad(i, tile);
        }
    }

    @Override
    public void onRemoval(Object tile) {
        for (int i = 0; i < this.circuits.length; ++i) {
            ICircuit circuit = this.circuits[i];
            if (circuit == null) continue;
            circuit.onRemoval(i, tile);
        }
    }

    @Override
    public void onTick(Object tile) {
        for (int i = 0; i < this.circuits.length; ++i) {
            ICircuit circuit = this.circuits[i];
            if (circuit == null) continue;
            circuit.onTick(i, tile);
        }
    }

    @Override
    public ICircuit[] getCircuits() {
        return this.circuits;
    }

    @Override
    public ICircuitSocketType getSocketType() {
        return this.layout.getSocketType();
    }
}

