/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.blocks;

import com.mojang.authlib.GameProfile;
import forestry.core.CreativeTabForestry;
import forestry.core.access.IOwnable;
import forestry.core.tiles.IRestrictedAccessTile;
import forestry.core.tiles.TileForestry;
import forestry.core.utils.Log;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public abstract class BlockForestry
extends BlockContainer {
    protected BlockForestry(Material material) {
        super(material);
        this.func_149711_c(1.5f);
        this.func_149647_a(CreativeTabForestry.tabForestry);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        IRestrictedAccessTile restrictedAccessTile;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IRestrictedAccessTile && !(restrictedAccessTile = (IRestrictedAccessTile)tile).getAccessHandler().allowsRemoval(player)) {
            return false;
        }
        return super.removedByPlayer(world, player, x, y, z);
    }

    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase entityLiving, ItemStack itemstack) {
        if (world.field_72995_K) {
            return;
        }
        if (entityLiving instanceof EntityPlayer) {
            IOwnable ownable;
            TileEntity tile = world.func_147438_o(i, j, k);
            if (tile instanceof IRestrictedAccessTile) {
                ownable = ((IRestrictedAccessTile)tile).getAccessHandler();
            } else if (tile instanceof IOwnable) {
                ownable = (IOwnable)tile;
            } else {
                return;
            }
            EntityPlayer player = (EntityPlayer)entityLiving;
            GameProfile gameProfile = player.func_146103_bH();
            ownable.setOwner(gameProfile);
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        try {
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile instanceof TileForestry) {
                ((TileForestry)tile).onNeighborBlockChange(block);
            }
        }
        catch (StackOverflowError error) {
            Log.logThrowable(Level.ERROR, "Stack Overflow Error in BlockMachine.onNeighborBlockChange()", 10, error, new Object[0]);
            throw error;
        }
    }
}

