/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import cpw.mods.fml.common.network.IGuiHandler;
import forestry.core.GuiHandlerBase;
import forestry.core.circuits.ContainerSolderingIron;
import forestry.core.circuits.GuiSolderingIron;
import forestry.core.circuits.ItemSolderingIron;
import forestry.core.gui.ContainerAnalyzer;
import forestry.core.gui.ContainerEscritoire;
import forestry.core.gui.GuiAnalyzer;
import forestry.core.gui.GuiEscritoire;
import forestry.core.network.GuiId;
import forestry.core.tiles.TileAnalyzer;
import forestry.core.tiles.TileEscritoire;
import forestry.plugins.PluginManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class GuiHandler
extends GuiHandlerBase {
    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        int cleanId = GuiHandler.decodeGuiID(id);
        if (cleanId < GuiId.values().length) {
            switch (GuiId.values()[cleanId]) {
                case AnalyzerGUI: {
                    return new GuiAnalyzer(player.field_71071_by, GuiHandler.getTile(world, x, y, z, player, TileAnalyzer.class));
                }
                case NaturalistBenchGUI: {
                    return new GuiEscritoire(player, GuiHandler.getTile(world, x, y, z, player, TileEscritoire.class));
                }
                case SolderingIronGUI: {
                    ItemStack equipped = player.func_71045_bC();
                    if (equipped == null) {
                        return null;
                    }
                    return new GuiSolderingIron(player, new ItemSolderingIron.SolderingInventory(player, equipped));
                }
            }
            for (IGuiHandler handler : PluginManager.guiHandlers) {
                Object element = handler.getClientGuiElement(id, player, world, x, y, z);
                if (element == null) continue;
                return element;
            }
            return null;
        }
        return null;
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        int cleanId = GuiHandler.decodeGuiID(id);
        if (cleanId < GuiId.values().length) {
            switch (GuiId.values()[cleanId]) {
                case AnalyzerGUI: {
                    return new ContainerAnalyzer(player.field_71071_by, GuiHandler.getTile(world, x, y, z, player, TileAnalyzer.class));
                }
                case NaturalistBenchGUI: {
                    return new ContainerEscritoire(player, GuiHandler.getTile(world, x, y, z, player, TileEscritoire.class));
                }
                case SolderingIronGUI: {
                    ItemStack equipped = player.func_71045_bC();
                    if (equipped == null) {
                        return null;
                    }
                    return new ContainerSolderingIron(player, new ItemSolderingIron.SolderingInventory(player, equipped));
                }
            }
            for (IGuiHandler handler : PluginManager.guiHandlers) {
                Object element = handler.getServerGuiElement(id, player, world, x, y, z);
                if (element == null) continue;
                return element;
            }
            return null;
        }
        return null;
    }
}

