/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.render;

import forestry.api.arboriculture.EnumWoodType;
import forestry.arboriculture.items.ItemBlockWood;
import forestry.arboriculture.render.IconProviderWood;
import forestry.core.utils.ItemStackUtil;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderLogItem
implements IItemRenderer {
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: 
            case EQUIPPED_FIRST_PERSON: 
            case EQUIPPED: 
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case ENTITY: {
                RenderLogItem.renderItem((RenderBlocks)data[0], item, 0.0f, 0.0f, 0.0f, true);
                break;
            }
            case EQUIPPED_FIRST_PERSON: 
            case EQUIPPED: {
                RenderLogItem.renderItem((RenderBlocks)data[0], item, 0.5f, 0.5f, 0.5f, true);
                break;
            }
            case INVENTORY: {
                RenderLogItem.renderItem((RenderBlocks)data[0], item, 0.0f, 0.0f, 0.0f, false);
                break;
            }
        }
    }

    private static void renderItem(RenderBlocks renderer, ItemStack itemStack, float x, float y, float z, boolean fullBlock) {
        Tessellator tessellator = Tessellator.field_78398_a;
        Block block = ItemStackUtil.getBlock(itemStack);
        if (!(itemStack.func_77973_b() instanceof ItemBlockWood) || block == null) {
            return;
        }
        EnumWoodType woodType = EnumWoodType.getFromCompound(itemStack.func_77978_p());
        IIcon barkIcon = IconProviderWood.getBarkIcon(woodType);
        IIcon heartIcon = IconProviderWood.getHeartIcon(woodType);
        if (barkIcon == null || heartIcon == null) {
            return;
        }
        GL11.glTranslatef((float)x, (float)y, (float)z);
        block.func_149683_g();
        renderer.func_147775_a(block);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, 0.0, 0.0, 0.0, heartIcon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, 0.0, 0.0, 0.0, barkIcon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, 0.0, 0.0, 0.0, barkIcon);
        tessellator.func_78381_a();
        if (fullBlock) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
            renderer.func_147768_a(block, 0.0, 0.0, 0.0, heartIcon);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
            renderer.func_147761_c(block, 0.0, 0.0, 0.0, barkIcon);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
            renderer.func_147764_f(block, 0.0, 0.0, 0.0, barkIcon);
            tessellator.func_78381_a();
        }
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }
}

