/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.Tabs;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import forestry.api.recipes.IVariableFermentable;
import forestry.arboriculture.genetics.Tree;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.arboriculture.genetics.TreeGenome;
import forestry.arboriculture.genetics.pollination.ICheckPollinatable;
import forestry.core.config.Config;
import forestry.core.genetics.ItemGE;
import forestry.core.network.PacketFXSignal;
import forestry.core.proxy.Proxies;
import forestry.core.render.SpriteSheet;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.StringUtil;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemGermlingGE
extends ItemGE
implements IVariableFermentable {
    private final EnumGermlingType type;

    public ItemGermlingGE(EnumGermlingType type) {
        this.type = type;
        this.func_77637_a(Tabs.tabArboriculture);
    }

    @Override
    public ITree getIndividual(ItemStack itemstack) {
        return new Tree(itemstack.func_77978_p());
    }

    @Override
    protected IAlleleTreeSpecies getSpecies(ItemStack itemStack) {
        return TreeGenome.getSpecies(itemStack);
    }

    private static IAlleleTreeSpecies getSpeciesOrDefault(ItemStack itemstack) {
        IAlleleTreeSpecies treeSpecies = TreeGenome.getSpecies(itemstack);
        if (treeSpecies == null) {
            treeSpecies = TreeDefinition.Oak.getGenome().getPrimary();
        }
        return treeSpecies;
    }

    @Override
    protected int getDefaultPrimaryColour() {
        return 0;
    }

    @Override
    protected int getDefaultSecondaryColour() {
        return 0;
    }

    public String func_77653_i(ItemStack itemstack) {
        if (!itemstack.func_77942_o()) {
            return "Unknown";
        }
        IAlleleTreeSpecies species = this.getSpecies(itemstack);
        String customTreeKey = "trees.custom." + this.type.getName() + "." + species.getUnlocalizedName().replace("trees.species.", "");
        if (StringUtil.canTranslate(customTreeKey)) {
            return StringUtil.localize(customTreeKey);
        }
        return StringUtil.localize("trees.grammar." + this.type.getName()).replaceAll("%SPECIES", species.getName()).replaceAll("%TYPE", StringUtil.localize("trees.grammar." + this.type.getName() + ".type"));
    }

    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        this.addCreativeItems(itemList, true);
    }

    public void addCreativeItems(List itemList, boolean hideSecrets) {
        for (IIndividual iIndividual : TreeManager.treeRoot.getIndividualTemplates()) {
            if (hideSecrets && iIndividual.isSecret() && !Config.isDebug) continue;
            itemList.add(TreeManager.treeRoot.getMemberStack(iIndividual, this.type.ordinal()));
        }
    }

    @Override
    public int func_82790_a(ItemStack itemstack, int renderPass) {
        return ItemGermlingGE.getSpeciesOrDefault(itemstack).getGermlingColour(this.type, renderPass);
    }

    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int metadata) {
        return 2;
    }

    public int func_94901_k() {
        return this.type == EnumGermlingType.SAPLING ? SpriteSheet.BLOCKS.getSheetOrdinal() : SpriteSheet.ITEMS.getSheetOrdinal();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack itemstack, int renderPass) {
        IAlleleTreeSpecies species = ItemGermlingGE.getSpeciesOrDefault(itemstack);
        return species.getGermlingIcon(this.type, renderPass);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        return this.getIcon(stack, 0);
    }

    public boolean func_77648_a(ItemStack itemstack, EntityPlayer player, World world, int x, int y, int z, int par7, float facingX, float facingY, float facingZ) {
        ITree tree = TreeManager.treeRoot.getMember(itemstack);
        if (tree == null) {
            return false;
        }
        if (this.type == EnumGermlingType.SAPLING) {
            int yShift;
            if (!BlockUtil.isReplaceableBlock(world, x, y, z)) {
                if (!world.func_147437_c(x, y + 1, z)) {
                    return false;
                }
                yShift = 1;
            } else {
                yShift = 0;
            }
            if (!tree.canStay(world, x, y + yShift, z)) {
                return false;
            }
            if (TreeManager.treeRoot.plantSapling(world, tree, player.func_146103_bH(), x, y + yShift, z)) {
                Proxies.common.addBlockPlaceEffects(world, x, y, z, world.func_147439_a(x, y + yShift, z), 0);
                if (!player.field_71075_bZ.field_75098_d) {
                    --itemstack.field_77994_a;
                }
                return true;
            }
            return false;
        }
        if (this.type == EnumGermlingType.POLLEN) {
            ICheckPollinatable checkPollinatable = GeneticsUtil.getCheckPollinatable(world, x, y, z);
            if (checkPollinatable == null) {
                return false;
            }
            if (!checkPollinatable.canMateWith(tree)) {
                return false;
            }
            IPollinatable pollinatable = GeneticsUtil.getOrCreatePollinatable(player.func_146103_bH(), world, x, y, z);
            if (!pollinatable.canMateWith(tree)) {
                return false;
            }
            pollinatable.mateWith(tree);
            Proxies.common.sendFXSignal(PacketFXSignal.VisualFXType.BLOCK_DESTROY, PacketFXSignal.SoundFXType.LEAF, world, x, y, z, world.func_147439_a(x, y, z), 0);
            if (!player.field_71075_bZ.field_75098_d) {
                --itemstack.field_77994_a;
            }
            return true;
        }
        return false;
    }

    @Override
    public float getFermentationModifier(ItemStack itemstack) {
        ITree tree = TreeManager.treeRoot.getMember(itemstack);
        if (tree == null) {
            return 1.0f;
        }
        return tree.getGenome().getSappiness() * 10.0f;
    }
}

