/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleRegistry;
import forestry.api.genetics.IClassification;
import forestry.arboriculture.genetics.BranchTrees;
import forestry.arboriculture.genetics.alleles.AlleleFruit;
import forestry.arboriculture.genetics.alleles.AlleleGrowth;
import forestry.arboriculture.genetics.alleles.AlleleLeafEffect;
import forestry.core.genetics.IBranchDefinition;
import forestry.core.genetics.alleles.AlleleHelper;
import forestry.core.genetics.alleles.AllelePlantType;
import forestry.core.genetics.alleles.EnumAllele;
import java.util.Arrays;
import java.util.Locale;
import org.apache.commons.lang3.text.WordUtils;

public enum TreeBranchDefinition implements IBranchDefinition
{
    ACACIA,
    ACER,
    ADANSONIA,
    ASTRONIUM,
    BETULA,
    CASTANEA,
    CEIBA,
    CHLOROCARDIUM,
    CITRUS,
    DALBERGIA,
    EBONY("Diospyros"),
    JUGLANS,
    LARIX,
    MAHOGANY("Shorea"),
    MILLETTIA,
    OCHROMA,
    PHOENIX,
    PICEA,
    PINUS,
    POPULUS,
    PRUNUS,
    PTEROCARPUS,
    QUERCUS,
    SALIX,
    SEQUOIA,
    SEQUOIADENDRON,
    TABEBUIA,
    TALIPARITI,
    TECTONA,
    TILIA,
    CARICA,
    TROPICAL("");

    private final IClassification branch;
    private static IAllele[] defaultTemplate;

    private TreeBranchDefinition() {
        String name = this.name().toLowerCase(Locale.ENGLISH);
        String scientific = WordUtils.capitalize((String)name);
        this.branch = new BranchTrees(name, scientific);
    }

    private TreeBranchDefinition(String scientific) {
        String name = this.name().toLowerCase(Locale.ENGLISH);
        this.branch = new BranchTrees(name, scientific);
    }

    @Override
    public IAllele[] getTemplate() {
        if (defaultTemplate == null) {
            defaultTemplate = new IAllele[EnumTreeChromosome.values().length];
            AlleleHelper.instance.set(defaultTemplate, EnumTreeChromosome.FRUITS, AlleleFruit.fruitNone);
            AlleleHelper.instance.set(defaultTemplate, EnumTreeChromosome.GROWTH, AlleleGrowth.growthLightlevel);
            AlleleHelper.instance.set(defaultTemplate, EnumTreeChromosome.HEIGHT, EnumAllele.Height.SMALL);
            AlleleHelper.instance.set(defaultTemplate, EnumTreeChromosome.FERTILITY, EnumAllele.Saplings.LOWER);
            AlleleHelper.instance.set(defaultTemplate, EnumTreeChromosome.YIELD, EnumAllele.Yield.LOWEST);
            AlleleHelper.instance.set(defaultTemplate, EnumTreeChromosome.PLANT, AllelePlantType.plantTypeNone);
            AlleleHelper.instance.set(defaultTemplate, EnumTreeChromosome.SAPPINESS, EnumAllele.Sappiness.LOWEST);
            AlleleHelper.instance.set(defaultTemplate, EnumTreeChromosome.TERRITORY, EnumAllele.Territory.AVERAGE);
            AlleleHelper.instance.set(defaultTemplate, EnumTreeChromosome.EFFECT, AlleleLeafEffect.leavesNone);
            AlleleHelper.instance.set(defaultTemplate, EnumTreeChromosome.MATURATION, EnumAllele.Maturation.AVERAGE);
            AlleleHelper.instance.set(defaultTemplate, EnumTreeChromosome.GIRTH, 1);
            AlleleHelper.instance.set(defaultTemplate, EnumTreeChromosome.FIREPROOF, EnumAllele.Fireproof.FALSE);
        }
        return Arrays.copyOf(defaultTemplate, defaultTemplate.length);
    }

    @Override
    public IClassification getBranch() {
        return this.branch;
    }

    public static void createAlleles() {
        IAlleleRegistry alleleRegistry = AlleleManager.alleleRegistry;
        IClassification plantae = alleleRegistry.getClassification("kingdom.plantae");
        plantae.addMemberGroup(alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.DIVISION, "angiosperms", "Angiosperms", alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.CLASS, "asterids", "Asterids", alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "ericales", "Ericales", alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "ebenaceae", "Ebenaceae", EBONY.getBranch()), alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "fabaceae", "Fabaceae", ACACIA.getBranch(), DALBERGIA.getBranch(), MILLETTIA.getBranch(), PTEROCARPUS.getBranch())), alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "lamiales", "Lamiales", alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "bignoniaceae", "Bignoniaceae", TABEBUIA.getBranch()), alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "lamiaceae", "Lamiaceae", TECTONA.getBranch()))), alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.CLASS, "commelinids", "Commelinids", alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "arecales", "Arecales", alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "arecaceae", "Arecaceae", PHOENIX.getBranch()))), alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.CLASS, "rosids", "Rosids", alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "brassicales", "Brassicales", alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "caricaceae", "Caricaceae")), alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "fabales", "Fabales"), alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "fagales", "Fagales", alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "betulaceae", "Betulaceae", BETULA.getBranch()), alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "fagaceae", "Fagaceae", CASTANEA.getBranch(), QUERCUS.getBranch()), alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "juglandaceae", "Juglandaceae", JUGLANS.getBranch())), alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "rosales", "Rosales", alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "rosaceae", "Rosaceae", PRUNUS.getBranch())), alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "malvales", "Malvales", alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "dipterocarpaceae", "Dipterocarpaceae", MAHOGANY.getBranch()), alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "malvaceae", "Malvaceae", ADANSONIA.getBranch(), CEIBA.getBranch(), OCHROMA.getBranch(), TALIPARITI.getBranch(), TILIA.getBranch())), alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "laurales", "Laurales"), alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "malpighiales", "Malpighiales", alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "salicaceae", "Salicaceae", CHLOROCARDIUM.getBranch(), POPULUS.getBranch(), SALIX.getBranch()), alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "lauraceae", "Lauraceae")), alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "sapindales", "Sapindales", alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "rutaceae", "Rutaceae", CITRUS.getBranch()), alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "sapindaceae", "Sapindaceae", ACER.getBranch()), alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "anacardiaceae", "Anacardiaceae", ASTRONIUM.getBranch())))));
        plantae.addMemberGroup(alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.DIVISION, "pinophyta", "Pinophyta", alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.CLASS, "pinopsida", "Pinopsida", alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "pinales", "Pinales", alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "pinaceae", "Pinaceae", PICEA.getBranch(), PINUS.getBranch(), LARIX.getBranch()), alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "cupressaceae", "Cupressaceae", SEQUOIA.getBranch(), SEQUOIADENDRON.getBranch()))), alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.CLASS, "magnoliopsida", "Magnoliopsida")));
        plantae.addMemberGroup(alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.DIVISION, "magnoliophyta", "Magnoliophyta"));
    }
}

