/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import forestry.api.arboriculture.EnumWoodType;
import forestry.api.arboriculture.IWoodItemAccess;
import java.util.EnumMap;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class WoodItemAccess
implements IWoodItemAccess {
    private static final EnumMap<EnumWoodType, ItemStack> logs = new EnumMap(EnumWoodType.class);
    private static final EnumMap<EnumWoodType, ItemStack> logsFireproof = new EnumMap(EnumWoodType.class);
    private static final EnumMap<EnumWoodType, ItemStack> planks = new EnumMap(EnumWoodType.class);
    private static final EnumMap<EnumWoodType, ItemStack> planksFireproof = new EnumMap(EnumWoodType.class);
    private static final EnumMap<EnumWoodType, ItemStack> slabs = new EnumMap(EnumWoodType.class);
    private static final EnumMap<EnumWoodType, ItemStack> slabsFireproof = new EnumMap(EnumWoodType.class);
    private static final EnumMap<EnumWoodType, ItemStack> fences = new EnumMap(EnumWoodType.class);
    private static final EnumMap<EnumWoodType, ItemStack> fencesFireproof = new EnumMap(EnumWoodType.class);
    private static final EnumMap<EnumWoodType, ItemStack> stairs = new EnumMap(EnumWoodType.class);
    private static final EnumMap<EnumWoodType, ItemStack> stairsFireproof = new EnumMap(EnumWoodType.class);

    private static ItemStack getStack(EnumWoodType woodType, Block block) {
        NBTTagCompound woodNBT = new NBTTagCompound();
        woodType.saveToCompound(woodNBT);
        ItemStack itemStack = new ItemStack(block);
        itemStack.func_77982_d(woodNBT);
        return itemStack;
    }

    public static void registerLog(Block block, EnumWoodType woodType, boolean fireproof) {
        ItemStack itemStack = WoodItemAccess.getStack(woodType, block);
        if (fireproof) {
            logsFireproof.put(woodType, itemStack);
        } else {
            logs.put(woodType, itemStack);
        }
    }

    public static void registerPlanks(Block block, EnumWoodType woodType, boolean fireproof) {
        ItemStack itemStack = WoodItemAccess.getStack(woodType, block);
        if (fireproof) {
            planksFireproof.put(woodType, itemStack);
        } else {
            planks.put(woodType, itemStack);
        }
    }

    public static void registerSlab(Block block, EnumWoodType woodType, boolean fireproof) {
        ItemStack itemStack = WoodItemAccess.getStack(woodType, block);
        if (fireproof) {
            slabsFireproof.put(woodType, itemStack);
        } else {
            slabs.put(woodType, itemStack);
        }
    }

    public static void registerFence(Block block, EnumWoodType woodType, boolean fireproof) {
        ItemStack itemStack = WoodItemAccess.getStack(woodType, block);
        if (fireproof) {
            fencesFireproof.put(woodType, itemStack);
        } else {
            fences.put(woodType, itemStack);
        }
    }

    public static void registerStairs(Block block, EnumWoodType woodType, boolean fireproof) {
        ItemStack itemStack = WoodItemAccess.getStack(woodType, block);
        if (fireproof) {
            stairsFireproof.put(woodType, itemStack);
        } else {
            stairs.put(woodType, itemStack);
        }
    }

    @Override
    public ItemStack getPlanks(EnumWoodType woodType, boolean fireproof) {
        if (fireproof) {
            return planksFireproof.get((Object)woodType).func_77946_l();
        }
        return planks.get((Object)woodType).func_77946_l();
    }

    @Override
    public ItemStack getLog(EnumWoodType woodType, boolean fireproof) {
        if (fireproof) {
            return logsFireproof.get((Object)woodType).func_77946_l();
        }
        return logs.get((Object)woodType).func_77946_l();
    }

    @Override
    public ItemStack getSlab(EnumWoodType woodType, boolean fireproof) {
        if (fireproof) {
            return slabsFireproof.get((Object)woodType).func_77946_l();
        }
        return slabs.get((Object)woodType).func_77946_l();
    }

    @Override
    public ItemStack getFence(EnumWoodType woodType, boolean fireproof) {
        if (fireproof) {
            return fencesFireproof.get((Object)woodType).func_77946_l();
        }
        return fences.get((Object)woodType).func_77946_l();
    }

    @Override
    public ItemStack getStairs(EnumWoodType woodType, boolean fireproof) {
        if (fireproof) {
            return stairsFireproof.get((Object)woodType).func_77946_l();
        }
        return stairs.get((Object)woodType).func_77946_l();
    }
}

