/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.tiles;

import forestry.api.apiculture.DefaultBeeListener;
import forestry.api.apiculture.DefaultBeeModifier;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.core.ForestryAPI;
import forestry.apiculture.tiles.TileAbstractBeeHousing;
import forestry.core.network.GuiId;
import java.util.Collections;
import net.minecraft.entity.player.EntityPlayer;

public class TileBeehouse
extends TileAbstractBeeHousing {
    private static final IBeeModifier beeModifier = new BeehouseBeeModifier();
    private final IBeeListener beeListener = new DefaultBeeListener();
    private final IBeeHousingInventory beeInventory;

    public TileBeehouse() {
        TileAbstractBeeHousing.TileBeeHousingInventory beeHousingInventory = new TileAbstractBeeHousing.TileBeeHousingInventory(this, 12, "Items");
        beeHousingInventory.disableAutomation();
        this.beeInventory = beeHousingInventory;
        this.setInternalInventory(beeHousingInventory);
    }

    @Override
    public IBeeHousingInventory getBeeInventory() {
        return this.beeInventory;
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, GuiId.BeehouseGUI.ordinal(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public Iterable<IBeeModifier> getBeeModifiers() {
        return Collections.singleton(beeModifier);
    }

    @Override
    public Iterable<IBeeListener> getBeeListeners() {
        return Collections.singleton(this.beeListener);
    }

    public static class BeehouseBeeModifier
    extends DefaultBeeModifier {
        @Override
        public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
            return 1.0f;
        }

        @Override
        public float getProductionModifier(IBeeGenome genome, float currentModifier) {
            return 0.25f;
        }

        @Override
        public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
            return 0.0f;
        }

        @Override
        public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
            return 3.0f;
        }

        @Override
        public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
            return 3.0f;
        }

        @Override
        public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
            return 0.0f;
        }
    }
}

