/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.tiles;

import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.apiculture.BeeHousingInventory;
import forestry.core.config.Config;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.IClimatised;
import forestry.core.tiles.TileBase;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public abstract class TileAbstractBeeHousing
extends TileBase
implements IBeeHousing,
IClimatised {
    private final IBeekeepingLogic beeLogic;
    private BiomeGenBase cachedBiome;
    private int breedingProgressPercent = 0;

    protected TileAbstractBeeHousing() {
        this.setHints(Config.hints.get("apiary"));
        this.beeLogic = BeeManager.beeRoot.createBeekeepingLogic(this);
    }

    @Override
    public IBeekeepingLogic getBeekeepingLogic() {
        return this.beeLogic;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        this.beeLogic.writeToNBT(nbttagcompound);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.beeLogic.readFromNBT(nbttagcompound);
    }

    @Override
    public Packet func_145844_m() {
        this.beeLogic.syncToClient();
        return super.func_145844_m();
    }

    @Override
    public EnumTemperature getTemperature() {
        return EnumTemperature.getFromBiome(this.getBiome(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue(this.getExactHumidity());
    }

    @Override
    public float getExactTemperature() {
        return this.getBiome().func_150564_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public float getExactHumidity() {
        return this.getBiome().field_76751_G;
    }

    @Override
    public void updateClientSide() {
        if (this.beeLogic.canDoBeeFX() && this.updateOnInterval(4)) {
            this.beeLogic.doBeeFX();
            if (this.updateOnInterval(50)) {
                float fxX = (float)this.field_145851_c + 0.5f;
                float fxY = (float)this.field_145848_d + 0.25f;
                float fxZ = (float)this.field_145849_e + 0.5f;
                float distanceFromCenter = 0.6f;
                float leftRightSpreadFromCenter = distanceFromCenter * (this.field_145850_b.field_73012_v.nextFloat() - 0.5f);
                float upSpread = this.field_145850_b.field_73012_v.nextFloat() * 6.0f / 16.0f;
                Proxies.render.addEntitySwarmFX(this.field_145850_b, fxX - distanceFromCenter, fxY += upSpread, fxZ + leftRightSpreadFromCenter);
                Proxies.render.addEntitySwarmFX(this.field_145850_b, fxX + distanceFromCenter, fxY, fxZ + leftRightSpreadFromCenter);
                Proxies.render.addEntitySwarmFX(this.field_145850_b, fxX + leftRightSpreadFromCenter, fxY, fxZ - distanceFromCenter);
                Proxies.render.addEntitySwarmFX(this.field_145850_b, fxX + leftRightSpreadFromCenter, fxY, fxZ + distanceFromCenter);
            }
        }
    }

    @Override
    public void updateServerSide() {
        if (this.beeLogic.canWork()) {
            this.beeLogic.doWork();
        }
    }

    public int getHealthScaled(int i) {
        return this.breedingProgressPercent * i / 100;
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.breedingProgressPercent = j;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        iCrafting.func_71112_a(container, 0, this.beeLogic.getBeeProgressPercent());
    }

    @Override
    public BiomeGenBase getBiome() {
        if (this.cachedBiome == null) {
            this.cachedBiome = this.field_145850_b.getBiomeGenForCoordsBody(this.field_145851_c, this.field_145849_e);
        }
        return this.cachedBiome;
    }

    @Override
    public int getBlockLightValue() {
        return this.field_145850_b.func_72957_l(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
    }

    @Override
    public boolean canBlockSeeTheSky() {
        return this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
    }

    @Override
    public GameProfile getOwner() {
        return this.getAccessHandler().getOwner();
    }

    @Override
    public World getWorld() {
        return this.field_145850_b;
    }

    public static class TileBeeHousingInventory
    extends BeeHousingInventory {
        private final TileAbstractBeeHousing tile;

        public TileBeeHousingInventory(TileAbstractBeeHousing tile, int size, String name) {
            super(size, name, tile.getAccessHandler());
            this.tile = tile;
        }

        @Override
        public void func_70296_d() {
            super.func_70296_d();
            this.tile.func_70296_d();
        }
    }
}

