/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.network;

import forestry.apiculture.tiles.TileCandle;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IPacketId;
import forestry.core.network.PacketCoordinates;
import forestry.core.network.PacketIdClient;
import forestry.core.proxy.Proxies;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;

public class PacketCandleUpdate
extends PacketCoordinates
implements IForestryPacketClient {
    private int colour;
    private boolean lit;

    public PacketCandleUpdate() {
    }

    public PacketCandleUpdate(TileCandle tileCandle) {
        super((IPacketId)PacketIdClient.CANDLE_UPDATE, tileCandle);
        this.colour = tileCandle.getColour();
        this.lit = tileCandle.isLit();
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeInt(this.colour);
        data.writeBoolean(this.lit);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.colour = data.readInt();
        this.lit = data.readBoolean();
    }

    @Override
    public void onPacketData(DataInputStreamForestry data, EntityPlayer player) throws IOException {
        TileEntity tileEntity = this.getTarget(Proxies.common.getRenderWorld());
        if (tileEntity instanceof TileCandle) {
            ((TileCandle)tileEntity).onPacketUpdate(this.colour, this.lit);
        }
    }
}

