/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.multiblock;

import forestry.api.core.ForestryAPI;
import forestry.apiculture.multiblock.TileAlveary;
import forestry.core.access.AccessHandler;
import forestry.core.access.EnumAccess;
import forestry.core.access.IAccessHandler;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.tiles.IRestrictedAccessTile;
import forestry.core.tiles.ITitled;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;

public abstract class TileAlvearyWithGui
extends TileAlveary
implements ITitled,
IRestrictedAccessTile {
    private final AccessHandler accessHandler = new AccessHandler(this);
    private final String unlocalizedTitle;
    private final GuiId guiId;

    protected TileAlvearyWithGui(int meta, GuiId guiId) {
        this.unlocalizedTitle = "alveary." + meta + ".name";
        this.guiId = guiId;
    }

    @Override
    public final IAccessHandler getAccessHandler() {
        return this.accessHandler;
    }

    @Override
    public final ChunkCoordinates getCoordinates() {
        return new ChunkCoordinates(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void onSwitchAccess(EnumAccess oldAccess, EnumAccess newAccess) {
        if (oldAccess == EnumAccess.SHARED || newAccess == EnumAccess.SHARED) {
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145854_h);
            this.func_70296_d();
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.accessHandler.writeToNBT(data);
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.accessHandler.readFromNBT(data);
    }

    @Override
    public void writeGuiData(DataOutputStreamForestry data) throws IOException {
        this.accessHandler.writeData(data);
    }

    @Override
    public void readGuiData(DataInputStreamForestry data) throws IOException {
        this.accessHandler.readData(data);
    }

    @Override
    public final String getUnlocalizedTitle() {
        return this.unlocalizedTitle;
    }

    @Override
    public final void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, this.guiId.ordinal(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

