/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBee;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorSource;
import forestry.api.core.IErrorState;
import forestry.api.core.Tabs;
import forestry.api.genetics.AlleleManager;
import forestry.apiculture.network.PacketHabitatBiomePointer;
import forestry.apiculture.render.TextureHabitatLocator;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.errors.EnumErrorCode;
import forestry.core.gui.IHintSource;
import forestry.core.inventory.ItemInventory;
import forestry.core.items.ItemInventoried;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StringUtil;
import forestry.core.utils.vect.Vect;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class ItemHabitatLocator
extends ItemInventoried {
    private static final String iconName = "forestry:biomefinder";
    private Set<BiomeGenBase> targetBiomes = new HashSet<BiomeGenBase>();
    private boolean biomeFound = false;
    private int searchRadiusIteration = 0;
    private int searchAngleIteration = 0;
    private Vect searchCenter;
    private static final Set<BiomeGenBase> waterBiomes = new HashSet<BiomeGenBase>();
    private static final Set<BiomeGenBase> netherBiomes = new HashSet<BiomeGenBase>();
    private static final Set<BiomeGenBase> endBiomes = new HashSet<BiomeGenBase>();

    public ItemHabitatLocator() {
        this.func_77625_d(1);
        this.func_77637_a(Tabs.tabApiculture);
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (!world.field_72995_K) {
            entityplayer.openGui(ForestryAPI.instance, GuiId.HabitatLocatorGUI.ordinal(), world, (int)entityplayer.field_70165_t, (int)entityplayer.field_70163_u, (int)entityplayer.field_70161_v);
        }
        return itemstack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        if (register instanceof TextureMap) {
            TextureHabitatLocator texture = new TextureHabitatLocator(iconName);
            ((TextureMap)register).setTextureEntry(iconName, (TextureAtlasSprite)texture);
            this.field_77791_bV = texture;
        }
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean flag) {
        BiomeGenBase currentBiome = player.field_70170_p.func_72807_a((int)player.field_70165_t, (int)player.field_70161_v);
        float temperatureValue = currentBiome.func_150564_a((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        EnumTemperature temperature = EnumTemperature.getFromValue(temperatureValue);
        EnumHumidity humidity = EnumHumidity.getFromValue(currentBiome.field_76751_G);
        list.add(StringUtil.localize("gui.currentBiome") + ": " + currentBiome.field_76791_y);
        list.add(StringUtil.localize("gui.temperature") + ": " + AlleleManager.climateHelper.toDisplay(temperature));
        list.add(StringUtil.localize("gui.humidity") + ": " + AlleleManager.climateHelper.toDisplay(humidity));
    }

    private void startBiomeSearch(IBee bee, EntityPlayer player) {
        this.targetBiomes = new HashSet<BiomeGenBase>(bee.getSuitableBiomes());
        this.searchAngleIteration = 0;
        this.searchRadiusIteration = 0;
        this.biomeFound = false;
        this.searchCenter = new Vect((Entity)player);
        BiomeGenBase currentBiome = player.field_70170_p.func_72807_a(this.searchCenter.x, this.searchCenter.z);
        ItemHabitatLocator.removeInvalidBiomes(currentBiome, this.targetBiomes);
        Proxies.render.setHabitatLocatorTexture(null, null);
    }

    public void func_77663_a(ItemStack p_77663_1_, World world, Entity player, int p_77663_4_, boolean p_77663_5_) {
        if (world.field_72995_K) {
            return;
        }
        if (this.targetBiomes.isEmpty()) {
            return;
        }
        if (this.biomeFound && world.func_82737_E() % 20L != 0L) {
            return;
        }
        ChunkCoordinates target = this.findNearestBiome(player, this.targetBiomes);
        if (target != null && player instanceof EntityPlayerMP) {
            Proxies.net.sendToPlayer(new PacketHabitatBiomePointer(target), (EntityPlayer)((EntityPlayerMP)player));
            this.biomeFound = true;
        }
    }

    private ChunkCoordinates findNearestBiome(Entity player, Collection<BiomeGenBase> biomesToSearch) {
        int maxChecksPerTick = 100;
        int maxSearchRadiusIterations = 500;
        int spacing = 20;
        Vect playerPos = new Vect(player);
        ChunkCoordinates coordinates = ItemHabitatLocator.getChunkCoordinates(playerPos, player.field_70170_p, biomesToSearch);
        if (coordinates != null) {
            this.searchAngleIteration = 0;
            this.searchRadiusIteration = 0;
            return new ChunkCoordinates(playerPos.x, playerPos.y, playerPos.z);
        }
        int radius = 20 * (this.searchRadiusIteration + 1);
        double angleSpacing = 2.0 * Math.asin(20.0 / (2.0 * (double)radius));
        angleSpacing = Math.PI * 2 / (double)Math.round(Math.PI * 2 / angleSpacing);
        for (int i = 0; i < 100; ++i) {
            int zOffset;
            double angle = angleSpacing * (double)this.searchAngleIteration;
            if (angle > Math.PI * 2) {
                this.searchAngleIteration = 0;
                ++this.searchRadiusIteration;
                if (this.searchRadiusIteration > 500) {
                    this.searchAngleIteration = 0;
                    this.searchRadiusIteration = 0;
                    this.searchCenter = playerPos;
                }
                return null;
            }
            ++this.searchAngleIteration;
            int xOffset = Math.round((float)((double)radius * Math.cos(angle)));
            Vect pos = this.searchCenter.add(xOffset, 0, zOffset = Math.round((float)((double)radius * Math.sin(angle))));
            coordinates = ItemHabitatLocator.getChunkCoordinates(pos, player.field_70170_p, biomesToSearch);
            if (coordinates == null) continue;
            this.searchAngleIteration = 0;
            this.searchRadiusIteration = 0;
            return coordinates;
        }
        return null;
    }

    private static ChunkCoordinates getChunkCoordinates(Vect pos, World world, Collection<BiomeGenBase> biomesToSearch) {
        int minBiomeRadius = 8;
        BiomeGenBase biome = world.func_72807_a(pos.x, pos.z);
        if (!biomesToSearch.contains(biome)) {
            return null;
        }
        biome = world.func_72807_a(pos.x - 8, pos.z);
        if (!biomesToSearch.contains(biome)) {
            return null;
        }
        biome = world.func_72807_a(pos.x + 8, pos.z);
        if (!biomesToSearch.contains(biome)) {
            return null;
        }
        biome = world.func_72807_a(pos.x, pos.z - 8);
        if (!biomesToSearch.contains(biome)) {
            return null;
        }
        biome = world.func_72807_a(pos.x, pos.z + 8);
        if (!biomesToSearch.contains(biome)) {
            return null;
        }
        return new ChunkCoordinates(pos.x, pos.y, pos.z);
    }

    private static void removeInvalidBiomes(BiomeGenBase currentBiome, Set<BiomeGenBase> biomesToSearch) {
        biomesToSearch.removeAll(waterBiomes);
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)currentBiome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
            biomesToSearch.retainAll(netherBiomes);
        } else {
            biomesToSearch.removeAll(netherBiomes);
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)currentBiome, (BiomeDictionary.Type)BiomeDictionary.Type.END)) {
            biomesToSearch.retainAll(endBiomes);
        } else {
            biomesToSearch.removeAll(endBiomes);
        }
    }

    static {
        Collections.addAll(waterBiomes, BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.BEACH));
        Collections.addAll(waterBiomes, BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN));
        Collections.addAll(waterBiomes, BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.RIVER));
        Collections.addAll(netherBiomes, BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.NETHER));
        Collections.addAll(endBiomes, BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.END));
    }

    public static class HabitatLocatorInventory
    extends ItemInventory
    implements IErrorSource,
    IHintSource {
        private static final short SLOT_ENERGY = 2;
        private static final short SLOT_SPECIMEN = 0;
        private static final short SLOT_ANALYZED = 1;
        private final ItemHabitatLocator habitatLocator;

        public HabitatLocatorInventory(EntityPlayer player, ItemStack itemstack) {
            super(player, 3, itemstack);
            this.habitatLocator = (ItemHabitatLocator)itemstack.func_77973_b();
        }

        private static boolean isEnergy(ItemStack itemstack) {
            if (itemstack == null || itemstack.field_77994_a <= 0) {
                return false;
            }
            return ForestryItem.honeyDrop.isItemEqual(itemstack) || ForestryItem.honeydew.isItemEqual(itemstack);
        }

        @Override
        public void onSlotClick(EntityPlayer player) {
            IBee bee;
            if (this.func_70301_a(1) != null) {
                if (this.habitatLocator.biomeFound) {
                    return;
                }
            } else if (this.func_70301_a(0) != null) {
                if (!HabitatLocatorInventory.isEnergy(this.func_70301_a(2))) {
                    return;
                }
                this.func_70298_a(2, 1);
                this.func_70299_a(1, this.func_70301_a(0));
                this.func_70299_a(0, null);
            }
            if ((bee = BeeManager.beeRoot.getMember(this.func_70301_a(1))) == null) {
                return;
            }
            this.habitatLocator.startBiomeSearch(bee, player);
        }

        public Set<BiomeGenBase> getBiomesToSearch() {
            return this.habitatLocator.targetBiomes;
        }

        @Override
        public boolean hasHints() {
            return Config.hints.get("habitatlocator") != null && Config.hints.get("habitatlocator").length > 0;
        }

        @Override
        public String[] getHints() {
            return Config.hints.get("habitatlocator");
        }

        @Override
        public ImmutableSet<IErrorState> getErrorStates() {
            if (this.func_70301_a(1) != null) {
                return ImmutableSet.of();
            }
            ImmutableSet.Builder errorStates = ImmutableSet.builder();
            ItemStack specimen = this.func_70301_a(0);
            if (!BeeManager.beeRoot.isMember(specimen)) {
                errorStates.add((Object)EnumErrorCode.NOTHINGANALYZE);
            }
            if (!HabitatLocatorInventory.isEnergy(this.func_70301_a(2))) {
                errorStates.add((Object)EnumErrorCode.NOHONEY);
            }
            return errorStates.build();
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (slotIndex == 2) {
                Item item = itemStack.func_77973_b();
                return item == ForestryItem.honeydew.item() || item == ForestryItem.honeyDrop.item();
            }
            if (slotIndex == 0) {
                return BeeManager.beeRoot.isMember(itemStack);
            }
            return false;
        }
    }
}

