/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.blocks.BlockAlveary;
import forestry.apiculture.genetics.alleles.AlleleEffectThrottled;
import forestry.apiculture.multiblock.TileAlveary;
import forestry.core.utils.DamageSourceForestry;
import forestry.core.utils.vect.Vect;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class AlleleEffectRadioactive
extends AlleleEffectThrottled {
    private static final DamageSource damageSourceBeeRadioactive = new DamageSourceForestry("bee.radioactive");

    public AlleleEffectRadioactive() {
        super("radioactive", true, 40, false, true);
    }

    @Override
    public IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorld();
        int[] areaAr = genome.getTerritory();
        Vect area = new Vect(areaAr).multiply(2);
        Vect offset = area.multiply(-0.5f);
        Vect min = new Vect(housing.getCoordinates()).add(offset);
        Vect max = min.add(area);
        AxisAlignedBB hurtBox = AxisAlignedBB.func_72330_a((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
        List list = housing.getWorld().func_72872_a(EntityLivingBase.class, hurtBox);
        for (Object obj : list) {
            EntityLivingBase entity = (EntityLivingBase)obj;
            int damage = 8;
            if (entity instanceof EntityPlayer) {
                int count = BeeManager.armorApiaristHelper.wearsItems((EntityPlayer)entity, this.getUID(), true);
                if (count > 3) continue;
                if (count > 2) {
                    damage = 1;
                } else if (count > 1) {
                    damage = 2;
                } else if (count > 0) {
                    damage = 3;
                }
            }
            entity.func_70097_a(damageSourceBeeRadioactive, (float)damage);
        }
        Random rand = housing.getWorld().field_73012_v;
        for (int i = 0; i < 20; ++i) {
            TileEntity tile;
            Block block;
            Vect randomPos = Vect.getRandomPositionInArea(rand, area);
            Vect posHousing = new Vect(housing.getCoordinates());
            Vect posBlock = randomPos.add(posHousing);
            posBlock = posBlock.add(offset);
            if (posBlock.y <= 1 || posBlock.y >= housing.getWorld().func_72940_L() || posBlock.x == posHousing.x && posBlock.z == posHousing.z && posBlock.y <= posHousing.y || world.func_147437_c(posBlock.x, posBlock.y, posBlock.z) || (block = world.func_147439_a(posBlock.x, posBlock.y, posBlock.z)) instanceof BlockAlveary || (tile = world.func_147438_o(posBlock.x, posBlock.y, posBlock.z)) instanceof IBeeHousing || tile instanceof TileAlveary || block.func_149712_f(world, posBlock.x, posBlock.y, posBlock.z) < 0.0f) continue;
            world.func_147468_f(posBlock.x, posBlock.y, posBlock.z);
            break;
        }
        return storedData;
    }
}

