/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.alleles.AlleleEffectThrottled;
import forestry.core.genetics.EffectData;
import forestry.core.utils.vect.Vect;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;

public class AlleleEffectFungification
extends AlleleEffectThrottled {
    private static final int MAX_BLOCK_FIND_TRIES = 10;
    private static final int ENTITY_THROTTLE = 6;

    public AlleleEffectFungification() {
        super("mycophilic", true, 10, false, false);
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (storedData instanceof EffectData && ((EffectData)storedData).getIntSize() == 2) {
            return storedData;
        }
        return new EffectData(2, 0);
    }

    @Override
    public IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        this.doBlockEffect(genome, housing);
        int entityThrottle = storedData.getInteger(1);
        if (entityThrottle >= 6) {
            this.doEntityEffect(genome, housing);
            entityThrottle = 0;
        } else {
            ++entityThrottle;
        }
        storedData.setInteger(1, entityThrottle);
        return storedData;
    }

    private void doBlockEffect(IBeeGenome genome, IBeeHousing housing) {
        World world = housing.getWorld();
        ChunkCoordinates housingCoordinates = housing.getCoordinates();
        Vect area = this.getModifiedArea(genome, housing);
        int blockX = AlleleEffectFungification.getRandomOffset(world.field_73012_v, housingCoordinates.field_71574_a, area.getX());
        int blockY = AlleleEffectFungification.getRandomOffset(world.field_73012_v, housingCoordinates.field_71572_b, area.getY());
        int blockZ = AlleleEffectFungification.getRandomOffset(world.field_73012_v, housingCoordinates.field_71573_c, area.getZ());
        for (int attempt = 0; attempt < 10; ++attempt) {
            Block block = world.func_147439_a(blockX, blockY, blockZ);
            if (AlleleEffectFungification.isSuitableForMycelium(world, block, blockX, blockY, blockZ)) {
                world.func_147449_b(blockX, blockY, blockZ, (Block)Blocks.field_150391_bh);
                break;
            }
            if (AlleleEffectFungification.isSuitableForGrowth(block)) {
                AlleleEffectFungification.doMushroomGrowth(block, world, blockX, blockY, blockZ);
                break;
            }
            blockX = AlleleEffectFungification.getRandomOffset(world.field_73012_v, housingCoordinates.field_71574_a, area.getX());
            blockY = AlleleEffectFungification.getRandomOffset(world.field_73012_v, housingCoordinates.field_71572_b, area.getY());
            blockZ = AlleleEffectFungification.getRandomOffset(world.field_73012_v, housingCoordinates.field_71573_c, area.getZ());
        }
    }

    private void doEntityEffect(IBeeGenome genome, IBeeHousing housing) {
        AxisAlignedBB aabb = this.getBounding(genome, housing);
        World world = housing.getWorld();
        List entities = world.func_72872_a(EntityCow.class, aabb);
        for (Object entity : entities) {
            if (!(entity instanceof EntityCow) || entity instanceof EntityMooshroom) continue;
            AlleleEffectFungification.convertCowToMooshroom((EntityCow)entity);
            break;
        }
    }

    private static int getRandomOffset(Random random, int centrePos, int offset) {
        return centrePos + random.nextInt(offset) - offset / 2;
    }

    private static boolean isSuitableForMycelium(World world, Block block, int blockX, int blockY, int blockZ) {
        return block == Blocks.field_150349_c || block == Blocks.field_150346_d && world.func_72937_j(blockX, blockY, blockZ);
    }

    private static boolean isSuitableForGrowth(Block block) {
        return block == Blocks.field_150337_Q || block == Blocks.field_150338_P;
    }

    private static void convertCowToMooshroom(EntityCow cow) {
        World worldObj = cow.field_70170_p;
        cow.func_70106_y();
        EntityMooshroom mooshroom = new EntityMooshroom(worldObj);
        mooshroom.func_70012_b(cow.field_70165_t, cow.field_70163_u, cow.field_70161_v, cow.field_70177_z, cow.field_70125_A);
        mooshroom.func_70606_j(cow.func_110143_aJ());
        mooshroom.field_70761_aq = cow.field_70761_aq;
        worldObj.func_72838_d((Entity)mooshroom);
        worldObj.func_72869_a("largeexplode", cow.field_70165_t, cow.field_70163_u + (double)(cow.field_70131_O / 2.0f), cow.field_70161_v, 0.0, 0.0, 0.0);
    }

    private static void doMushroomGrowth(Block block, World world, int blockX, int blockY, int blockZ) {
        WorldGenBigMushroom giantMushroomGenerator = block == Blocks.field_150338_P ? new WorldGenBigMushroom(0) : new WorldGenBigMushroom(1);
        world.func_147468_f(blockX, blockY, blockZ);
        giantMushroomGenerator.func_76484_a(world, world.field_73012_v, blockX, blockY, blockZ);
    }
}

