/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.alleles.AlleleEffectThrottled;
import forestry.core.genetics.EffectData;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class AlleleEffectCreeper
extends AlleleEffectThrottled {
    private static final int explosionChance = 50;
    private static final byte defaultForce = 12;
    private static final byte indexExplosionTimer = 1;
    private static final byte indexExplosionForce = 2;

    public AlleleEffectCreeper() {
        super("creeper", true, 20, false, true);
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (!(storedData instanceof EffectData)) {
            return new EffectData(3, 0);
        }
        if (((EffectData)storedData).getIntSize() < 3) {
            return new EffectData(3, 0);
        }
        return storedData;
    }

    @Override
    public IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorld();
        ChunkCoordinates housingCoords = housing.getCoordinates();
        if (storedData.getInteger(1) > 0) {
            AlleleEffectCreeper.progressExplosion(storedData, world, housingCoords.field_71574_a, housingCoords.field_71572_b, housingCoords.field_71573_c);
            return storedData;
        }
        AxisAlignedBB infectionBox = this.getBounding(genome, housing);
        List list = world.func_72872_a(EntityPlayer.class, infectionBox);
        for (Object obj : list) {
            EntityPlayer player = (EntityPlayer)obj;
            int chance = 50;
            storedData.setInteger(2, 12);
            int count = BeeManager.armorApiaristHelper.wearsItems(player, this.getUID(), true);
            if (count > 3) continue;
            if (count > 2) {
                chance = 5;
                storedData.setInteger(2, 6);
            } else if (count > 1) {
                chance = 20;
                storedData.setInteger(2, 8);
            } else if (count > 0) {
                chance = 35;
                storedData.setInteger(2, 10);
            }
            if (world.field_73012_v.nextInt(1000) >= chance) continue;
            world.func_72908_a((double)housingCoords.field_71574_a, (double)housingCoords.field_71572_b, (double)housingCoords.field_71573_c, "mob.creeper", 4.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            storedData.setInteger(1, 2);
        }
        return storedData;
    }

    private static void progressExplosion(IEffectData storedData, World world, int x, int y, int z) {
        int explosionTimer = storedData.getInteger(1);
        storedData.setInteger(1, --explosionTimer);
        if (explosionTimer > 0) {
            return;
        }
        world.func_72876_a(null, (double)x, (double)y, (double)z, (float)storedData.getInteger(2), false);
    }
}

