/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.FlowerManager;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.core.INBTTagable;
import forestry.api.genetics.IFlowerProvider;
import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class HasFlowersCache
implements INBTTagable {
    private static final String nbtKey = "hasFlowerCache";
    private static final Random random = new Random();
    private static final int flowerCheckInterval = 128;
    private final int flowerCheckTime = random.nextInt(128);
    private ChunkCoordinates flowerCoords = null;
    private int cooldown = 0;

    public boolean hasFlowers(IBee queen, IBeeHousing beeHousing) {
        IFlowerProvider flowerProvider = queen.getGenome().getFlowerProvider();
        String flowerType = flowerProvider.getFlowerType();
        World world = beeHousing.getWorld();
        if (this.flowerCoords != null) {
            if (world.func_82737_E() % 128L != (long)this.flowerCheckTime) {
                return true;
            }
            if (FlowerManager.flowerRegistry.isAcceptedFlower(flowerType, world, this.flowerCoords.field_71574_a, this.flowerCoords.field_71572_b, this.flowerCoords.field_71573_c)) {
                return true;
            }
            this.flowerCoords = null;
            this.cooldown = 0;
        }
        if (this.cooldown <= 0) {
            this.flowerCoords = FlowerManager.flowerRegistry.getAcceptedFlowerCoordinates(beeHousing, queen, flowerType);
            this.cooldown = 550;
        } else {
            --this.cooldown;
        }
        return this.flowerCoords != null;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        if (!nbttagcompound.func_74764_b(nbtKey)) {
            return;
        }
        NBTTagCompound hasFlowerCacheNBT = nbttagcompound.func_74775_l(nbtKey);
        if (hasFlowerCacheNBT.func_74764_b("flowerX")) {
            int x = hasFlowerCacheNBT.func_74762_e("flowerX");
            int y = hasFlowerCacheNBT.func_74762_e("flowerY");
            int z = hasFlowerCacheNBT.func_74762_e("flowerZ");
            this.flowerCoords = new ChunkCoordinates(x, y, z);
        }
        this.cooldown = hasFlowerCacheNBT.func_74762_e("cooldown");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        NBTTagCompound hasFlowerCacheNBT = new NBTTagCompound();
        if (this.flowerCoords != null) {
            hasFlowerCacheNBT.func_74768_a("flowerX", this.flowerCoords.field_71574_a);
            hasFlowerCacheNBT.func_74768_a("flowerY", this.flowerCoords.field_71572_b);
            hasFlowerCacheNBT.func_74768_a("flowerZ", this.flowerCoords.field_71573_c);
        }
        hasFlowerCacheNBT.func_74768_a("cooldown", this.cooldown);
        nbttagcompound.func_74782_a(nbtKey, (NBTBase)hasFlowerCacheNBT);
    }
}

